/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.File;
import java.net.MalformedURLException;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.svggen.DefaultImageHandler;
import org.apache.batik.svggen.SVGIDGenerator;
import org.w3c.dom.Element;

public abstract class AbstractImageHandlerEncoder
extends DefaultImageHandler {
    static final String ERROR_NULL_INPUT = "imageDir should not be null";
    static final String ERROR_IMAGE_DIR_DOES_NOT_EXIST = "imageDir does not exist";
    static final String ERROR_CANNOT_USE_IMAGE_DIR_AS_URL = "cannot convert imageDir to a URL value : ";
    static final AffineTransform IDENTITY = new AffineTransform();
    private String imageDir = "";
    private String urlRoot = "";

    public AbstractImageHandlerEncoder(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException(ERROR_NULL_INPUT);
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new IllegalArgumentException(ERROR_IMAGE_DIR_DOES_NOT_EXIST);
        }
        this.imageDir = string;
        if (string2 != null) {
            this.urlRoot = string2;
        } else {
            try {
                this.urlRoot = file.toURL().toString();
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException(ERROR_CANNOT_USE_IMAGE_DIR_AS_URL + malformedURLException.getMessage());
            }
        }
    }

    protected void handleHREF(Image image, Element element) {
        Dimension dimension = new Dimension(image.getWidth(null), image.getHeight(null));
        BufferedImage bufferedImage = this.buildBufferedImage(dimension);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE, bufferedImage);
        graphics2D.clip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        this.saveBufferedImageToFile(element, bufferedImage);
    }

    protected void handleHREF(RenderedImage renderedImage, Element element) {
        Dimension dimension = new Dimension(renderedImage.getWidth(), renderedImage.getHeight());
        BufferedImage bufferedImage = this.buildBufferedImage(dimension);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE, bufferedImage);
        graphics2D.clip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        graphics2D.drawRenderedImage(renderedImage, IDENTITY);
        graphics2D.dispose();
        this.saveBufferedImageToFile(element, bufferedImage);
    }

    protected void handleHREF(RenderableImage renderableImage, Element element) {
        Dimension dimension = new Dimension((int)Math.ceil(renderableImage.getWidth()), (int)Math.ceil(renderableImage.getHeight()));
        BufferedImage bufferedImage = this.buildBufferedImage(dimension);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE, bufferedImage);
        graphics2D.clip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        graphics2D.drawRenderableImage(renderableImage, IDENTITY);
        graphics2D.dispose();
        this.saveBufferedImageToFile(element, bufferedImage);
    }

    private void saveBufferedImageToFile(Element element, BufferedImage bufferedImage) {
        File file = null;
        while (file == null) {
            String string = SVGIDGenerator.generateID(this.getPrefix());
            file = new File(this.imageDir, string + this.getSuffix());
            if (!file.exists()) continue;
            file = null;
        }
        this.encodeImage(bufferedImage, file);
        element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", this.urlRoot + "/" + file.getName());
    }

    public abstract String getSuffix();

    public abstract String getPrefix();

    public abstract void encodeImage(BufferedImage var1, File var2);

    public abstract BufferedImage buildBufferedImage(Dimension var1);
}

