/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.Selectable;
import org.apache.batik.gvt.Selector;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.event.GraphicsNodeEvent;
import org.apache.batik.gvt.event.GraphicsNodeInputEvent;
import org.apache.batik.gvt.event.GraphicsNodeKeyEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.SelectionEvent;
import org.apache.batik.gvt.event.SelectionListener;

public class ConcreteTextSelector
implements Selector {
    private ArrayList listeners = null;
    private GraphicsNode selectionNode = null;
    private GraphicsNode currentNode = null;
    private int firstHit;
    private int lastHit;
    private GraphicsNodeRenderContext renderContext;
    private Graphics2D g2d;
    private AffineTransform baseTransform = new AffineTransform();

    public ConcreteTextSelector(GraphicsNodeRenderContext graphicsNodeRenderContext) {
        this.renderContext = graphicsNodeRenderContext;
    }

    public void setGraphics2D(Graphics2D graphics2D) {
        this.g2d = graphics2D;
    }

    public void setBaseTransform(AffineTransform affineTransform) {
        this.baseTransform = affineTransform;
    }

    public void mouseClicked(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        this.checkSelectGesture(graphicsNodeMouseEvent);
    }

    public void mouseDragged(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        this.checkSelectGesture(graphicsNodeMouseEvent);
    }

    public void mouseEntered(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        this.currentNode = graphicsNodeMouseEvent.getGraphicsNode();
        this.checkSelectGesture(graphicsNodeMouseEvent);
    }

    public void mouseExited(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        this.checkSelectGesture(graphicsNodeMouseEvent);
        this.currentNode = null;
    }

    public void mouseMoved(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
    }

    public void mousePressed(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        this.checkSelectGesture(graphicsNodeMouseEvent);
    }

    public void mouseReleased(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        this.checkSelectGesture(graphicsNodeMouseEvent);
    }

    public void keyPressed(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
        this.report(graphicsNodeKeyEvent, "keyPressed");
    }

    public void keyReleased(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
        this.report(graphicsNodeKeyEvent, "keyReleased");
    }

    public void keyTyped(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
        this.report(graphicsNodeKeyEvent, "keyTyped");
    }

    protected void checkSelectGesture(GraphicsNodeEvent graphicsNodeEvent) {
        GraphicsNode graphicsNode;
        GraphicsNodeMouseEvent graphicsNodeMouseEvent = null;
        if (graphicsNodeEvent instanceof GraphicsNodeMouseEvent) {
            graphicsNodeMouseEvent = (GraphicsNodeMouseEvent)graphicsNodeEvent;
        }
        if ((graphicsNode = graphicsNodeEvent.getGraphicsNode()) instanceof Selectable && graphicsNodeMouseEvent != null) {
            Point2D point2D = new Point2D.Double(graphicsNodeMouseEvent.getX(), graphicsNodeMouseEvent.getY());
            AffineTransform affineTransform = graphicsNode.getGlobalTransform();
            if (affineTransform == null) {
                affineTransform = new AffineTransform();
            } else {
                try {
                    affineTransform = affineTransform.createInverse();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            point2D = affineTransform.transform(point2D, null);
            if (this.isSelectContinueGesture(graphicsNodeEvent)) {
                if (this.selectionNode != graphicsNode) {
                    ((Selectable)((Object)graphicsNode)).selectAt(point2D.getX(), point2D.getY(), this.renderContext);
                    this.selectionNode = graphicsNode;
                } else {
                    boolean bl = ((Selectable)((Object)graphicsNode)).selectTo(point2D.getX(), point2D.getY(), this.renderContext);
                    if (bl) {
                        Shape shape = ((Selectable)((Object)graphicsNode)).getHighlightShape(this.renderContext);
                        this.dispatchSelectionEvent(new SelectionEvent(null, 1, shape));
                    }
                }
            } else if (this.isSelectStartGesture(graphicsNodeEvent)) {
                this.selectionNode = graphicsNode;
                ((Selectable)((Object)graphicsNode)).selectAt(point2D.getX(), point2D.getY(), this.renderContext);
                this.dispatchSelectionEvent(new SelectionEvent(null, 4, null));
            } else if (this.isSelectEndGesture(graphicsNodeEvent)) {
                this.selectionNode = graphicsNode;
                ((Selectable)((Object)graphicsNode)).selectTo(point2D.getX(), point2D.getY(), this.renderContext);
                Object object = this.getSelection();
                Shape shape = ((Selectable)((Object)graphicsNode)).getHighlightShape(this.renderContext);
                this.dispatchSelectionEvent(new SelectionEvent(object, 2, shape));
                this.copyToClipboard(object);
            } else if (this.isSelectAllGesture(graphicsNodeEvent)) {
                this.selectionNode = graphicsNode;
                ((Selectable)((Object)graphicsNode)).selectAll(point2D.getX(), point2D.getY(), this.renderContext);
                Object object = this.getSelection();
                Shape shape = ((Selectable)((Object)graphicsNode)).getHighlightShape(this.renderContext);
                this.dispatchSelectionEvent(new SelectionEvent(object, 2, shape));
                this.copyToClipboard(object);
            }
        }
    }

    private boolean isSelectStartGesture(GraphicsNodeEvent graphicsNodeEvent) {
        return graphicsNodeEvent.getID() == 501 || this.isMouseButton1Down(graphicsNodeEvent) && graphicsNodeEvent.getID() == 504;
    }

    private boolean isSelectEndGesture(GraphicsNodeEvent graphicsNodeEvent) {
        return graphicsNodeEvent.getID() == 502 || this.isMouseButton1Down(graphicsNodeEvent) && graphicsNodeEvent.getID() == 505;
    }

    private boolean isSelectContinueGesture(GraphicsNodeEvent graphicsNodeEvent) {
        return graphicsNodeEvent.getID() == 506;
    }

    private boolean isSelectAllGesture(GraphicsNodeEvent graphicsNodeEvent) {
        return graphicsNodeEvent.getID() == 500 && ((GraphicsNodeMouseEvent)graphicsNodeEvent).getClickCount() == 2;
    }

    private boolean isMouseButton1Down(GraphicsNodeEvent graphicsNodeEvent) {
        return (((GraphicsNodeInputEvent)graphicsNodeEvent).getModifiers() & 0x10) != 0;
    }

    public Object getSelection() {
        Object object = null;
        if (this.selectionNode instanceof Selectable) {
            object = ((Selectable)((Object)this.selectionNode)).getSelection(this.renderContext);
        }
        return object;
    }

    public boolean isEmpty() {
        return this.getSelection() == null;
    }

    public void dispatchSelectionEvent(SelectionEvent selectionEvent) {
        if (this.listeners != null) {
            Iterator iterator = ((AbstractList)this.listeners).iterator();
            switch (selectionEvent.getID()) {
                case 2: {
                    while (iterator.hasNext()) {
                        ((SelectionListener)iterator.next()).selectionDone(selectionEvent);
                    }
                    break;
                }
                case 1: {
                    while (iterator.hasNext()) {
                        ((SelectionListener)iterator.next()).selectionChanged(selectionEvent);
                    }
                    break;
                }
                case 3: {
                    while (iterator.hasNext()) {
                        ((SelectionListener)iterator.next()).selectionCleared(selectionEvent);
                    }
                    break;
                }
                case 4: {
                    while (iterator.hasNext()) {
                        ((SelectionListener)iterator.next()).selectionStarted(selectionEvent);
                    }
                    break;
                }
            }
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (this.listeners != null) {
            ((AbstractCollection)this.listeners).remove(selectionListener);
        }
    }

    private void copyToClipboard(Object object) {
        String string = "";
        if (object instanceof CharacterIterator) {
            CharacterIterator characterIterator = (CharacterIterator)object;
            char[] cArray = new char[characterIterator.getEndIndex() - characterIterator.getBeginIndex()];
            if (cArray.length > 0) {
                cArray[0] = characterIterator.first();
            }
            int n = 1;
            while (n < cArray.length) {
                cArray[n] = characterIterator.next();
                ++n;
            }
            string = new String(cArray);
            SecurityManager securityManager = System.getSecurityManager();
            boolean bl = true;
            if (securityManager != null) {
                try {
                    securityManager.checkSystemClipboardAccess();
                }
                catch (SecurityException securityException) {
                    bl = false;
                }
            }
            if (bl) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
            }
        }
    }

    private void report(GraphicsNodeEvent graphicsNodeEvent, String string) {
        GraphicsNode graphicsNode = graphicsNodeEvent.getGraphicsNode();
        String string2 = "(non-text node)";
        if (graphicsNode instanceof TextNode) {
            AttributedCharacterIterator attributedCharacterIterator = ((TextNode)graphicsNode).getAttributedCharacterIterator();
            char[] cArray = new char[attributedCharacterIterator.getEndIndex()];
            if (cArray.length > 0) {
                cArray[0] = attributedCharacterIterator.first();
            }
            int n = 1;
            while (n < cArray.length) {
                cArray[n] = attributedCharacterIterator.next();
                ++n;
            }
            string2 = new String(cArray);
        }
        System.out.println("Mouse " + string + " in " + string2);
    }
}

