/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.filter;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.PaintRable;
import org.apache.batik.ext.awt.image.renderable.SVGComposite;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TranslateRed;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.filter.GraphicsNodeRable;
import org.apache.batik.gvt.filter.GraphicsNodeRed8Bit;

public class GraphicsNodeRable8Bit
extends AbstractRable
implements GraphicsNodeRable,
PaintRable {
    private AffineTransform cachedUsr2dev = null;
    private CachableRed cachedRed = null;
    private boolean usePrimitivePaint = true;
    private GraphicsNodeRenderContext gnrc = null;
    private GraphicsNode node;

    public boolean getUsePrimitivePaint() {
        return this.usePrimitivePaint;
    }

    public void setUsePrimitivePaint(boolean bl) {
        this.usePrimitivePaint = bl;
    }

    public GraphicsNode getGraphicsNode() {
        return this.node;
    }

    public void setGraphicsNode(GraphicsNode graphicsNode) {
        if (graphicsNode == null) {
            throw new IllegalArgumentException();
        }
        this.node = graphicsNode;
    }

    public GraphicsNodeRable8Bit(GraphicsNode graphicsNode, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        if (graphicsNode == null) {
            throw new IllegalArgumentException();
        }
        this.node = graphicsNode;
        this.gnrc = graphicsNodeRenderContext;
        this.usePrimitivePaint = true;
    }

    public GraphicsNodeRable8Bit(GraphicsNode graphicsNode, boolean bl) {
        if (graphicsNode == null) {
            throw new IllegalArgumentException();
        }
        this.node = graphicsNode;
        this.usePrimitivePaint = bl;
    }

    public Rectangle2D getBounds2D() {
        if (this.usePrimitivePaint) {
            Rectangle2D rectangle2D = this.node.getPrimitiveBounds(this.getGraphicsNodeRenderContext());
            if (rectangle2D != null) {
                return (Rectangle2D)rectangle2D.clone();
            }
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        Rectangle2D rectangle2D = this.node.getBounds(this.getGraphicsNodeRenderContext());
        if (rectangle2D == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        AffineTransform affineTransform = this.node.getTransform();
        if (affineTransform != null) {
            rectangle2D = affineTransform.createTransformedShape(rectangle2D).getBounds2D();
        }
        return rectangle2D;
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean paintRable(Graphics2D graphics2D) {
        Composite composite = graphics2D.getComposite();
        if (!SVGComposite.OVER.equals(composite)) {
            return false;
        }
        ColorSpace colorSpace = GraphicsUtil.getDestinationColorSpace(graphics2D);
        if (colorSpace == null || colorSpace != ColorSpace.getInstance(1000)) {
            return false;
        }
        GraphicsNode graphicsNode = this.getGraphicsNode();
        GraphicsNodeRenderContext graphicsNodeRenderContext = GraphicsNodeRenderContext.getGraphicsNodeRenderContext(graphics2D);
        try {
            if (this.getUsePrimitivePaint()) {
                graphicsNode.primitivePaint(graphics2D, graphicsNodeRenderContext);
            } else {
                graphicsNode.paint(graphics2D, graphicsNodeRenderContext);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Rectangle2D rectangle2D;
        AffineTransform affineTransform = renderContext.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        if (this.cachedUsr2dev != null && affineTransform.getScaleX() == this.cachedUsr2dev.getScaleX() && affineTransform.getScaleY() == this.cachedUsr2dev.getScaleY() && affineTransform.getShearX() == this.cachedUsr2dev.getShearX() && affineTransform.getShearY() == this.cachedUsr2dev.getShearY()) {
            double d = affineTransform.getTranslateX() - this.cachedUsr2dev.getTranslateX();
            double d2 = affineTransform.getTranslateY() - this.cachedUsr2dev.getTranslateY();
            if (d == 0.0 && d2 == 0.0) {
                return this.cachedRed;
            }
            if (d == (double)((int)d) && d2 == (double)((int)d2)) {
                return new TranslateRed(this.cachedRed, (int)Math.round((double)this.cachedRed.getMinX() + d), (int)Math.round((double)this.cachedRed.getMinY() + d2));
            }
        }
        if ((rectangle2D = this.getBounds2D()).getWidth() > 0.0 && rectangle2D.getHeight() > 0.0) {
            this.cachedUsr2dev = (AffineTransform)affineTransform.clone();
            this.cachedRed = new GraphicsNodeRed8Bit(this.node, affineTransform, this.getGraphicsNodeRenderContext(), this.usePrimitivePaint, renderContext.getRenderingHints());
            return this.cachedRed;
        }
        return null;
    }

    protected void setGraphicsNodeRenderContext(GraphicsNodeRenderContext graphicsNodeRenderContext) {
        this.gnrc = graphicsNodeRenderContext;
    }

    protected GraphicsNodeRenderContext getGraphicsNodeRenderContext() {
        return this.gnrc;
    }
}

