/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Vector;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.Marker;
import org.apache.batik.gvt.ProxyGraphicsNode;
import org.apache.batik.gvt.ShapePainter;

public class MarkerShapePainter
implements ShapePainter {
    protected Shape shape;
    private Marker startMarker;
    private ProxyGraphicsNode startMarkerProxy;
    private Marker middleMarker;
    private ProxyGraphicsNode[] middleMarkerProxies;
    private Marker endMarker;
    private ProxyGraphicsNode endMarkerProxy;
    private Rectangle2D dPrimitiveBounds;
    private Rectangle2D dGeometryBounds;
    private CompositeGraphicsNode markerGroup = new CompositeGraphicsNode();

    public MarkerShapePainter(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
    }

    public void setStartMarker(Marker marker) {
        this.startMarker = marker;
        this.startMarkerProxy = null;
        this.buildMarkerGroup();
    }

    public void setMiddleMarker(Marker marker) {
        this.middleMarker = marker;
        this.middleMarkerProxies = null;
        this.buildMarkerGroup();
    }

    public void setEndMarker(Marker marker) {
        this.endMarker = marker;
        this.endMarkerProxy = null;
        this.buildMarkerGroup();
    }

    public Marker getStartMarker() {
        return this.startMarker;
    }

    public Marker getMiddleMarker() {
        return this.middleMarker;
    }

    public Marker getEndMarker() {
        return this.endMarker;
    }

    private void buildMarkerGroup() {
        if (this.startMarker != null && this.startMarkerProxy == null) {
            this.startMarkerProxy = this.buildStartMarkerProxy();
        }
        if (this.middleMarker != null && this.middleMarkerProxies == null) {
            this.middleMarkerProxies = this.buildMiddleMarkerProxies();
        }
        if (this.endMarker != null && this.endMarkerProxy == null) {
            this.endMarkerProxy = this.buildEndMarkerProxy();
        }
        CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
        List list = compositeGraphicsNode.getChildren();
        if (this.startMarkerProxy != null) {
            list.add(this.startMarkerProxy);
        }
        if (this.middleMarkerProxies != null) {
            int n = 0;
            while (n < this.middleMarkerProxies.length) {
                list.add(this.middleMarkerProxies[n]);
                ++n;
            }
        }
        if (this.endMarkerProxy != null) {
            list.add(this.endMarkerProxy);
        }
        this.markerGroup = compositeGraphicsNode;
    }

    public ProxyGraphicsNode buildStartMarkerProxy() {
        Object object;
        PathIterator pathIterator = this.getShape().getPathIterator(null);
        double[] dArray = new double[6];
        int n = 0;
        if (pathIterator.isDone()) {
            return null;
        }
        n = pathIterator.currentSegment(dArray);
        if (n != 0) {
            return null;
        }
        pathIterator.next();
        Point2D.Double double_ = new Point2D.Double(dArray[0], dArray[1]);
        double d = this.startMarker.getOrient();
        if (Double.isNaN(d) && !pathIterator.isDone()) {
            object = new double[6];
            int n2 = 0;
            n2 = pathIterator.currentSegment((double[])object);
            if (n2 == 4) {
                n2 = 1;
                object[0] = dArray[0];
                object[1] = dArray[1];
            }
            d = this.computeRotation(null, 0, dArray, n, (double[])object, n2);
        }
        object = this.computeMarkerTransform(this.startMarker, double_, d);
        ProxyGraphicsNode proxyGraphicsNode = new ProxyGraphicsNode();
        proxyGraphicsNode.setSource(this.startMarker.getMarkerNode());
        proxyGraphicsNode.setTransform((AffineTransform)object);
        return proxyGraphicsNode;
    }

    public ProxyGraphicsNode buildEndMarkerProxy() {
        PathIterator pathIterator = this.getShape().getPathIterator(null);
        int n = 0;
        if (pathIterator.isDone()) {
            return null;
        }
        double[] dArray = new double[6];
        double[] dArray2 = new double[2];
        int n2 = 0;
        n2 = pathIterator.currentSegment(dArray);
        if (n2 != 0) {
            return null;
        }
        ++n;
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[1];
        pathIterator.next();
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[]{dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]};
        double[] dArray5 = null;
        int n3 = n2;
        int n4 = 0;
        while (!pathIterator.isDone()) {
            dArray5 = dArray3;
            dArray3 = dArray4;
            dArray4 = dArray5;
            n4 = n3;
            n3 = pathIterator.currentSegment(dArray4);
            if (n3 == 0) {
                dArray2[0] = dArray4[0];
                dArray2[1] = dArray4[1];
            } else if (n3 == 4) {
                n3 = 1;
                dArray4[0] = dArray2[0];
                dArray4[1] = dArray2[1];
            }
            pathIterator.next();
            ++n;
        }
        if (n < 2) {
            return null;
        }
        Point2D point2D = this.getSegmentTerminatingPoint(dArray4, n3);
        double d = this.endMarker.getOrient();
        if (Double.isNaN(d)) {
            d = this.computeRotation(dArray3, n4, dArray4, n3, null, 0);
        }
        AffineTransform affineTransform = this.computeMarkerTransform(this.endMarker, point2D, d);
        ProxyGraphicsNode proxyGraphicsNode = new ProxyGraphicsNode();
        proxyGraphicsNode.setSource(this.endMarker.getMarkerNode());
        proxyGraphicsNode.setTransform(affineTransform);
        return proxyGraphicsNode;
    }

    private final Point2D getSegmentTerminatingPoint(double[] dArray, int n) {
        switch (n) {
            case 3: {
                return new Point2D.Double(dArray[4], dArray[5]);
            }
            case 1: {
                return new Point2D.Double(dArray[0], dArray[1]);
            }
            case 0: {
                return new Point2D.Double(dArray[0], dArray[1]);
            }
            case 2: {
                return new Point2D.Double(dArray[2], dArray[3]);
            }
        }
        throw new Error();
    }

    public ProxyGraphicsNode[] buildMiddleMarkerProxies() {
        PathIterator pathIterator = this.getShape().getPathIterator(null);
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (pathIterator.isDone()) {
            return null;
        }
        n = pathIterator.currentSegment(dArray);
        double[] dArray5 = new double[2];
        if (n != 0) {
            return null;
        }
        dArray5[0] = dArray[0];
        dArray5[1] = dArray[1];
        pathIterator.next();
        if (pathIterator.isDone()) {
            return null;
        }
        n2 = pathIterator.currentSegment(dArray2);
        if (n2 == 0) {
            dArray5[0] = dArray2[0];
            dArray5[1] = dArray2[1];
        } else if (n2 == 4) {
            n2 = 1;
            dArray2[0] = dArray5[0];
            dArray2[1] = dArray5[1];
        }
        pathIterator.next();
        Vector<ProxyGraphicsNode> vector = new Vector<ProxyGraphicsNode>();
        while (!pathIterator.isDone()) {
            n3 = pathIterator.currentSegment(dArray3);
            if (n3 == 0) {
                dArray5[0] = dArray3[0];
                dArray5[1] = dArray3[1];
            } else if (n3 == 4) {
                n3 = 1;
                dArray3[0] = dArray5[0];
                dArray3[1] = dArray5[1];
            }
            vector.addElement(this.createMiddleMarker(dArray, n, dArray2, n2, dArray3, n3));
            dArray4 = dArray;
            dArray = dArray2;
            n = n2;
            dArray2 = dArray3;
            n2 = n3;
            dArray3 = dArray4;
            pathIterator.next();
        }
        Object[] objectArray = new ProxyGraphicsNode[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private ProxyGraphicsNode createMiddleMarker(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        Point2D point2D = this.getSegmentTerminatingPoint(dArray2, n2);
        double d = this.middleMarker.getOrient();
        if (Double.isNaN(d)) {
            d = this.computeRotation(dArray, n, dArray2, n2, dArray3, n3);
        }
        AffineTransform affineTransform = this.computeMarkerTransform(this.middleMarker, point2D, d);
        ProxyGraphicsNode proxyGraphicsNode = new ProxyGraphicsNode();
        proxyGraphicsNode.setSource(this.middleMarker.getMarkerNode());
        proxyGraphicsNode.setTransform(affineTransform);
        return proxyGraphicsNode;
    }

    private double computeRotation(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        double[] dArray4 = this.computeInSlope(dArray, n, dArray2, n2);
        double[] dArray5 = this.computeOutSlope(dArray2, n2, dArray3, n3);
        if (dArray4 == null) {
            dArray4 = dArray5;
        }
        if (dArray5 == null) {
            dArray5 = dArray4;
        }
        if (dArray4 == null) {
            return 0.0;
        }
        double d = Math.atan2(dArray4[1], dArray4[0]) * 180.0 / Math.PI;
        double d2 = Math.atan2(dArray5[1], dArray5[0]) * 180.0 / Math.PI;
        double d3 = (d + d2) / 2.0;
        return d3;
    }

    private double[] computeInSlope(double[] dArray, int n, double[] dArray2, int n2) {
        Point2D point2D = this.getSegmentTerminatingPoint(dArray2, n2);
        double d = 0.0;
        double d2 = 0.0;
        switch (n2) {
            case 2: {
                d = point2D.getX() - dArray2[0];
                d2 = point2D.getY() - dArray2[1];
                break;
            }
            case 1: {
                Point2D point2D2 = this.getSegmentTerminatingPoint(dArray, n);
                d = point2D.getX() - point2D2.getX();
                d2 = point2D.getY() - point2D2.getY();
                break;
            }
            case 3: {
                d = point2D.getX() - dArray2[2];
                d2 = point2D.getY() - dArray2[3];
                break;
            }
            case 4: {
                throw new Error();
            }
            default: {
                return null;
            }
        }
        if (d == 0.0 && d2 == 0.0) {
            return null;
        }
        return new double[]{d, d2};
    }

    private double[] computeOutSlope(double[] dArray, int n, double[] dArray2, int n2) {
        Point2D point2D = this.getSegmentTerminatingPoint(dArray, n);
        double d = 0.0;
        double d2 = 0.0;
        switch (n2) {
            case 4: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                d = dArray2[0] - point2D.getX();
                d2 = dArray2[1] - point2D.getY();
                break;
            }
            default: {
                return null;
            }
        }
        if (d == 0.0 && d2 == 0.0) {
            return null;
        }
        return new double[]{d, d2};
    }

    private AffineTransform computeMarkerTransform(Marker marker, Point2D point2D, double d) {
        Point2D point2D2 = marker.getRef();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(point2D.getX() - point2D2.getX(), point2D.getY() - point2D2.getY());
        if (!Double.isNaN(d)) {
            affineTransform.rotate(d * Math.PI / 180.0, point2D2.getX(), point2D2.getY());
        }
        return affineTransform;
    }

    public void paint(Graphics2D graphics2D, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        try {
            if (this.markerGroup.getChildren().size() > 0) {
                this.markerGroup.paint(graphics2D, graphicsNodeRenderContext);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Shape getPaintedArea(GraphicsNodeRenderContext graphicsNodeRenderContext) {
        return this.markerGroup.getBounds(graphicsNodeRenderContext);
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        this.startMarkerProxy = null;
        this.middleMarkerProxies = null;
        this.endMarkerProxy = null;
        this.buildMarkerGroup();
    }

    public Shape getShape() {
        return this.shape;
    }
}

