/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public final class TurbulencePatternGenerator {
    private StitchInfo stitchInfo;
    private static final AffineTransform IDENTITY = new AffineTransform();
    private double baseFrequencyX;
    private double baseFrequencyY;
    private int numOctaves;
    private int seed;
    private boolean stitchTiles;
    private Rectangle2D tile;
    private boolean isFractalNoise;
    private int[] channels;
    private static final int RAND_m = Integer.MAX_VALUE;
    private static final int RAND_a = 16807;
    private static final int RAND_q = 127773;
    private static final int RAND_r = 2836;
    private static final int BSize = 256;
    private static final int BM = 255;
    private static final double PerlinN = 4096.0;
    private static final int NP = 12;
    private static final int NM = 4095;
    private final int[] latticeSelector = new int[514];
    private final double[][][] gradient = new double[4][514][2];

    public double getBaseFrequencyX() {
        return this.baseFrequencyX;
    }

    public double getBaseFrequencyY() {
        return this.baseFrequencyY;
    }

    public int getNumOctaves() {
        return this.numOctaves;
    }

    public int getSeed() {
        return this.seed;
    }

    public boolean isStitchTiles() {
        return this.stitchTiles;
    }

    public Rectangle2D getTile() {
        return (Rectangle2D)this.tile.clone();
    }

    public boolean isFractalNoise() {
        return this.isFractalNoise;
    }

    public boolean[] getChannels() {
        boolean[] blArray = new boolean[4];
        int n = 0;
        while (n < this.channels.length) {
            blArray[this.channels[n]] = true;
            ++n;
        }
        return blArray;
    }

    public final int setupSeed(int n) {
        if (n <= 0) {
            n = -(n % 0x7FFFFFFE) + 1;
        }
        if (n > 0x7FFFFFFE) {
            n = 0x7FFFFFFE;
        }
        return n;
    }

    public final int random(int n) {
        int n2 = 16807 * (n % 127773) - 2836 * (n / 127773);
        if (n2 <= 0) {
            n2 += Integer.MAX_VALUE;
        }
        return n2;
    }

    private void init(int n) {
        double d = 0.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n = this.setupSeed(n);
        n2 = 0;
        while (n2 < 256) {
            this.latticeSelector[n2] = n2;
            ++n2;
        }
        n4 = 0;
        while (n4 < 4) {
            n2 = 0;
            while (n2 < 256) {
                n3 = 0;
                while (n3 < 2) {
                    n = this.random(n);
                    this.gradient[n4][n2][n3] = (double)(n % 512 - 256) / 256.0;
                    ++n3;
                }
                d = Math.sqrt(this.gradient[n4][n2][0] * this.gradient[n4][n2][0] + this.gradient[n4][n2][1] * this.gradient[n4][n2][1]);
                double[] dArray = this.gradient[n4][n2];
                dArray[0] = dArray[0] / d;
                double[] dArray2 = this.gradient[n4][n2];
                dArray2[1] = dArray2[1] / d;
                ++n2;
            }
            ++n4;
        }
        while (--n2 > 0) {
            n4 = this.latticeSelector[n2];
            n = this.random(n);
            n3 = n % 256;
            this.latticeSelector[n2] = this.latticeSelector[n3];
            this.latticeSelector[n3] = n4;
        }
        n2 = 0;
        while (n2 < 258) {
            this.latticeSelector[256 + n2] = this.latticeSelector[n2];
            n4 = 0;
            while (n4 < 4) {
                n3 = 0;
                while (n3 < 2) {
                    this.gradient[n4][256 + n2][n3] = this.gradient[n4][n2][n3];
                    ++n3;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static final double s_curve(double d) {
        return d * d * (3.0 - 2.0 * d);
    }

    private static final double lerp(double d, double d2, double d3) {
        return d2 + d * (d3 - d2);
    }

    private final void noise2(double[] dArray, double d, double d2, int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        int n9 = 0;
        int n10 = 0;
        d11 = d + 4096.0;
        n = (int)d11 & 0xFF;
        n2 = n + 1 & 0xFF;
        d3 = d11 - (double)((int)d11);
        d4 = d3 - 1.0;
        d11 = d2 + 4096.0;
        n3 = (int)d11 & 0xFF;
        n4 = n3 + 1 & 0xFF;
        d5 = d11 - (double)((int)d11);
        d6 = d5 - 1.0;
        n9 = this.latticeSelector[n];
        n10 = this.latticeSelector[n2];
        n5 = this.latticeSelector[n9 + n3];
        n6 = this.latticeSelector[n10 + n3];
        n7 = this.latticeSelector[n9 + n4];
        n8 = this.latticeSelector[n10 + n4];
        d7 = TurbulencePatternGenerator.s_curve(d3);
        d8 = TurbulencePatternGenerator.s_curve(d5);
        n9 = 0;
        while (n9 < nArray.length) {
            double[] dArray2 = this.gradient[nArray[n9]][n5];
            d12 = d3 * dArray2[0] + d5 * dArray2[1];
            dArray2 = this.gradient[nArray[n9]][n6];
            d13 = d4 * dArray2[0] + d5 * dArray2[1];
            d9 = TurbulencePatternGenerator.lerp(d7, d12, d13);
            dArray2 = this.gradient[nArray[n9]][n7];
            d12 = d3 * dArray2[0] + d6 * dArray2[1];
            dArray2 = this.gradient[nArray[n9]][n8];
            d13 = d4 * dArray2[0] + d6 * dArray2[1];
            d10 = TurbulencePatternGenerator.lerp(d7, d12, d13);
            dArray[nArray[n9]] = TurbulencePatternGenerator.lerp(d8, d9, d10);
            ++n9;
        }
    }

    private final void noise2Stitch(double[] dArray, double d, double d2, int[] nArray, StitchInfo stitchInfo) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        int n9 = 0;
        int n10 = 0;
        d11 = d + 4096.0;
        n = (int)d11;
        n2 = n + 1;
        d3 = d11 - (double)((int)d11);
        d4 = d3 - 1.0;
        d11 = d2 + 4096.0;
        n3 = (int)d11;
        n4 = n3 + 1;
        d5 = d11 - (double)((int)d11);
        d6 = d5 - 1.0;
        n = n >= stitchInfo.wrapX ? n - stitchInfo.width : n;
        n2 = n2 >= stitchInfo.wrapX ? n2 - stitchInfo.width : n2;
        n3 = n3 >= stitchInfo.wrapY ? n3 - stitchInfo.height : n3;
        n4 = n4 >= stitchInfo.wrapY ? n4 - stitchInfo.height : n4;
        n9 = this.latticeSelector[n &= 0xFF];
        n10 = this.latticeSelector[n2 &= 0xFF];
        n5 = this.latticeSelector[n9 + (n3 &= 0xFF)];
        n6 = this.latticeSelector[n10 + n3];
        n7 = this.latticeSelector[n9 + (n4 &= 0xFF)];
        n8 = this.latticeSelector[n10 + n4];
        d7 = TurbulencePatternGenerator.s_curve(d3);
        d8 = TurbulencePatternGenerator.s_curve(d5);
        n9 = 0;
        while (n9 < nArray.length) {
            double[] dArray2 = this.gradient[nArray[n9]][n5];
            d12 = d3 * dArray2[0] + d5 * dArray2[1];
            dArray2 = this.gradient[nArray[n9]][n6];
            d13 = d4 * dArray2[0] + d5 * dArray2[1];
            d9 = TurbulencePatternGenerator.lerp(d7, d12, d13);
            dArray2 = this.gradient[nArray[n9]][n7];
            d12 = d3 * dArray2[0] + d6 * dArray2[1];
            dArray2 = this.gradient[nArray[n9]][n8];
            d13 = d4 * dArray2[0] + d6 * dArray2[1];
            d10 = TurbulencePatternGenerator.lerp(d7, d12, d13);
            dArray[nArray[n9]] = TurbulencePatternGenerator.lerp(d8, d9, d10);
            ++n9;
        }
    }

    private final void turbulence(int[] nArray, double d, double d2, double[] dArray, double[] dArray2, int n, int[] nArray2) {
        dArray2[3] = 0.0;
        dArray2[2] = 0.0;
        dArray2[1] = 0.0;
        dArray2[0] = 0.0;
        dArray[3] = 0.0;
        dArray[2] = 0.0;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        double d3 = 1.0;
        int n2 = 0;
        d *= this.baseFrequencyX;
        d2 *= this.baseFrequencyY;
        int n3 = 0;
        while (n3 < n) {
            this.noise2(dArray2, d, d2, nArray2);
            n2 = 0;
            while (n2 < nArray2.length) {
                dArray2[nArray2[n2]] = dArray2[nArray2[n2]] < 0.0 ? -dArray2[nArray2[n2]] : dArray2[nArray2[n2]];
                int n4 = nArray2[n2];
                dArray[n4] = dArray[n4] + dArray2[nArray2[n2]] / d3;
                ++n2;
            }
            d3 *= 2.0;
            d *= 2.0;
            d2 *= 2.0;
            ++n3;
        }
        nArray[3] = 0;
        nArray[2] = 0;
        nArray[1] = 0;
        nArray[0] = 0;
        n2 = 0;
        while (n2 < nArray2.length) {
            nArray[nArray2[n2]] = (int)(dArray[nArray2[n2]] * 255.0);
            nArray[nArray2[n2]] = nArray[nArray2[n2]] < 0 ? 0 : nArray[nArray2[n2]];
            nArray[nArray2[n2]] = nArray[nArray2[n2]] > 255 ? 255 : nArray[nArray2[n2]];
            ++n2;
        }
    }

    private final void turbulenceStitch(int[] nArray, double d, double d2, double[] dArray, double[] dArray2, int n, int[] nArray2) {
        dArray2[3] = 0.0;
        dArray2[2] = 0.0;
        dArray2[1] = 0.0;
        dArray2[0] = 0.0;
        dArray[3] = 0.0;
        dArray[2] = 0.0;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        double d3 = 1.0;
        int n2 = 0;
        d *= this.baseFrequencyX;
        d2 *= this.baseFrequencyY;
        StitchInfo stitchInfo = new StitchInfo(this.stitchInfo);
        int n3 = 0;
        while (n3 < n) {
            this.noise2Stitch(dArray2, d, d2, nArray2, stitchInfo);
            n2 = 0;
            while (n2 < nArray2.length) {
                dArray2[nArray2[n2]] = dArray2[nArray2[n2]] < 0.0 ? -dArray2[nArray2[n2]] : dArray2[nArray2[n2]];
                int n4 = nArray2[n2];
                dArray[n4] = dArray[n4] + dArray2[nArray2[n2]] / d3;
                ++n2;
            }
            d3 *= 2.0;
            d *= 2.0;
            d2 *= 2.0;
            stitchInfo.doubleFrequency();
            ++n3;
        }
        nArray[3] = 0;
        nArray[2] = 0;
        nArray[1] = 0;
        nArray[0] = 0;
        n2 = 0;
        while (n2 < nArray2.length) {
            nArray[nArray2[n2]] = (int)(dArray[nArray2[n2]] * 255.0);
            nArray[nArray2[n2]] = nArray[nArray2[n2]] < 0 ? 0 : nArray[nArray2[n2]];
            nArray[nArray2[n2]] = nArray[nArray2[n2]] > 255 ? 255 : nArray[nArray2[n2]];
            ++n2;
        }
    }

    private final void turbulenceFractal(int[] nArray, double d, double d2, double[] dArray, double[] dArray2, int n, int[] nArray2) {
        dArray2[3] = 0.0;
        dArray2[2] = 0.0;
        dArray2[1] = 0.0;
        dArray2[0] = 0.0;
        dArray[3] = 0.0;
        dArray[2] = 0.0;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        double d3 = 1.0;
        int n2 = 0;
        d *= this.baseFrequencyX;
        d2 *= this.baseFrequencyY;
        int n3 = 0;
        while (n3 < n) {
            this.noise2(dArray2, d, d2, nArray2);
            n2 = 0;
            while (n2 < nArray2.length) {
                int n4 = nArray2[n2];
                dArray[n4] = dArray[n4] + dArray2[nArray2[n2]] / d3;
                ++n2;
            }
            d3 *= 2.0;
            d *= 2.0;
            d2 *= 2.0;
            ++n3;
        }
        nArray[3] = 0;
        nArray[2] = 0;
        nArray[1] = 0;
        nArray[0] = 0;
        n2 = 0;
        while (n2 < nArray2.length) {
            int n5 = nArray2[n2];
            dArray[n5] = dArray[n5] + 1.0;
            int n6 = nArray2[n2];
            dArray[n6] = dArray[n6] / 2.0;
            nArray[nArray2[n2]] = (int)(dArray[nArray2[n2]] * 255.0);
            nArray[nArray2[n2]] = nArray[nArray2[n2]] < 0 ? 0 : nArray[nArray2[n2]];
            nArray[nArray2[n2]] = nArray[nArray2[n2]] > 255 ? 255 : nArray[nArray2[n2]];
            ++n2;
        }
    }

    private final void turbulenceFractalStitch(int[] nArray, double d, double d2, double[] dArray, double[] dArray2, int n, int[] nArray2) {
        dArray2[3] = 0.0;
        dArray2[2] = 0.0;
        dArray2[1] = 0.0;
        dArray2[0] = 0.0;
        dArray[3] = 0.0;
        dArray[2] = 0.0;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        double d3 = 1.0;
        int n2 = 0;
        d *= this.baseFrequencyX;
        d2 *= this.baseFrequencyY;
        StitchInfo stitchInfo = new StitchInfo(this.stitchInfo);
        int n3 = 0;
        while (n3 < n) {
            this.noise2Stitch(dArray2, d, d2, nArray2, stitchInfo);
            n2 = 0;
            while (n2 < nArray2.length) {
                int n4 = nArray2[n2];
                dArray[n4] = dArray[n4] + dArray2[nArray2[n2]] / d3;
                ++n2;
            }
            d3 *= 2.0;
            d *= 2.0;
            d2 *= 2.0;
            stitchInfo.doubleFrequency();
            ++n3;
        }
        nArray[3] = 0;
        nArray[2] = 0;
        nArray[1] = 0;
        nArray[0] = 0;
        n2 = 0;
        while (n2 < nArray2.length) {
            int n5 = nArray2[n2];
            dArray[n5] = dArray[n5] + 1.0;
            int n6 = nArray2[n2];
            dArray[n6] = dArray[n6] / 2.0;
            nArray[nArray2[n2]] = (int)(dArray[nArray2[n2]] * 255.0);
            nArray[nArray2[n2]] = nArray[nArray2[n2]] < 0 ? 0 : nArray[nArray2[n2]];
            nArray[nArray2[n2]] = nArray[nArray2[n2]] > 255 ? 255 : nArray[nArray2[n2]];
            ++n2;
        }
    }

    public void generatePattern(WritableRaster writableRaster, AffineTransform affineTransform) {
        if (affineTransform == null) {
            affineTransform = IDENTITY;
        }
        if (writableRaster == null) {
            throw new IllegalArgumentException("Cannot generate a noise pattern on a null raster");
        }
        this.checkCompatible(writableRaster.getSampleModel());
        double[] dArray = new double[]{0.5, 0.0};
        double[] dArray2 = new double[]{0.0, 0.5};
        affineTransform.deltaTransform(dArray, 0, dArray, 0, 1);
        affineTransform.deltaTransform(dArray2, 0, dArray2, 0, 1);
        double d = Math.max(Math.abs(dArray[0]), Math.abs(dArray2[0]));
        int n = -((int)Math.round((Math.log(d) + Math.log(this.baseFrequencyX)) / Math.log(2.0)));
        double d2 = Math.max(Math.abs(dArray[1]), Math.abs(dArray2[1]));
        int n2 = -((int)Math.round((Math.log(d2) + Math.log(this.baseFrequencyY)) / Math.log(2.0)));
        int n3 = this.numOctaves;
        n3 = n3 > n ? n : n3;
        int n4 = n3 = n3 > n2 ? n2 : n3;
        if (n3 < 1 && this.numOctaves > 1) {
            n3 = 1;
        }
        int n5 = writableRaster.getWidth();
        int n6 = writableRaster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n7 = writableRaster.getMinX();
        int n8 = writableRaster.getMinY();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n9 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n7 - writableRaster.getSampleModelTranslateX(), n8 - writableRaster.getSampleModelTranslateY());
        int n10 = singlePixelPackedSampleModel.getScanlineStride();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n11 = n10 - n5;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n12 = n9;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        int[] nArray5 = new int[4];
        int[] nArray6 = new int[4];
        double[] dArray3 = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] dArray4 = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] dArray5 = new double[]{1.0, 0.0};
        double[] dArray6 = new double[]{0.0, 1.0};
        affineTransform.deltaTransform(dArray5, 0, dArray5, 0, 1);
        affineTransform.deltaTransform(dArray6, 0, dArray6, 0, 1);
        double d7 = dArray5[0];
        double d8 = dArray5[1];
        double d9 = dArray6[0];
        double d10 = dArray6[1];
        double[] dArray7 = new double[]{n7, n8};
        affineTransform.transform(dArray7, 0, dArray7, 0, 1);
        if (this.isFractalNoise) {
            if (!this.stitchTiles) {
                int n13 = 0;
                while (n13 < n6) {
                    double d11 = dArray7[0];
                    double d12 = dArray7[1];
                    int n14 = 0;
                    while (n14 < n5) {
                        this.turbulenceFractal(nArray2, d11, d12, dArray3, dArray4, n3, this.channels);
                        nArray[n12] = nArray2[3] << 24 & 0xFF000000 | nArray2[0] << 16 & 0xFF0000 | nArray2[1] << 8 & 0xFF00 | nArray2[2] & 0xFF;
                        ++n12;
                        d11 += d7;
                        d12 += d8;
                        ++n14;
                    }
                    dArray7[0] = dArray7[0] + d9;
                    dArray7[1] = dArray7[1] + d10;
                    n12 += n11;
                    ++n13;
                }
            } else {
                int n15 = 0;
                while (n15 < n6) {
                    double d13 = dArray7[0];
                    double d14 = dArray7[1];
                    int n16 = 0;
                    while (n16 < n5) {
                        this.turbulenceFractalStitch(nArray2, d13, d14, dArray3, dArray4, n3, this.channels);
                        nArray[n12] = nArray2[3] << 24 & 0xFF000000 | nArray2[0] << 16 & 0xFF0000 | nArray2[1] << 8 & 0xFF00 | nArray2[2] & 0xFF;
                        ++n12;
                        d13 += d7;
                        d14 += d8;
                        ++n16;
                    }
                    dArray7[0] = dArray7[0] + d9;
                    dArray7[1] = dArray7[1] + d10;
                    n12 += n11;
                    ++n15;
                }
            }
        } else if (!this.stitchTiles) {
            int n17 = 0;
            while (n17 < n6) {
                double d15 = dArray7[0];
                double d16 = dArray7[1];
                int n18 = 0;
                while (n18 < n5) {
                    this.turbulence(nArray2, d15, d16, dArray3, dArray4, n3, this.channels);
                    nArray[n12] = nArray2[3] << 24 & 0xFF000000 | nArray2[0] << 16 & 0xFF0000 | nArray2[1] << 8 & 0xFF00 | nArray2[2] & 0xFF;
                    ++n12;
                    d15 += d7;
                    d16 += d8;
                    ++n18;
                }
                dArray7[0] = dArray7[0] + d9;
                dArray7[1] = dArray7[1] + d10;
                n12 += n11;
                ++n17;
            }
        } else {
            int n19 = 0;
            while (n19 < n6) {
                double d17 = dArray7[0];
                double d18 = dArray7[1];
                int n20 = 0;
                while (n20 < n5) {
                    this.turbulenceStitch(nArray2, d17, d18, dArray3, dArray4, n3, this.channels);
                    nArray[n12] = nArray2[3] << 24 & 0xFF000000 | nArray2[0] << 16 & 0xFF0000 | nArray2[1] << 8 & 0xFF00 | nArray2[2] & 0xFF;
                    ++n12;
                    d17 += d7;
                    d18 += d8;
                    ++n20;
                }
                dArray7[0] = dArray7[0] + d9;
                dArray7[1] = dArray7[1] + d10;
                n12 += n11;
                ++n19;
            }
        }
    }

    private void checkCompatible(SampleModel sampleModel) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            throw new IllegalArgumentException("TurbulenceOp only works with Rasters using SinglePixelPackedSampleModels");
        }
        int n = sampleModel.getNumBands();
        if (n != 4) {
            throw new IllegalArgumentException("TurbulenceOp only words with Rasters having 4 bands");
        }
        if (sampleModel.getDataType() != 3) {
            throw new IllegalArgumentException("TurbulenceOp only works with Rasters using DataBufferInts");
        }
        int[] nArray = ((SinglePixelPackedSampleModel)sampleModel).getBitOffsets();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] % 8 != 0) {
                throw new IllegalArgumentException("TurbulenceOp only works with Rasters using 8 bits per band : " + n2 + " : " + nArray[n2]);
            }
            ++n2;
        }
    }

    public TurbulencePatternGenerator(double d, double d2, int n, int n2, boolean bl, boolean bl2, Rectangle2D rectangle2D, boolean[] blArray) {
        this.baseFrequencyX = d;
        this.baseFrequencyY = d2;
        this.numOctaves = n;
        this.seed = n2;
        this.stitchTiles = bl;
        this.isFractalNoise = bl2;
        this.tile = rectangle2D;
        if (blArray == null || blArray.length == 0) {
            throw new IllegalArgumentException("Cannot process null channel array. channels should have length=4");
        }
        boolean[] blArray2 = new boolean[blArray.length];
        System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        blArray = blArray2;
        int n3 = 0;
        int n4 = 0;
        while (n4 < blArray.length) {
            if (blArray[n4]) {
                ++n3;
            }
            ++n4;
        }
        this.channels = new int[n3];
        int n5 = 0;
        int n6 = 0;
        while (n6 < blArray.length) {
            if (blArray[n6]) {
                this.channels[n5++] = n6;
            }
            ++n6;
        }
        if (bl && rectangle2D == null) {
            throw new IllegalArgumentException("tile should not be null when stitchTile is true");
        }
        if (bl) {
            double d3;
            double d4 = Math.floor(rectangle2D.getWidth() * d) / rectangle2D.getWidth();
            this.baseFrequencyX = d / d4 < (d3 = Math.ceil(rectangle2D.getWidth() * d) / rectangle2D.getWidth()) / d ? d4 : d3;
            d4 = Math.floor(rectangle2D.getHeight() * d2) / rectangle2D.getHeight();
            d3 = Math.ceil(rectangle2D.getHeight() * d2) / rectangle2D.getHeight();
            this.baseFrequencyY = d2 / d4 < d3 / d2 ? d4 : d3;
            this.stitchInfo = new StitchInfo();
            this.stitchInfo.width = (int)(rectangle2D.getWidth() * this.baseFrequencyX);
            this.stitchInfo.height = (int)(rectangle2D.getHeight() * this.baseFrequencyY);
            this.stitchInfo.wrapX = (int)(rectangle2D.getX() * this.baseFrequencyX + 4096.0 + (double)this.stitchInfo.width);
            this.stitchInfo.wrapY = (int)(rectangle2D.getY() * this.baseFrequencyY + 4096.0 + (double)this.stitchInfo.height);
            if (this.stitchInfo.width == 0) {
                this.stitchInfo.width = 1;
            }
            if (this.stitchInfo.height == 0) {
                this.stitchInfo.height = 1;
            }
        }
        this.init(n2);
    }

    static final class StitchInfo {
        int width;
        int height;
        int wrapX;
        int wrapY;

        StitchInfo() {
        }

        StitchInfo(StitchInfo stitchInfo) {
            this.width = stitchInfo.width;
            this.height = stitchInfo.height;
            this.wrapX = stitchInfo.wrapX;
            this.wrapY = stitchInfo.wrapY;
        }

        final void doubleFrequency() {
            this.width *= 2;
            this.height *= 2;
            this.wrapX *= 2;
            this.wrapY *= 2;
            this.wrapX = (int)((double)this.wrapX - 4096.0);
            this.wrapY = (int)((double)this.wrapY - 4096.0);
        }
    }
}

