/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import org.apache.batik.ext.awt.image.renderable.TransferFunction;

public class TableTransfer
implements TransferFunction {
    public byte[] lutData;
    public int[] tableValues;
    private int n;

    public TableTransfer(int[] nArray) {
        this.tableValues = nArray;
        this.n = nArray.length;
    }

    private void buildLutData() {
        this.lutData = new byte[256];
        int n = 0;
        while (n <= 255) {
            float f = (float)(n * (this.n - 1)) / 255.0f;
            int n2 = (int)Math.floor(f);
            int n3 = n2 + 1 > this.n - 1 ? this.n - 1 : n2 + 1;
            float f2 = f - (float)n2;
            this.lutData[n] = (byte)((int)((float)this.tableValues[n2] + f2 * (float)(this.tableValues[n3] - this.tableValues[n2])) & 0xFF);
            ++n;
        }
    }

    public byte[] getLookupTable() {
        this.buildLutData();
        return this.lutData;
    }
}

