/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URL;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadMode;
import org.apache.batik.ext.awt.image.renderable.URLImageCache;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;
import org.apache.batik.ext.awt.image.rendered.ProfileRed;
import org.apache.batik.ext.awt.image.rendered.RenderedImageCachableRed;
import org.apache.batik.util.Base64Decoder;

public class RasterRable
extends AbstractRable {
    public static final String BASE64 = "base64,";
    CachableRed src;
    Thread thread = null;
    static Component mediaComponent = new Label(){};
    static MediaTracker mediaTracker = new MediaTracker(mediaComponent);
    static int id = 0;

    public RasterRable(CachableRed cachableRed) {
        super((Filter)null);
        this.src = cachableRed;
    }

    public RasterRable(URL uRL, ICCColorSpaceExt iCCColorSpaceExt) {
        super((Filter)null);
        this.thread = new URLImageLoader(uRL, iCCColorSpaceExt);
        this.thread.start();
    }

    public RasterRable(String string, ICCColorSpaceExt iCCColorSpaceExt) {
        this(string, 0, string.length(), iCCColorSpaceExt);
    }

    public RasterRable(String string, int n, ICCColorSpaceExt iCCColorSpaceExt) {
        this(string, n, string.length() - n, iCCColorSpaceExt);
    }

    public RasterRable(String string, int n, int n2, ICCColorSpaceExt iCCColorSpaceExt) {
        super((Filter)null);
        this.thread = new Base64ImageLoader(string, n, n2, iCCColorSpaceExt);
        this.thread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized CachableRed getSource() {
        if (this.thread != null) {
            Thread thread = this.thread;
            synchronized (thread) {
                while (this.src == null) {
                    try {
                        this.thread.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.thread = null;
        }
        return this.src;
    }

    public Rectangle2D getBounds2D() {
        return this.getSource().getBounds();
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Shape shape;
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        if ((shape = renderContext.getAreaOfInterest()) == null) {
            shape = this.getBounds2D();
        }
        AffineTransform affineTransform = renderContext.getTransform();
        Shape shape2 = affineTransform.createTransformedShape(shape);
        AbstractRed abstractRed = new AffineRed(this.getSource(), affineTransform, renderingHints);
        abstractRed = new PadRed(abstractRed, shape2.getBounds(), PadMode.ZERO_PAD, renderingHints);
        return abstractRed;
    }

    public static Filter create(URL uRL, Rectangle2D rectangle2D, ICCColorSpaceExt iCCColorSpaceExt) {
        return new RasterRable(uRL, iCCColorSpaceExt);
    }

    public static Filter create(String string, Rectangle2D rectangle2D, ICCColorSpaceExt iCCColorSpaceExt) {
        int n = string.indexOf(BASE64);
        if (n == -1) {
            return null;
        }
        return new RasterRable(string, n += BASE64.length(), iCCColorSpaceExt);
    }

    protected class Base64ImageLoader
    extends ImageLoader {
        protected String base64Data;
        int start;
        int length;

        public Base64ImageLoader(String string, ICCColorSpaceExt iCCColorSpaceExt) {
            super(iCCColorSpaceExt);
            this.base64Data = string;
            this.start = 0;
            this.length = string.length();
        }

        public Base64ImageLoader(String string, int n, int n2, ICCColorSpaceExt iCCColorSpaceExt) {
            super(iCCColorSpaceExt);
            this.base64Data = string;
            this.start = n;
            this.length = n2;
        }

        public Image createImage() {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.base64Data.getBytes(), this.start, this.length);
                Base64Decoder base64Decoder = new Base64Decoder();
                byte[] byArray = null;
                byArray = base64Decoder.decodeBuffer(byteArrayInputStream);
                return Toolkit.getDefaultToolkit().createImage(byArray);
            }
            catch (EOFException eOFException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public RenderedImage load() {
            RenderedImage renderedImage = super.load();
            if (renderedImage != null && this.colorSpace != null) {
                renderedImage = this.applyColorProfile(renderedImage);
            }
            return renderedImage;
        }
    }

    protected class URLImageLoader
    extends ImageLoader {
        protected URL url;
        protected URLImageCache cache;

        public URLImageLoader(URL uRL, ICCColorSpaceExt iCCColorSpaceExt) {
            this(uRL, URLImageCache.getDefaultCache(), iCCColorSpaceExt);
        }

        public URLImageLoader(URL uRL, URLImageCache uRLImageCache, ICCColorSpaceExt iCCColorSpaceExt) {
            super(iCCColorSpaceExt);
            this.cache = uRLImageCache;
            this.url = uRL;
        }

        public Image createImage() {
            return Toolkit.getDefaultToolkit().createImage(this.url);
        }

        public RenderedImage load() {
            RenderedImage renderedImage = this.cache.request(this.url);
            if (renderedImage == null) {
                renderedImage = super.load();
                if (renderedImage != null) {
                    this.cache.put(this.url, renderedImage);
                } else {
                    this.cache.clear(this.url);
                }
            }
            if (renderedImage != null && this.colorSpace != null) {
                renderedImage = this.applyColorProfile(renderedImage);
            }
            return renderedImage;
        }
    }

    protected abstract class ImageLoader
    extends Thread {
        protected ICCColorSpaceExt colorSpace;

        public ImageLoader(ICCColorSpaceExt iCCColorSpaceExt) {
            this.colorSpace = iCCColorSpaceExt;
        }

        public abstract Image createImage();

        public RenderedImage load() {
            try {
                int n;
                Image image = this.createImage();
                if (image == null) {
                    return null;
                }
                if (image instanceof BufferedImage) {
                    return (BufferedImage)image;
                }
                MediaTracker mediaTracker = RasterRable.mediaTracker;
                synchronized (mediaTracker) {
                    n = id++;
                }
                RasterRable.mediaTracker.addImage(image, n);
                while (true) {
                    try {
                        RasterRable.mediaTracker.waitForID(n);
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                RasterRable.mediaTracker.removeImage(image, n);
                BufferedImage bufferedImage = null;
                bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(image, 0, 0, null);
                graphics2D.dispose();
                return bufferedImage;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public RenderedImage applyColorProfile(RenderedImage renderedImage) {
            if (this.colorSpace == null) {
                return renderedImage;
            }
            return new ProfileRed(RenderedImageCachableRed.wrap(renderedImage), this.colorSpace);
        }

        public void run() {
            Object object;
            RenderedImage renderedImage = this.load();
            if (renderedImage == null) {
                renderedImage = new BufferedImage(100, 100, 2);
                object = ((BufferedImage)renderedImage).createGraphics();
                ((Graphics)object).setColor(new Color(255, 255, 255, 190));
                ((Graphics)object).fillRect(0, 0, 100, 100);
                ((Graphics)object).setColor(Color.black);
                ((Graphics)object).drawRect(2, 2, 96, 96);
                ((Graphics2D)object).drawString("Broken Image", 6, 50);
                ((Graphics)object).dispose();
            }
            object = this;
            synchronized (object) {
                RasterRable.this.src = RenderedImageCachableRed.wrap(renderedImage);
                this.notifyAll();
            }
        }
    }
}

