/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadMode;
import org.apache.batik.ext.awt.image.renderable.PadRable;
import org.apache.batik.ext.awt.image.renderable.PaintRable;
import org.apache.batik.ext.awt.image.renderable.SVGComposite;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;

public class PadRable8Bit
extends AbstractRable
implements PadRable,
PaintRable {
    PadMode padMode;
    Rectangle2D padRect;

    public PadRable8Bit(Filter filter, Rectangle2D rectangle2D, PadMode padMode) {
        super.init(filter, null);
        this.padRect = rectangle2D;
        this.padMode = padMode;
    }

    public Filter getSource() {
        return (Filter)this.srcs.get(0);
    }

    public void setSource(Filter filter) {
        super.init(filter, null);
    }

    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.padRect.clone();
    }

    public void setPadRect(Rectangle2D rectangle2D) {
        this.padRect = rectangle2D;
    }

    public Rectangle2D getPadRect() {
        return (Rectangle2D)this.padRect.clone();
    }

    public void setPadMode(PadMode padMode) {
        this.touch();
        this.padMode = padMode;
    }

    public PadMode getPadMode() {
        return this.padMode;
    }

    public boolean paintRable(Graphics2D graphics2D) {
        Composite composite = graphics2D.getComposite();
        if (!SVGComposite.OVER.equals(composite)) {
            return false;
        }
        if (this.getPadMode() != PadMode.ZERO_PAD) {
            return false;
        }
        Rectangle2D rectangle2D = this.getPadRect();
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        GraphicsUtil.drawImage(graphics2D, this.getSource());
        graphics2D.setClip(shape);
        return true;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Object object;
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        Filter filter = this.getSource();
        Shape shape = renderContext.getAreaOfInterest();
        if (shape == null) {
            shape = this.getBounds2D();
        }
        AffineTransform affineTransform = renderContext.getTransform();
        Rectangle2D rectangle2D = filter.getBounds2D();
        Rectangle2D rectangle2D2 = this.getBounds2D();
        Rectangle2D rectangle2D3 = shape.getBounds2D();
        if (!rectangle2D3.intersects(rectangle2D2)) {
            return null;
        }
        Rectangle2D.intersect(rectangle2D3, rectangle2D2, rectangle2D3);
        RenderedImage renderedImage = null;
        if (rectangle2D3.intersects(rectangle2D)) {
            Rectangle2D.intersect(rectangle2D, rectangle2D3, rectangle2D);
            object = new RenderContext(affineTransform, rectangle2D, renderingHints);
            renderedImage = filter.createRendering((RenderContext)object);
        }
        if (renderedImage == null) {
            renderedImage = new BufferedImage(1, 1, 2);
        }
        object = GraphicsUtil.wrap(renderedImage);
        rectangle2D3 = affineTransform.createTransformedShape(rectangle2D3).getBounds2D();
        object = new PadRed((CachableRed)object, rectangle2D3.getBounds(), this.padMode, renderingHints);
        return object;
    }

    public Shape getDependencyRegion(int n, Rectangle2D rectangle2D) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("Affine only has one input");
        }
        Rectangle2D rectangle2D2 = this.getSource().getBounds2D();
        if (!rectangle2D2.intersects(rectangle2D)) {
            return new Rectangle2D.Float();
        }
        Rectangle2D.intersect(rectangle2D2, rectangle2D, rectangle2D2);
        Rectangle2D rectangle2D3 = this.getBounds2D();
        if (!rectangle2D2.intersects(rectangle2D3)) {
            return new Rectangle2D.Float();
        }
        Rectangle2D.intersect(rectangle2D2, rectangle2D3, rectangle2D2);
        return rectangle2D2;
    }

    public Shape getDirtyRegion(int n, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2;
        if (n != 0) {
            throw new IndexOutOfBoundsException("Affine only has one input");
        }
        if (!(rectangle2D = (Rectangle2D)rectangle2D.clone()).intersects(rectangle2D2 = this.getBounds2D())) {
            return new Rectangle2D.Float();
        }
        Rectangle2D.intersect(rectangle2D, rectangle2D2, rectangle2D);
        return rectangle2D;
    }
}

