/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.io.StringReader;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.util.SVGConstants;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGSVGElement;

public class DefaultUnitProcessorContext
implements UnitProcessor.Context,
SVGConstants {
    protected SVGContext context;
    protected SVGElement element;

    public DefaultUnitProcessorContext(SVGContext sVGContext, SVGElement sVGElement) {
        this.context = sVGContext;
        this.element = sVGElement;
    }

    public float getPixelToMM() {
        return this.context.getPixelToMM();
    }

    public float getMediumFontSize() {
        return 9.0f;
    }

    public CSSPrimitiveValue getFontSize(SVGElement sVGElement) {
        SVGSVGElement sVGSVGElement = sVGElement.getOwnerSVGElement();
        return UnitProcessor.getFontSize(sVGElement, sVGSVGElement.getComputedStyle(sVGElement, null));
    }

    public float getXHeight(SVGElement sVGElement) {
        return 0.5f;
    }

    public float getViewportWidth() {
        SVGSVGElement sVGSVGElement = this.element.getOwnerSVGElement();
        if (sVGSVGElement == null) {
            return this.context.getViewportWidth();
        }
        String string = sVGSVGElement.getAttributeNS(null, "width");
        LengthParser lengthParser = new LengthParser();
        UnitProcessor.UnitResolver unitResolver = new UnitProcessor.UnitResolver();
        lengthParser.setLengthHandler(unitResolver);
        lengthParser.parse(new StringReader(string));
        return UnitProcessor.svgToUserSpace(unitResolver.unit, unitResolver.value, sVGSVGElement, (short)2, this);
    }

    public float getViewportHeight() {
        SVGSVGElement sVGSVGElement = this.element.getOwnerSVGElement();
        if (sVGSVGElement == null) {
            return this.context.getViewportHeight();
        }
        String string = sVGSVGElement.getAttributeNS(null, "height");
        LengthParser lengthParser = new LengthParser();
        UnitProcessor.UnitResolver unitResolver = new UnitProcessor.UnitResolver();
        lengthParser.setLengthHandler(unitResolver);
        lengthParser.parse(new StringReader(string));
        return UnitProcessor.svgToUserSpace(unitResolver.unit, unitResolver.value, sVGSVGElement, (short)1, this);
    }
}

