/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.batik.css.CSSDOMExceptionFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.stylesheets.MediaList;

public class DOMMediaList
implements MediaList {
    protected List list = new LinkedList();

    public DOMMediaList() {
    }

    public DOMMediaList(String string) {
        this.setMediaText(string);
    }

    public String getMediaText() {
        if (this.list.size() == 0) {
            return "all";
        }
        Iterator iterator = this.list.iterator();
        String string = (String)iterator.next();
        while (iterator.hasNext()) {
            string = iterator.next() + ", " + string;
        }
        return string;
    }

    public void setMediaText(String string) throws DOMException {
        this.list.clear();
        if (!"all".equals(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                this.list.add(stringTokenizer.nextToken());
            }
        }
    }

    public int getLength() {
        return this.list.size();
    }

    public String item(int n) {
        if (n < 0 || n >= this.list.size()) {
            return null;
        }
        return (String)this.list.get(n);
    }

    public void deleteMedium(String string) throws DOMException {
        if (!this.list.remove(string)) {
            throw CSSDOMExceptionFactory.createDOMException((short)15, "medium.not.found", new Object[]{string});
        }
    }

    public void appendMedium(String string) throws DOMException {
        this.list.remove(string);
        this.list.add(string);
    }
}

