/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Vector;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.PaintBridge;
import org.apache.batik.bridge.SVGGradientBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;

public class SVGRadialGradientBridge
extends SVGGradientBridge
implements PaintBridge {
    public Paint createStrokePaint(BridgeContext bridgeContext, GraphicsNode graphicsNode, Element element, Element element2) {
        return this.createPaint(bridgeContext, graphicsNode, element, element2, "stroke-opacity");
    }

    public Paint createFillPaint(BridgeContext bridgeContext, GraphicsNode graphicsNode, Element element, Element element2) {
        return this.createPaint(bridgeContext, graphicsNode, element, element2, "fill-opacity");
    }

    protected Paint createPaint(BridgeContext bridgeContext, GraphicsNode graphicsNode, Element element, Element element2, String string) {
        Object object;
        int n;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        GraphicsNodeRenderContext graphicsNodeRenderContext = bridgeContext.getGraphicsNodeRenderContext();
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element2);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        String string7 = SVGUtilities.getChainableAttributeNS(element2, null, "gradientUnits", documentLoader);
        if (string7.length() == 0) {
            string7 = "objectBoundingBox";
        }
        if ((string6 = SVGUtilities.getChainableAttributeNS(element2, null, "cx", documentLoader)).length() == 0) {
            string6 = "50%";
        }
        if ((string5 = SVGUtilities.getChainableAttributeNS(element2, null, "cy", documentLoader)).length() == 0) {
            string5 = "50%";
        }
        if ((string4 = SVGUtilities.getChainableAttributeNS(element2, null, "r", documentLoader)).length() == 0) {
            string4 = "50%";
        }
        if ((string3 = SVGUtilities.getChainableAttributeNS(element2, null, "fx", documentLoader)).length() == 0) {
            string3 = string6;
        }
        if ((string2 = SVGUtilities.getChainableAttributeNS(element2, null, "fy", documentLoader)).length() == 0) {
            string2 = string5;
        }
        try {
            n = SVGUtilities.parseCoordinateSystem(string7);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalAttributeValueException(Messages.formatMessage("radialGradient.units.invalid", new Object[]{string7, "gradientUnits"}));
        }
        Point2D point2D = SVGUtilities.convertGradientPoint(element, "cx", string6, "cy", string5, n, defaultUnitProcessorContext);
        Point2D point2D2 = SVGUtilities.convertGradientPoint(element, "fx", string3, "fy", string2, n, defaultUnitProcessorContext);
        float f = SVGUtilities.convertGradientLength(element, "r", string4, n, defaultUnitProcessorContext);
        String string8 = SVGUtilities.getChainableAttributeNS(element2, null, "spreadMethod", documentLoader);
        if (string8.length() == 0) {
            string8 = "pad";
        }
        MultipleGradientPaint.CycleMethodEnum cycleMethodEnum = SVGGradientBridge.convertSpreadMethod(string8);
        String string9 = SVGUtilities.getChainableAttributeNS(element2, null, "gradientTransform", documentLoader);
        AffineTransform affineTransform = string9.length() == 0 ? new AffineTransform() : SVGUtilities.convertAffineTransform(string9);
        affineTransform = SVGUtilities.convertAffineTransform(affineTransform, graphicsNode, graphicsNodeRenderContext, n);
        CSSStyleDeclaration cSSStyleDeclaration2 = CSSUtilities.getComputedStyle(element);
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration2.getPropertyCSSValue(string);
        float f2 = CSSUtilities.convertOpacity(cSSPrimitiveValue);
        Vector vector = SVGGradientBridge.extractGradientStops(element2, bridgeContext, f2);
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return ((SVGGradientBridge.GradientStop)vector.get((int)0)).stopColor;
        }
        if (f == 0.0f) {
            return ((SVGGradientBridge.GradientStop)vector.lastElement()).stopColor;
        }
        int n2 = vector.size();
        float f3 = 0.0f;
        if (n2 > 0) {
            SVGGradientBridge.GradientStop gradientStop = (SVGGradientBridge.GradientStop)vector.elementAt(0);
            f3 = gradientStop.offset;
        }
        int n3 = 1;
        while (n3 < n2) {
            object = (SVGGradientBridge.GradientStop)vector.elementAt(n3);
            if (((SVGGradientBridge.GradientStop)object).offset < f3) {
                ((SVGGradientBridge.GradientStop)object).offset = f3;
            }
            f3 = ((SVGGradientBridge.GradientStop)object).offset;
            ++n3;
        }
        object = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("color-interpolation");
        MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum = RadialGradientPaint.SRGB;
        if ("linearrgb".equals(object.getStringValue())) {
            colorSpaceEnum = RadialGradientPaint.LINEAR_RGB;
        }
        RadialGradientPaint radialGradientPaint = null;
        if (n2 > 0) {
            Color[] colorArray = new Color[n2];
            float[] fArray = new float[n2];
            int n4 = 0;
            while (n4 < n2) {
                SVGGradientBridge.GradientStop gradientStop = (SVGGradientBridge.GradientStop)vector.elementAt(n4);
                colorArray[n4] = gradientStop.stopColor;
                fArray[n4] = gradientStop.offset;
                ++n4;
            }
            radialGradientPaint = new RadialGradientPaint(point2D, f, point2D2, fArray, colorArray, cycleMethodEnum, RadialGradientPaint.SRGB, affineTransform);
        }
        return radialGradientPaint;
    }
}

