/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Color;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.svg.SVGDocument;

public abstract class SVGGradientBridge
implements SVGConstants {
    protected static Vector extractGradientStops(Element element, BridgeContext bridgeContext, float f) {
        Element element2 = element;
        LinkedList<URL> linkedList = new LinkedList<URL>();
        Vector<Object> vector = new Vector<Object>();
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        while (true) {
            Object object;
            Node node = element2.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && node.getNodeName().equals("stop") && (object = SVGGradientBridge.convertGradientStop((Element)node, bridgeContext, f)) != null) {
                    vector.addElement(object);
                }
                node = node.getNextSibling();
            }
            if (vector.size() > 0) {
                return vector;
            }
            object = XLinkSupport.getXLinkHref(element2);
            if (((String)object).length() == 0) {
                return vector;
            }
            SVGDocument sVGDocument = (SVGDocument)element2.getOwnerDocument();
            URL uRL = ((SVGOMDocument)sVGDocument).getURLObject();
            try {
                Object object2;
                URL uRL2 = new URL(uRL, (String)object);
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    object2 = (URL)iterator.next();
                    if (!((URL)object2).sameFile(uRL2) || !((URL)object2).getRef().equals(uRL2.getRef())) continue;
                    throw new IllegalAttributeValueException("circular reference on " + element2);
                }
                object2 = new URIResolver(sVGDocument, documentLoader);
                element2 = ((URIResolver)object2).getElement(uRL2.toString());
                linkedList.add(uRL2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalAttributeValueException("bad url on " + (String)object);
            }
            catch (IOException iOException) {
                throw new IllegalAttributeValueException("I/O error on " + (String)object);
            }
        }
    }

    public static GradientStop convertGradientStop(Element element, BridgeContext bridgeContext, float f) {
        String string = element.getAttributeNS(null, "offset");
        if (string.length() == 0) {
            throw new IllegalAttributeValueException(Messages.formatMessage("stop.offset.required", null));
        }
        float f2 = CSSUtilities.convertRatio(string);
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        Color color = CSSUtilities.convertStopColorToPaint(element, cSSStyleDeclaration, f, bridgeContext);
        return new GradientStop(color, f2);
    }

    protected static MultipleGradientPaint.CycleMethodEnum convertSpreadMethod(String string) {
        if ("reflect".equals(string)) {
            return LinearGradientPaint.REFLECT;
        }
        if ("repeat".equals(string)) {
            return LinearGradientPaint.REPEAT;
        }
        if ("pad".equals(string)) {
            return LinearGradientPaint.NO_CYCLE;
        }
        throw new IllegalAttributeValueException(Messages.formatMessage("gradient.spreadMethod.invalid", new Object[]{string}));
    }

    public static class GradientStop {
        public Color stopColor;
        public float offset;

        public GradientStop(Color color, float f) {
            this.stopColor = color;
            this.offset = f;
        }
    }
}

