/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.regsvggen;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Calendar;
import org.apache.batik.apps.regsvggen.Painter;
import org.apache.batik.css.CSSDocumentHandler;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.ImageLoader;
import org.apache.batik.svggen.DefaultExtensionHandler;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.crimson.parser.XMLReaderImpl;
import org.apache.crimson.tree.XmlDocumentBuilder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class Main {
    static final String REGSVGGEN_DIRECTORY_NAME = "regsvggen";
    static final String REGSVGGEN_REF_DIRECTORY_NAME = "ref";
    static final String REGSVGGEN_NEW_DIRECTORY_NAME = "new";
    static final String REGSVGGEN_SVG_DIRECTORY_NAME = "svg";
    static final String REGSVGGEN_XML_DIRECTORY_NAME = "xml";
    static final String REGSVGGEN_DIFF_DIRECTORY_NAME = "diff";
    static final String REGSVGGEN_CLASSES_DIRECTORY_NAME = "classes";
    static final String REGSVGGEN_REPORT_FILE_NAME = "report";
    static final String REGSVGGEN_REPORT_FILE_EXT = "html";
    static final String REGSVGGEN_REPORT_HEAD_STRING = "<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\"> <html> <body> <center>Batik Regression Guard Tool(Regsvggen) Report</center>";
    static final String REGSVGGEN_REPORT_END_STRING = "</body> </html>";
    static final String REGSVGGEN_REPORT_NO_REGRESSION_STRING = "<p>There's no file that has regression.<br>";
    static final String CLASSPATH_SEPARATOR = System.getProperty("path.separator", ";");
    static final String FILE_SEPARATOR = System.getProperty("file.separator", "/");
    private static final String EOL = "\n";
    private static final String IMPORT = "import";
    private static final String ATTR_TEXT_AS_SHAPES = "textAsShapes";
    private static final String TEST_PACKAGE = "usecases";
    private static final String testPackage = "package usecases;\n\n";
    private static final String testImports = "import java.awt.*; \n import java.awt.image.*; \n import org.apache.batik.apps.regsvggen.Painter; \n import java.awt.geom.*; \n import java.awt.font.*; \n";
    private static final String testClassDec = " implements Painter {\n\n\tstatic final String IMAGE_DIR=\"/work/doc/svg/src/usecases/html/images/\";\n\n\tpublic void paint(Graphics2D g){";
    private static final String testFinish = "\tpublic Dimension getSize(){ \n\t\treturn new Dimension(300, 400); \n\t} \n\n}";
    private static final String testOutName = "CompileOut";
    private static final String classDir = "." + FILE_SEPARATOR + "regsvggen" + FILE_SEPARATOR + "classes";
    public static final String CSS_PARSER_CLASS_NAME = "org.w3c.flute.parser.Parser";

    public static void main(String[] stringArray) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray2 = graphicsEnvironment.getAvailableFontFamilyNames();
        int n = stringArray2 != null ? stringArray2.length : 0;
        int n2 = 0;
        while (n2 < n) {
            System.out.print(".");
            ++n2;
        }
        System.out.println();
        if (stringArray.length != 1) {
            Main.usage(System.err);
            Main.exit(1);
        }
        if (stringArray[0].equals("-help")) {
            Main.usage(System.out);
            Main.exit(0);
        } else if (stringArray[0].equals("-init")) {
            Main.init();
        } else if (stringArray[0].equals("-reset")) {
            Main.reset();
        } else if (stringArray[0].equals("-go")) {
            Main.setUp();
            Main.generateGraphics();
            Main.generateRefImages();
            Main.diffImage();
            Main.cleanUp();
        } else {
            Main.usage(System.err);
            Main.exit(1);
        }
    }

    public static void init() {
        File file = new File(REGSVGGEN_DIRECTORY_NAME);
        if (!file.exists()) {
            Main.display("Creating " + file.getAbsolutePath());
            file.mkdir();
            File file2 = new File(file, REGSVGGEN_XML_DIRECTORY_NAME);
            file2.mkdir();
            Main.display("Creating " + file2.getAbsolutePath());
            file2 = new File(file, REGSVGGEN_SVG_DIRECTORY_NAME);
            file2.mkdir();
            Main.display("Creating " + file2.getAbsolutePath());
            file2 = new File(file, REGSVGGEN_DIFF_DIRECTORY_NAME);
            file2.mkdir();
            Main.display("Creating " + file2.getAbsolutePath());
            file2 = new File(file, REGSVGGEN_NEW_DIRECTORY_NAME);
            file2.mkdir();
            Main.display("Creating temp directory: " + file2.getAbsolutePath());
            Main.exit(0);
        } else {
            Main.error(file.getAbsolutePath() + " already exists");
            Main.exit(2);
        }
    }

    public static void setUp() {
        File file = new File(REGSVGGEN_DIRECTORY_NAME);
        if (!file.exists()) {
            Main.display("The regsvggen hasn't been initilized. Use -init");
            Main.exit(2);
        } else {
            File file2 = new File(file, REGSVGGEN_REF_DIRECTORY_NAME);
            file2.mkdir();
            Main.display("Creating temp directory: " + file2.getAbsolutePath());
            file2 = new File(file, REGSVGGEN_CLASSES_DIRECTORY_NAME);
            file2.mkdir();
            Main.display("Creating temp directory:" + file2.getAbsolutePath());
        }
    }

    public static void generateGraphics() {
        File file = new File(Main.getXmlDirectory());
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            Main.error("No XML files has been found in " + file.getAbsolutePath());
            Main.exit(2);
        }
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            String string = file2.getAbsolutePath();
            String string2 = Main.getImageName(file2.getName());
            if (string.endsWith(".xml")) {
                try {
                    String string3 = Main.compileTestClass(string);
                    File file3 = new File(Main.getNewDirectory(), string2);
                    String string4 = file3.getAbsolutePath();
                    Main.createBufImage(string3, string4);
                    file3 = new File(Main.getSvgDirectory(), string2);
                    string4 = file3.getAbsolutePath().substring(0, string4.length() - 4) + ".svg";
                    Main.createSvgFile(string3, string4);
                }
                catch (Exception exception) {
                    Main.display("Error when loading classes: " + exception.toString());
                }
            }
            ++n;
        }
    }

    public static String compileTestClass(String string) throws Exception {
        Object object;
        int n;
        int n2;
        Object object2;
        Object object3;
        Object object4;
        FileReader fileReader;
        XMLReaderImpl xMLReaderImpl = new XMLReaderImpl();
        XmlDocumentBuilder xmlDocumentBuilder = new XmlDocumentBuilder();
        xMLReaderImpl.setContentHandler((ContentHandler)xmlDocumentBuilder);
        try {
            fileReader = new FileReader(string);
            object4 = new InputSource(fileReader);
            xMLReaderImpl.parse((InputSource)object4);
        }
        catch (Exception exception) {
            Main.display("Error: " + exception.toString());
        }
        fileReader = xmlDocumentBuilder.getDocument();
        object4 = fileReader.getDocumentElement();
        String string2 = object4.getAttribute(ATTR_TEXT_AS_SHAPES);
        if (string2 == null) {
            string2 = "false";
        }
        NodeList nodeList = fileReader.getElementsByTagName("javaCode");
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = nodeList.getLength();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            object3 = (Element)nodeList.item(n5);
            object2 = object3.getChildNodes();
            n2 = object2.getLength();
            n = 0;
            while (n < n2) {
                object = object2.item(n);
                Main.display("Child of type: " + object.getNodeType());
                stringBuffer.append(object.getNodeValue());
                stringBuffer.append(EOL);
                ++n;
            }
            ++n5;
        }
        Main.display("Found : " + n3 + " javaCode elements and " + n4 + " CDATA sections");
        object3 = fileReader.getElementsByTagName(IMPORT);
        object2 = new StringBuffer();
        n2 = object3.getLength();
        n = 0;
        while (n < n2) {
            object = (Element)object3.item(n);
            ((StringBuffer)object2).append(object.getFirstChild().getNodeValue());
            ((StringBuffer)object2).append(EOL);
            ++n;
        }
        Main.display("Imports: " + ((StringBuffer)object2).toString());
        object = File.createTempFile("SVGGeneratorTest", ".java");
        String string3 = ((File)object).getName().substring(0, ((File)object).getName().length() - 5);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream((File)object));
        outputStreamWriter.write(testPackage);
        outputStreamWriter.write(testImports);
        outputStreamWriter.write(((StringBuffer)object2).toString());
        outputStreamWriter.write("public class " + string3 + testClassDec);
        outputStreamWriter.write(stringBuffer.toString());
        outputStreamWriter.write("\n\t}\n\n\tpublic boolean isTextAsShapes(){ return " + string2.equalsIgnoreCase("true") + "; }\n\n");
        outputStreamWriter.write(testFinish);
        ((Writer)outputStreamWriter).flush();
        ((Writer)outputStreamWriter).close();
        String string4 = "javac -classpath ";
        string4 = string4 + System.getProperty("java.class.path") + CLASSPATH_SEPARATOR + ((File)object).getParent();
        string4 = string4 + " -d " + classDir + " " + ((File)object).getAbsolutePath();
        Main.display(string4);
        final Process process = Runtime.getRuntime().exec(string4);
        final StringWriter stringWriter = new StringWriter();
        Thread thread = new Thread(){

            public void run() {
                InputStream inputStream = process.getErrorStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                try {
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        stringWriter.write(Main.testOutName);
                        stringWriter.write(" : ");
                        stringWriter.write(string);
                        stringWriter.write(Main.EOL);
                    }
                }
                catch (IOException iOException) {
                    stringWriter.write("CompileOut compilation finished\n");
                }
            }
        };
        thread.start();
        process.waitFor();
        ((File)object).delete();
        String string5 = "usecases." + string3;
        return string5;
    }

    public static void createBufImage(String string, String string2) throws Exception {
        Class<?> clazz = Class.forName(string);
        Main.display("Loading class: " + string);
        Painter painter = null;
        try {
            painter = (Painter)clazz.newInstance();
        }
        catch (Exception exception) {
            Main.exit(1);
        }
        ImageTranscoder imageTranscoder = Main.getTranscoder();
        Dimension dimension = painter.getSize();
        BufferedImage bufferedImage = imageTranscoder.createImage(dimension.width, dimension.height);
        Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Shape shape = new Rectangle(0, 0, 300, 400);
        shape = new GeneralPath(shape);
        graphics2D.setClip(shape);
        painter.paint(graphics2D);
        graphics2D.dispose();
        try {
            imageTranscoder.writeImage(bufferedImage, new TranscoderOutput(new FileOutputStream(string2)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void createSvgFile(String string, String string2) throws Exception {
        Class<?> clazz = Class.forName(string);
        Main.display("Loading class: " + string);
        Painter painter = null;
        try {
            painter = (Painter)clazz.newInstance();
        }
        catch (Exception exception) {
            Main.exit(1);
        }
        CSSDocumentHandler.setParserClassName(CSS_PARSER_CLASS_NAME);
        DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
        String string3 = "http://www.w3.org/2000/svg";
        Document document = dOMImplementation.createDocument(string3, REGSVGGEN_SVG_DIRECTORY_NAME, null);
        DefaultExtensionHandler defaultExtensionHandler = new DefaultExtensionHandler();
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
        Dimension dimension = painter.getSize();
        sVGGraphics2D.setSVGCanvasSize(dimension);
        painter.paint(sVGGraphics2D);
        boolean bl = false;
        sVGGraphics2D.stream(string2, bl);
    }

    public static void generateRefImages() {
        File file;
        File file2 = new File(REGSVGGEN_DIRECTORY_NAME);
        if (!file2.exists()) {
            Main.error("regsvggen is not initialized. use -init first");
        }
        if ((file = new File(file2, REGSVGGEN_REF_DIRECTORY_NAME)).list().length != 0) {
            Main.error("The reference directory " + file.getAbsolutePath() + " is not empty. Use -reset first.");
            Main.exit(3);
        }
        Main.generateImages(Main.getRefDirectory(), "images from SVG files");
    }

    static void generateImages(String string, String string2) {
        File file = new File(string);
        File file2 = new File(Main.getSvgDirectory());
        ImageTranscoder imageTranscoder = Main.getTranscoder();
        File[] fileArray = file2.listFiles();
        if (fileArray == null) {
            Main.error("No SVG files has been found in " + file2.getAbsolutePath());
            Main.exit(2);
        }
        int n = 0;
        while (n < fileArray.length) {
            File file3 = fileArray[n];
            if (file3.getName().endsWith(".svg")) {
                File file4 = new File(file, Main.getImageName(file3.getName()));
                Main.display("Generating " + string2 + " " + file3.getName());
                try {
                    Main.writeImage(imageTranscoder, file3.toURL().toString(), file4.getAbsolutePath());
                }
                catch (MalformedURLException malformedURLException) {
                    Main.error("Bad URL for " + file3.getAbsolutePath() + " or " + file4.getAbsolutePath());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n;
        }
    }

    public static void diffImage() {
        File file = new File(REGSVGGEN_DIRECTORY_NAME);
        if (!file.exists()) {
            Main.error("regsvggen is not initialized. use -init first");
        }
        File file2 = new File(Main.getRefDirectory());
        File file3 = new File(Main.getNewDirectory());
        File[] fileArray = file2.listFiles();
        int[] nArray = new int[fileArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file4 = fileArray[n2];
            File file5 = new File(file3, file4.getName());
            boolean bl = Main.diffImage(file4.getAbsolutePath(), file5.getAbsolutePath());
            if (bl) {
                Main.display("Diff: " + file4.getName() + " ok");
            } else {
                nArray[n] = n2;
                Main.display("Diff: " + file4.getName() + " has regression");
                ++n;
            }
            ++n2;
        }
        Main.display("Total: " + n + "/" + fileArray.length + " corrupted");
        if (n > 0) {
            Main.generateReport(fileArray, nArray, n);
        } else {
            Main.generateReport();
        }
    }

    public static void generateReport() {
        String string = Main.computeTimeStamp();
        String string2 = "report_" + string + "." + REGSVGGEN_REPORT_FILE_EXT;
        File file = new File(REGSVGGEN_DIRECTORY_NAME);
        File file2 = new File(file, string2);
        Main.display("Creating report...");
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
            String string3 = new String();
            string3 = string3 + REGSVGGEN_REPORT_HEAD_STRING;
            string3 = string3 + REGSVGGEN_REPORT_NO_REGRESSION_STRING;
            string3 = string3 + "<p>Reported On:";
            string3 = string3 + string;
            string3 = string3 + REGSVGGEN_REPORT_END_STRING;
            printWriter.print(string3);
            printWriter.close();
            Main.display("Report finished");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void generateReport(File[] fileArray, int[] nArray, int n) {
        Object object;
        File file = new File(REGSVGGEN_DIRECTORY_NAME);
        String string = Main.computeTimeStamp();
        String string2 = "report_" + string + "." + REGSVGGEN_REPORT_FILE_EXT;
        File file2 = new File(file, string2);
        File file3 = new File(file, REGSVGGEN_DIFF_DIRECTORY_NAME);
        file3.mkdir();
        Main.display("Creating " + file3.getAbsolutePath());
        File file4 = new File(Main.getNewDirectory());
        Main.display("Creating report...");
        String string3 = new String();
        string3 = string3 + REGSVGGEN_REPORT_HEAD_STRING;
        string3 = string3 + "<p>There're ";
        string3 = string3 + String.valueOf(n);
        string3 = string3 + " file(s) that has/have regression:<p>";
        int n2 = 0;
        while (n2 < n) {
            Object object2;
            object = fileArray[nArray[n2]];
            File file5 = new File(file4, ((File)object).getName());
            File file6 = new File(file3, ((File)object).getName());
            BufferedImage bufferedImage = ImageLoader.loadImage((File)object, 2);
            BufferedImage bufferedImage2 = ImageLoader.loadImage(file5, 2);
            if (bufferedImage.getWidth() != bufferedImage2.getWidth() || bufferedImage.getHeight() != bufferedImage2.getHeight()) {
                Main.display("Error: image size changed!");
                object2 = "<br>" + String.valueOf(n2 + 1) + ".  " + ((File)object).getName() + ": image size changed!";
                string3 = string3 + (String)object2;
            } else {
                object2 = Main.getTranscoder();
                BufferedImage bufferedImage3 = ((ImageTranscoder)object2).createImage(3 * bufferedImage.getWidth(), bufferedImage.getHeight());
                Main.diffBufferedImage(bufferedImage.getRaster(), bufferedImage2.getRaster(), bufferedImage3.getRaster());
                try {
                    ((ImageTranscoder)object2).writeImage(bufferedImage3, new TranscoderOutput(new FileOutputStream(file6)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Main.display(String.valueOf(n2 + 1) + ". " + "Creating the difference image file of " + ((File)object).getName());
                try {
                    String string4 = file6.toURL().toString();
                    string3 = string3 + "<br>" + String.valueOf(n2 + 1) + ". " + "<a href=" + "\"" + string4 + "\"" + ">" + "<img src=" + "\"" + string4 + "\"" + " height=40 width=90" + " />" + "</a>";
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        string3 = string3 + "<p>Reported On: ";
        string3 = string3 + string;
        string3 = string3 + REGSVGGEN_REPORT_END_STRING;
        try {
            object = new PrintWriter(new FileWriter(file2));
            ((PrintWriter)object).print(string3);
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Main.display("Report finished");
    }

    public static void reset() {
        File file = new File(Main.getSvgDirectory());
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            Main.display("Deleting svg files " + fileArray[n].getName());
            fileArray[n].delete();
            ++n;
        }
        file = new File(Main.getDiffDirectory());
        fileArray = file.listFiles();
        int n2 = 0;
        while (n2 < fileArray.length) {
            Main.display("Deleting diff files " + fileArray[n2].getName());
            fileArray[n2].delete();
            ++n2;
        }
        file = new File(Main.getRefDirectory());
        fileArray = file.listFiles();
        if (fileArray != null) {
            int n3 = 0;
            while (n3 < fileArray.length) {
                Main.display("Deleting diff files " + fileArray[n3].getName());
                fileArray[n3].delete();
                ++n3;
            }
        }
    }

    public static void cleanUp() {
        File file = new File(Main.getRefDirectory());
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            fileArray[n].delete();
            ++n;
        }
        file.delete();
        file = new File(Main.getClassesDirectory());
        fileArray = file.listFiles();
        int n2 = 0;
        while (n2 < fileArray.length) {
            fileArray[n2].delete();
            ++n2;
        }
        file.delete();
        Main.exit(0);
    }

    static String getImageName(String string) {
        if (string.endsWith(".svg")) {
            string = string.substring(0, string.lastIndexOf(".svg"));
            string = string + ".png";
        } else if (string.endsWith(".xml")) {
            string = string.substring(0, string.lastIndexOf(".xml"));
            string = string + ".png";
        }
        return string;
    }

    public static void writeImage(ImageTranscoder imageTranscoder, String string, String string2) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            imageTranscoder.transcode(new TranscoderInput(string), new TranscoderOutput(bufferedOutputStream));
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            Main.error("while writing " + string + " to " + string2 + EOL + iOException.getMessage());
        }
        catch (Exception exception) {
            Main.error("while writing " + string + " to " + string2 + EOL + exception.getMessage());
        }
    }

    public static boolean diffImage(String string, String string2) {
        try {
            int n;
            int n2;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(new FileInputStream(string2));
            do {
                n2 = ((InputStream)bufferedInputStream).read();
                n = ((InputStream)bufferedInputStream2).read();
            } while (n2 != -1 && n != -1 && n2 == n);
            ((InputStream)bufferedInputStream).close();
            ((InputStream)bufferedInputStream2).close();
            return n2 == n;
        }
        catch (IOException iOException) {
            System.out.println("Error while diffing " + string + " and " + string2);
            return false;
        }
    }

    public static void diffBufferedImage(Raster raster, Raster raster2, Raster raster3) {
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)raster2.getDataBuffer();
        DataBufferInt dataBufferInt3 = (DataBufferInt)raster3.getDataBuffer();
        int n3 = dataBufferInt.getOffset();
        int n4 = dataBufferInt2.getOffset();
        int n5 = dataBufferInt3.getOffset();
        int n6 = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int n7 = ((SinglePixelPackedSampleModel)raster2.getSampleModel()).getScanlineStride();
        int n8 = ((SinglePixelPackedSampleModel)raster3.getSampleModel()).getScanlineStride();
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int[] nArray3 = dataBufferInt3.getBankData()[0];
        int n9 = 0;
        while (n9 < n2) {
            int n10 = n3 + n9 * n6;
            int n11 = n4 + n9 * n7;
            int n12 = n5 + n9 * n8;
            int n13 = n5 + n9 * n8 + n;
            int n14 = n5 + n9 * n8 + 2 * n;
            int n15 = 0;
            while (n15 < n) {
                int n16 = nArray[n10];
                int n17 = nArray2[n11];
                int n18 = n17 - n16;
                nArray3[n12] = n16;
                nArray3[n13] = n17;
                if (n18 != 0) {
                    n18 = -16777216;
                }
                nArray3[n14] = n18;
                ++n10;
                ++n11;
                ++n12;
                ++n13;
                ++n14;
                ++n15;
            }
            ++n9;
        }
    }

    public static String computeTimeStamp() {
        String string = "";
        Calendar calendar = Calendar.getInstance();
        string = string + String.valueOf(calendar.get(10));
        string = string + "_";
        string = string + String.valueOf(calendar.get(12));
        string = string + "_";
        string = string + String.valueOf(calendar.get(2));
        string = string + "_";
        string = string + String.valueOf(calendar.get(5));
        string = string + "_";
        string = string + String.valueOf(calendar.get(1));
        return string;
    }

    public static ImageTranscoder getTranscoder() {
        PNGTranscoder pNGTranscoder = new PNGTranscoder();
        pNGTranscoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME, "org.apache.crimson.parser.XMLReaderImpl");
        return pNGTranscoder;
    }

    public static void error(String string) {
        System.err.println("ERROR: " + string);
    }

    public static void display(String string) {
        System.out.println(string);
    }

    public static void usage(PrintStream printStream) {
        printStream.println("usage: regsvggen [-help|-init|-reset|-go]");
        printStream.println("-help   Display this message");
        printStream.println("-init   Initialize regsvggen");
        printStream.println("-reset  Remove the reference and new images");
        printStream.println("-go    Process the test cases and produce report");
    }

    public static void exit(int n) {
        System.exit(n);
    }

    public static String getXmlDirectory() {
        File file = new File(REGSVGGEN_DIRECTORY_NAME);
        return new File(file, REGSVGGEN_XML_DIRECTORY_NAME).getAbsolutePath();
    }

    public static String getRefDirectory() {
        File file = new File(REGSVGGEN_DIRECTORY_NAME);
        return new File(file, REGSVGGEN_REF_DIRECTORY_NAME).getAbsolutePath();
    }

    public static String getNewDirectory() {
        File file = new File(REGSVGGEN_DIRECTORY_NAME);
        return new File(file, REGSVGGEN_NEW_DIRECTORY_NAME).getAbsolutePath();
    }

    public static String getClassesDirectory() {
        File file = new File(REGSVGGEN_DIRECTORY_NAME);
        return new File(file, REGSVGGEN_CLASSES_DIRECTORY_NAME).getAbsolutePath();
    }

    public static String getDiffDirectory() {
        File file = new File(REGSVGGEN_DIRECTORY_NAME);
        return new File(file, REGSVGGEN_DIFF_DIRECTORY_NAME).getAbsolutePath();
    }

    public static String getSvgDirectory() {
        File file = new File(REGSVGGEN_DIRECTORY_NAME);
        return new File(file, REGSVGGEN_SVG_DIRECTORY_NAME).getAbsolutePath();
    }
}

