/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;

public class Move
extends Copy {
    public Move() {
        this.forceOverwrite = true;
    }

    protected void doFileOperations() {
        Object object;
        Enumeration<Object> enumeration;
        if (this.fileCopyMap.size() > 0) {
            this.log("Moving " + this.fileCopyMap.size() + " files to " + this.destDir.getAbsolutePath());
            enumeration = this.fileCopyMap.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                object = (String)this.fileCopyMap.get(string);
                try {
                    this.log("Moving " + string + " to " + (String)object, this.verbosity);
                    this.project.copyFile(string, (String)object, this.filtering, this.forceOverwrite);
                    File file = new File(string);
                    if (file.delete()) continue;
                    throw new BuildException("Unable to delete file " + file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    String string2 = "Failed to copy " + string + " to " + (String)object + " due to " + iOException.getMessage();
                    throw new BuildException(string2, iOException, this.location);
                }
            }
        }
        if (this.includeEmpty) {
            enumeration = this.dirCopyMap.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                object = new File((String)enumeration.nextElement());
                if (((File)object).exists()) continue;
                if (!((File)object).mkdirs()) {
                    this.log("Unable to create directory " + ((File)object).getAbsolutePath(), 0);
                    continue;
                }
                ++n;
            }
            if (n > 0) {
                this.log("Moved " + n + " empty directories to " + this.destDir.getAbsolutePath());
            }
        }
        if (this.filesets.size() > 0) {
            enumeration = this.filesets.elements();
            while (enumeration.hasMoreElements()) {
                FileSet fileSet = (FileSet)enumeration.nextElement();
                object = fileSet.getDir(this.project);
                if (!this.okToDelete((File)object)) continue;
                this.deleteDir((File)object);
            }
        }
    }

    protected boolean okToDelete(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                if (!this.okToDelete(file2)) {
                    return false;
                }
            } else {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void deleteDir(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            File file2 = new File(file, string);
            if (!file2.isDirectory()) {
                throw new BuildException("UNEXPECTED ERROR - The file " + file2.getAbsolutePath() + " should not exist!");
            }
            this.deleteDir(file2);
            ++n;
        }
        this.log("Deleting directory " + file.getAbsolutePath(), this.verbosity);
        if (!file.delete()) {
            throw new BuildException("Unable to delete directory " + file.getAbsolutePath());
        }
    }
}

