/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class DOMUtil {
    private DOMUtil() {
    }

    public static NodeList listChildNodes(Node node, NodeFilter nodeFilter, boolean bl) {
        NodeListImpl nodeListImpl = new NodeListImpl();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node2 = nodeList.item(n2);
                if (nodeFilter.accept(node2)) {
                    nodeListImpl.addElement(node2);
                }
                if (bl) {
                    NodeList nodeList2 = DOMUtil.listChildNodes(node2, nodeFilter, bl);
                    int n3 = nodeListImpl.getLength();
                    int n4 = 0;
                    while (n4 < n3) {
                        nodeListImpl.addElement(nodeList2.item(n2));
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return nodeListImpl;
    }

    public static String getNodeAttribute(Node node, String string) {
        if (node instanceof Element) {
            Element element = (Element)node;
            return element.getAttribute(string);
        }
        return null;
    }

    public static Element getChildByTagName(Node node, String string) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList.item(n2);
            if (node2 != null && node2.getNodeType() == 1 && node2.getNodeName().equals(string)) {
                return (Element)node2;
            }
            ++n2;
        }
        return null;
    }

    public static final Node importNode(Node node, Node node2) {
        Node node3 = null;
        Document document = node.getOwnerDocument();
        switch (node2.getNodeType()) {
            case 4: {
                node3 = document.createCDATASection(((CDATASection)node2).getData());
                break;
            }
            case 8: {
                node3 = document.createComment(((Comment)node2).getData());
                break;
            }
            case 11: {
                node3 = document.createDocumentFragment();
                break;
            }
            case 1: {
                Element element = document.createElement(((Element)node2).getTagName());
                node3 = element;
                NamedNodeMap namedNodeMap = node2.getAttributes();
                if (namedNodeMap == null) break;
                int n = namedNodeMap.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Attr attr = (Attr)namedNodeMap.item(n2);
                    element.setAttribute(attr.getName(), attr.getValue());
                    ++n2;
                }
                break;
            }
            case 5: {
                node3 = document.createEntityReference(node2.getNodeName());
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node2;
                node3 = document.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                break;
            }
            case 3: {
                node3 = document.createTextNode(((Text)node2).getData());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid node type: " + node2.getNodeType());
            }
        }
        try {
            NodeList nodeList = node2.getChildNodes();
            if (nodeList != null) {
                int n = nodeList.getLength();
                int n3 = 0;
                while (n3 < n) {
                    Node node4 = nodeList.item(n3);
                    if (node4 != null) {
                        DOMUtil.importNode(node3, node4);
                    }
                    ++n3;
                }
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        node.appendChild(node3);
        return node3;
    }

    public static class NodeListImpl
    extends Vector
    implements NodeList {
        public int getLength() {
            return this.size();
        }

        public Node item(int n) {
            try {
                return (Node)this.elementAt(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
    }

    public static interface NodeFilter {
        public boolean accept(Node var1);
    }
}

