/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.dom.svg.GraphicImpl;
import org.apache.fop.dom.svg.SVGArea;
import org.apache.fop.dom.svg.SVGGElementImpl;
import org.apache.fop.dom.svg.SVGImageElementImpl;
import org.apache.fop.dom.svg.SVGLengthImpl;
import org.apache.fop.dom.svg.SVGLineElementImpl;
import org.apache.fop.dom.svg.SVGPathElementImpl;
import org.apache.fop.dom.svg.SVGPathSegImpl;
import org.apache.fop.dom.svg.SVGPolygonElementImpl;
import org.apache.fop.dom.svg.SVGPolylineElementImpl;
import org.apache.fop.dom.svg.SVGTextElementImpl;
import org.apache.fop.dom.svg.SVGUseElementImpl;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageArea;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.SpanArea;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.awt.FontMetricsMapper;
import org.apache.fop.render.awt.FontSetup;
import org.apache.fop.svg.PathPoint;
import org.apache.fop.viewer.ProgressListener;
import org.apache.fop.viewer.Translator;
import org.w3c.dom.svg.SVGCircleElement;
import org.w3c.dom.svg.SVGEllipseElement;
import org.w3c.dom.svg.SVGLineElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRectElement;
import org.w3c.dom.svg.SVGTransform;

public class AWTRenderer
implements Renderer,
Printable,
Pageable {
    protected int pageWidth = 0;
    protected int pageHeight = 0;
    protected double scaleFactor = 100.0;
    protected int pageNumber = 0;
    protected AreaTree tree;
    protected ProgressListener progressListener = null;
    protected Translator res = null;
    protected Hashtable fontNames = new Hashtable();
    protected Hashtable fontStyles = new Hashtable();
    protected Color saveColor = null;
    private BufferedImage pageImage = null;
    private Graphics2D graphics = null;
    protected String currentFontName;
    protected Component parent;
    protected int currentFontSize;
    protected float currentRed = 0.0f;
    protected float currentGreen = 0.0f;
    protected float currentBlue = 0.0f;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    private int currentAreaContainerXPosition = 0;

    public AWTRenderer(Translator translator) {
        this.res = translator;
    }

    protected void addLine(int n, int n2, int n3, int n4, int n5, float f, float f2, float f3) {
        this.graphics.setColor(new Color(f, f2, f3));
        this.graphics.drawLine((int)((float)n / 1000.0f), this.pageHeight - (int)((float)n2 / 1000.0f), (int)((float)n3 / 1000.0f), this.pageHeight - (int)((float)n4 / 1000.0f));
    }

    protected void addRect(int n, int n2, int n3, int n4, float f, float f2, float f3) {
        this.graphics.setColor(new Color(f, f2, f3));
        this.graphics.drawRect((int)((float)n / 1000.0f), this.pageHeight - (int)((float)n2 / 1000.0f), (int)((float)n3 / 1000.0f), -((int)((float)n4 / 1000.0f)));
    }

    protected void addRect(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, float f5, float f6) {
        this.graphics.setColor(new Color(f, f2, f3));
        this.graphics.fill3DRect((int)((float)n / 1000.0f), this.pageHeight - (int)((float)n2 / 1000.0f), (int)((float)n3 / 1000.0f), -((int)((float)n4 / 1000.0f)), true);
    }

    public static Color colorType2Color(ColorType colorType) {
        if (colorType == null) {
            return null;
        }
        return new Color(colorType.red(), colorType.green(), colorType.blue());
    }

    public GeneralPath convertPath(SVGPathElementImpl sVGPathElementImpl, float f, float f2) {
        Vector vector = sVGPathElementImpl.pathElements;
        GeneralPath generalPath = new GeneralPath();
        float f3 = 0.0f;
        float f4 = 0.0f;
        SVGPathSegImpl sVGPathSegImpl = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SVGPathSegImpl sVGPathSegImpl2 = (SVGPathSegImpl)enumeration.nextElement();
            float[] fArray = sVGPathSegImpl2.getValues();
            float f5 = 0.0f;
            float f6 = 0.0f;
            switch (sVGPathSegImpl2.getPathSegType()) {
                case 2: {
                    f3 = fArray[0];
                    f4 = fArray[1];
                    sVGPathSegImpl = sVGPathSegImpl2;
                    generalPath.moveTo(f3 + f / 1000.0f, (float)this.pageHeight - f2 / 1000.0f + f4);
                    break;
                }
                case 3: {
                    if (sVGPathSegImpl == null) {
                        f3 = fArray[0];
                        f4 = fArray[1];
                        generalPath.moveTo(f3 + f / 1000.0f, (float)this.pageHeight - f2 / 1000.0f + f4);
                        sVGPathSegImpl = sVGPathSegImpl2;
                        break;
                    }
                    generalPath.lineTo((f3 += fArray[0]) + f / 1000.0f, (float)this.pageHeight - f2 / 1000.0f + (f4 += fArray[1]));
                    break;
                }
                case 4: {
                    f3 = fArray[0];
                    f4 = fArray[1];
                    generalPath.lineTo(f3 + f / 1000.0f, (float)this.pageHeight - f2 / 1000.0f + f4);
                    break;
                }
                case 5: {
                    generalPath.lineTo((f3 += fArray[0]) + f / 1000.0f, (float)this.pageHeight - f2 / 1000.0f + (f4 += fArray[1]));
                    break;
                }
                case 14: {
                    f4 = fArray[0];
                    generalPath.lineTo(f3 + f / 1000.0f, (float)this.pageHeight - f2 / 1000.0f + f4);
                    break;
                }
                case 15: {
                    generalPath.lineTo(f3 + f / 1000.0f, (float)this.pageHeight - f2 / 1000.0f + (f4 += fArray[0]));
                    break;
                }
                case 12: {
                    f3 = fArray[0];
                    generalPath.lineTo(f3 + f / 1000.0f, (float)this.pageHeight - f2 / 1000.0f + f4);
                    break;
                }
                case 13: {
                    generalPath.lineTo((f3 += fArray[0]) + f / 1000.0f, (float)this.pageHeight - f2 / 1000.0f + f4);
                    break;
                }
                case 6: {
                    f3 = fArray[4];
                    f4 = fArray[5];
                    f5 = fArray[2];
                    f6 = fArray[3];
                    generalPath.curveTo(f / 1000.0f + fArray[0], (float)this.pageHeight - f2 / 1000.0f + fArray[1], f / 1000.0f + f5, (float)this.pageHeight - f2 / 1000.0f + f6, f / 1000.0f + f3, (float)this.pageHeight - f2 / 1000.0f + f4);
                    break;
                }
                case 7: {
                    generalPath.curveTo(f / 1000.0f + fArray[0] + f3, (float)this.pageHeight - f2 / 1000.0f + fArray[1] + f4, f / 1000.0f + f3 + fArray[2], (float)this.pageHeight - f2 / 1000.0f + f4 + fArray[3], f / 1000.0f + f3 + fArray[4], (float)this.pageHeight - f2 / 1000.0f + f4 + fArray[5]);
                    f5 = fArray[2] + f3;
                    f6 = fArray[3] + f4;
                    f3 += fArray[4];
                    f4 += fArray[5];
                    break;
                }
                case 16: {
                    if (f5 == 0.0f) {
                        f5 = f3;
                    }
                    if (f6 == 0.0f) {
                        f6 = f4;
                    }
                    f3 = fArray[2];
                    f4 = fArray[3];
                    generalPath.curveTo(f / 1000.0f + f5, (float)this.pageHeight - f2 / 1000.0f + f6, f / 1000.0f + fArray[0], (float)this.pageHeight - f2 / 1000.0f + fArray[1], f / 1000.0f + f3, (float)this.pageHeight - f2 / 1000.0f + f4);
                    break;
                }
                case 17: {
                    if (f5 == 0.0f) {
                        f5 = f3;
                    }
                    if (f6 == 0.0f) {
                        f6 = f4;
                    }
                    generalPath.curveTo(f / 1000.0f + f5, (float)this.pageHeight - f2 / 1000.0f + f6, f / 1000.0f + f3 + fArray[0], (float)this.pageHeight - f2 / 1000.0f + f4 + fArray[1], f / 1000.0f + f3 + fArray[2], (float)this.pageHeight - f2 / 1000.0f + f4 + fArray[3]);
                    f3 += fArray[2];
                    f4 += fArray[3];
                    break;
                }
                case 8: {
                    if (f5 == 0.0f) {
                        f5 = f3;
                    }
                    if (f6 == 0.0f) {
                        f6 = f4;
                    }
                    f3 = fArray[0];
                    f4 = fArray[1];
                    f5 = 0.0f;
                    f6 = 0.0f;
                    generalPath.quadTo(f / 1000.0f + f5, (float)this.pageHeight - f2 / 1000.0f + f6, f / 1000.0f + f3, (float)this.pageHeight - f2 / 1000.0f + f4);
                    break;
                }
                case 9: {
                    if (f5 == 0.0f) {
                        f5 = f3;
                    }
                    if (f6 == 0.0f) {
                        f6 = f4;
                    }
                    generalPath.quadTo(f / 1000.0f + f5, (float)this.pageHeight - f2 / 1000.0f + f6, f / 1000.0f + f3 + fArray[0], (float)this.pageHeight - f2 / 1000.0f + f4 + fArray[1]);
                    f3 += fArray[0];
                    f4 += fArray[1];
                    f5 = 0.0f;
                    f6 = 0.0f;
                    break;
                }
                case 10: {
                    double d = fArray[0];
                    double d2 = fArray[1];
                    double d3 = fArray[2];
                    boolean bl = (double)fArray[3] == 1.0;
                    boolean bl2 = (double)fArray[4] == 1.0;
                    double d4 = f3;
                    double d5 = f4;
                    generalPath.curveTo(f / 1000.0f + f3, (float)this.pageHeight - f2 / 1000.0f + f4, f / 1000.0f + fArray[0], (float)this.pageHeight - f2 / 1000.0f + fArray[1], f / 1000.0f + fArray[5], (float)this.pageHeight - f2 / 1000.0f + fArray[6]);
                    f5 = 0.0f;
                    f6 = 0.0f;
                    f3 = fArray[5];
                    f4 = fArray[6];
                    break;
                }
                case 11: {
                    double d = fArray[0];
                    double d2 = fArray[1];
                    double d3 = fArray[2];
                    boolean bl = (double)fArray[3] == 1.0;
                    boolean bl2 = (double)fArray[4] == 1.0;
                    generalPath.curveTo(f / 1000.0f + f3, (float)this.pageHeight - f2 / 1000.0f + f4, f / 1000.0f + (fArray[0] + f3), (float)this.pageHeight - f2 / 1000.0f + (fArray[1] + f4), f / 1000.0f + (fArray[5] + f3), (float)this.pageHeight - f2 / 1000.0f + (fArray[6] + f4));
                    f5 = 0.0f;
                    f6 = 0.0f;
                    f3 += fArray[5];
                    f4 += fArray[6];
                    break;
                }
                case 1: {
                    generalPath.closePath();
                    break;
                }
            }
        }
        return generalPath;
    }

    public Polygon convertPolygon(SVGPolygonElementImpl sVGPolygonElementImpl, int n, int n2) {
        Polygon polygon = new Polygon();
        Vector vector = sVGPolygonElementImpl.points;
        int n3 = 0;
        while (n3 < vector.size()) {
            PathPoint pathPoint = (PathPoint)vector.elementAt(n3);
            polygon.addPoint((int)((float)n / 1000.0f + pathPoint.x), this.pageHeight - (int)((float)n2 / 1000.0f - pathPoint.y));
            ++n3;
        }
        return polygon;
    }

    protected DrawingInstruction createInstruction(GraphicImpl graphicImpl, Hashtable hashtable) {
        DrawingInstruction drawingInstruction = new DrawingInstruction();
        Object v = hashtable.get("fill");
        if (!(v == null || v instanceof String && v.equals("none"))) {
            drawingInstruction.fill = true;
        }
        return drawingInstruction;
    }

    private void doFrame(Area area) {
        int n = this.currentAreaContainerXPosition;
        int n2 = area.getContentWidth();
        if (area instanceof BlockArea) {
            n += ((BlockArea)area).getStartIndent();
        }
        int n3 = area.getContentHeight();
        int n4 = this.currentYPosition;
        ColorType colorType = area.getBackgroundColor();
        n -= area.getPaddingLeft();
        n4 += area.getPaddingTop();
        n2 = n2 + area.getPaddingLeft() + area.getPaddingRight();
        n3 = n3 + area.getPaddingTop() + area.getPaddingBottom();
        if (colorType != null && colorType.alpha() == 0.0f) {
            this.addRect(n, n4, n2, -n3, colorType.red(), colorType.green(), colorType.blue(), colorType.red(), colorType.green(), colorType.blue());
        }
        n -= area.borderWidthLeft;
        n4 += area.borderWidthTop;
        n2 = n2 + area.borderWidthLeft + area.borderWidthRight;
        n3 = n3 + area.borderWidthTop + area.borderWidthBottom;
        if (area.borderWidthTop != 0) {
            this.addLine(n, n4, n + n2, n4, area.borderWidthTop, area.borderColorTop.red(), area.borderColorTop.green(), area.borderColorTop.blue());
        }
        if (area.borderWidthLeft != 0) {
            this.addLine(n, n4, n, n4 - n3, area.borderWidthLeft, area.borderColorLeft.red(), area.borderColorLeft.green(), area.borderColorLeft.blue());
        }
        if (area.borderWidthRight != 0) {
            this.addLine(n + n2, n4, n + n2, n4 - n3, area.borderWidthRight, area.borderColorRight.red(), area.borderColorRight.green(), area.borderColorRight.blue());
        }
        if (area.borderWidthBottom != 0) {
            this.addLine(n, n4 - n3, n + n2, n4 - n3, area.borderWidthBottom, area.borderColorBottom.red(), area.borderColorBottom.green(), area.borderColorBottom.blue());
        }
    }

    protected void drawFrame() {
        int n = this.pageWidth;
        int n2 = this.pageHeight;
        this.graphics.setColor(Color.white);
        this.graphics.fillRect(0, 0, n, n2);
        this.graphics.setColor(Color.black);
        this.graphics.drawRect(-1, -1, n + 2, n2 + 2);
        this.graphics.drawLine(n + 2, 0, n + 2, n2 + 2);
        this.graphics.drawLine(n + 3, 1, n + 3, n2 + 3);
        this.graphics.drawLine(0, n2 + 2, n + 2, n2 + 2);
        this.graphics.drawLine(1, n2 + 3, n + 3, n2 + 3);
    }

    protected void drawShape(Shape shape, DrawingInstruction drawingInstruction) {
        if (drawingInstruction.fill) {
            this.graphics.fill(shape);
        } else {
            this.graphics.draw(shape);
        }
    }

    protected Rectangle2D getBounds(Area area) {
        return new Rectangle2D.Double(this.currentAreaContainerXPosition, this.currentYPosition, area.getAllocationWidth(), area.getHeight());
    }

    public BufferedImage getLastRenderedPage() {
        return this.pageImage;
    }

    public int getNumberOfPages() {
        return this.tree.getPages().size();
    }

    public int getPageCount() {
        if (this.tree == null) {
            return 0;
        }
        return this.tree.getPages().size();
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        if (n >= this.tree.getPages().size()) {
            return null;
        }
        Page page = (Page)this.tree.getPages().elementAt(n);
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        paper.setImageableArea(0.0, 0.0, (double)page.getWidth() / 1000.0, (double)page.getHeight() / 1000.0);
        paper.setSize((double)page.getWidth() / 1000.0, (double)page.getHeight() / 1000.0);
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= this.tree.getPages().size()) {
            return 1;
        }
        Graphics2D graphics2D = this.graphics;
        int n2 = this.pageNumber;
        this.graphics = (Graphics2D)graphics;
        Page page = (Page)this.tree.getPages().elementAt(n);
        this.renderPage(page);
        this.graphics = graphics2D;
        return 0;
    }

    public void render(int n) {
        block2: {
            if (this.tree == null) break block2;
            try {
                this.render(this.tree, n);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void render(AreaTree areaTree, int n) throws IOException {
        this.tree = areaTree;
        Page page = (Page)areaTree.getPages().elementAt(n);
        this.pageWidth = (int)((float)page.getWidth() / 1000.0f);
        this.pageHeight = (int)((float)page.getHeight() / 1000.0f);
        this.pageImage = new BufferedImage(this.pageWidth * (int)this.scaleFactor / 100, this.pageHeight * (int)this.scaleFactor / 100, 1);
        this.graphics = this.pageImage.createGraphics();
        this.transform(this.graphics, this.scaleFactor, 0.0);
        this.drawFrame();
        this.renderPage(page);
    }

    public void render(AreaTree areaTree, OutputStream outputStream) throws IOException {
        this.tree = areaTree;
        this.render(areaTree, 0);
    }

    public void renderAreaContainer(AreaContainer areaContainer) {
        int n = this.currentYPosition;
        int n2 = this.currentAreaContainerXPosition;
        if (areaContainer.getPosition() == 3) {
            this.currentYPosition = areaContainer.getYPosition() - 2 * areaContainer.getPaddingTop() - 2 * areaContainer.borderWidthTop;
            this.currentAreaContainerXPosition = areaContainer.getXPosition();
        } else if (areaContainer.getPosition() == 2) {
            this.currentYPosition -= areaContainer.getYPosition();
            this.currentAreaContainerXPosition += areaContainer.getXPosition();
        } else if (areaContainer.getPosition() == 1) {
            this.currentYPosition -= areaContainer.getPaddingTop() + areaContainer.borderWidthTop;
            this.currentAreaContainerXPosition += areaContainer.getPaddingLeft() + areaContainer.borderWidthLeft;
        }
        this.doFrame(areaContainer);
        Enumeration enumeration = areaContainer.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        if (areaContainer.getPosition() != 1) {
            this.currentYPosition = n;
            this.currentAreaContainerXPosition = n2;
        } else {
            this.currentYPosition -= areaContainer.getHeight();
        }
    }

    public void renderBlockArea(BlockArea blockArea) {
        this.doFrame(blockArea);
        Enumeration enumeration = blockArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
    }

    public void renderBodyAreaContainer(BodyAreaContainer bodyAreaContainer) {
        this.renderAreaContainer(bodyAreaContainer.getBeforeFloatReferenceArea());
        this.renderAreaContainer(bodyAreaContainer.getFootnoteReferenceArea());
        Enumeration enumeration = bodyAreaContainer.getMainReferenceArea().getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
    }

    public void renderDisplaySpace(DisplaySpace displaySpace) {
        int n = displaySpace.getSize();
        this.currentYPosition -= n;
    }

    public void renderElement(SVGArea sVGArea, GraphicImpl graphicImpl, int n, int n2, Vector vector) {
        int n3 = n;
        int n4 = n2;
        Hashtable hashtable = graphicImpl.oldgetStyle();
        DrawingInstruction drawingInstruction = this.createInstruction(graphicImpl, hashtable);
        Object var10_10 = null;
        Vector vector2 = graphicImpl.oldgetTransform();
        vector2 = vector2 == null ? new Vector() : vector2;
        Vector vector3 = new Vector(vector2);
        Vector vector4 = vector = vector == null ? new Vector() : vector;
        if (vector != null) {
            vector3.addAll(0, vector);
        }
        float f = this.graphics.getColor().getRed();
        float f2 = this.graphics.getColor().getGreen();
        float f3 = this.graphics.getColor().getBlue();
        Color color = null;
        ColorType colorType = null;
        try {
            var10_10 = hashtable.get("fill");
            if (var10_10 != null && var10_10 instanceof ColorType) {
                colorType = var10_10;
                color = new Color((int)(colorType.red() * 255.0f), (int)(colorType.green() * 255.0f), (int)(colorType.blue() * 255.0f));
            }
            var10_10 = hashtable.get("stroke");
            if (color == null && var10_10 != null && var10_10 instanceof ColorType) {
                colorType = var10_10;
                color = new Color((int)(colorType.red() * 255.0f), (int)(colorType.green() * 255.0f), (int)(colorType.blue() * 255.0f));
            }
        }
        catch (Exception exception) {
            MessageHandler.errorln("Can't set color: R G B : " + (int)(colorType.red() * 255.0f) + " " + (int)(colorType.green() * 255.0f) + " " + (int)(colorType.blue() * 255.0f));
            color = Color.pink;
        }
        if (color == null) {
            color = new Color((int)f, (int)f2, (int)f3);
        }
        Color color2 = this.graphics.getColor();
        if (graphicImpl instanceof SVGLineElement) {
            this.graphics.setColor(color);
            SVGLineElementImpl sVGLineElementImpl = (SVGLineElementImpl)((Object)graphicImpl);
            float f4 = sVGLineElementImpl.getX1().getBaseVal().getValue() * 1000.0f + (float)n;
            float f5 = (float)n2 - sVGLineElementImpl.getY1().getBaseVal().getValue() * 1000.0f;
            float f6 = sVGLineElementImpl.getX2().getBaseVal().getValue() * 1000.0f + (float)n;
            float f7 = (float)n2 - sVGLineElementImpl.getY2().getBaseVal().getValue() * 1000.0f;
            int n5 = 1;
            var10_10 = hashtable.get("stroke-width");
            if (var10_10 != null) {
                n5 = (int)((SVGLengthImpl)var10_10).getValue();
            }
            Line2D.Double double_ = new Line2D.Double(f4 / 1000.0f, (float)this.pageHeight - f5 / 1000.0f, f6 / 1000.0f, (float)this.pageHeight - f7 / 1000.0f);
            this.drawShape(this.transformShape(vector3, double_), drawingInstruction);
            this.graphics.setColor(color2);
        } else if (graphicImpl instanceof SVGRectElement) {
            this.graphics.setColor(color);
            SVGRectElement sVGRectElement = (SVGRectElement)graphicImpl;
            float f8 = sVGRectElement.getX().getBaseVal().getValue() * 1000.0f + (float)n;
            float f9 = (float)n2 - sVGRectElement.getY().getBaseVal().getValue() * 1000.0f;
            float f10 = sVGRectElement.getRx().getBaseVal().getValue() * 1000.0f;
            float f11 = sVGRectElement.getRy().getBaseVal().getValue() * 1000.0f;
            float f12 = sVGRectElement.getWidth().getBaseVal().getValue() * 1000.0f;
            float f13 = sVGRectElement.getHeight().getBaseVal().getValue() * 1000.0f;
            Rectangle rectangle = new Rectangle();
            rectangle.setRect((double)f8 / 1000.0, (double)this.pageHeight - (double)f9 / 1000.0, (double)f12 / 1000.0, (double)f13 / 1000.0);
            this.drawShape(this.transformShape(vector3, rectangle), drawingInstruction);
            this.graphics.setColor(color2);
        } else if (graphicImpl instanceof SVGCircleElement) {
            this.graphics.setColor(color);
            SVGCircleElement sVGCircleElement = (SVGCircleElement)graphicImpl;
            float f14 = sVGCircleElement.getCx().getBaseVal().getValue() * 1000.0f + (float)n;
            float f15 = (float)n2 - sVGCircleElement.getCy().getBaseVal().getValue() * 1000.0f;
            float f16 = sVGCircleElement.getR().getBaseVal().getValue();
            Ellipse2D.Double double_ = new Ellipse2D.Double((double)f14 / 1000.0 - (double)f16, (double)this.pageHeight - (double)f15 / 1000.0 - (double)f16, (double)f16 * 2.0, (double)f16 * 2.0);
            this.drawShape(this.transformShape(vector3, double_), drawingInstruction);
            this.graphics.setColor(color2);
        } else if (graphicImpl instanceof SVGEllipseElement) {
            this.graphics.setColor(color);
            SVGEllipseElement sVGEllipseElement = (SVGEllipseElement)graphicImpl;
            float f17 = sVGEllipseElement.getCx().getBaseVal().getValue() * 1000.0f + (float)n;
            float f18 = (float)n2 - sVGEllipseElement.getCy().getBaseVal().getValue() * 1000.0f;
            float f19 = sVGEllipseElement.getRx().getBaseVal().getValue();
            float f20 = sVGEllipseElement.getRy().getBaseVal().getValue();
            Ellipse2D.Double double_ = new Ellipse2D.Double((double)f17 / 1000.0 - (double)f19, (double)this.pageHeight - (double)f18 / 1000.0 - (double)f20, (double)f19 * 2.0, (double)f20 * 2.0);
            this.drawShape(this.transformShape(vector3, double_), drawingInstruction);
            this.graphics.setColor(color2);
        } else if (graphicImpl instanceof SVGImageElementImpl) {
            SVGImageElementImpl sVGImageElementImpl = (SVGImageElementImpl)((Object)graphicImpl);
            this.renderImage(sVGImageElementImpl.link, sVGImageElementImpl.x + (float)n / 1000.0f, (float)this.pageHeight - ((float)n2 / 1000.0f - sVGImageElementImpl.y), sVGImageElementImpl.width, sVGImageElementImpl.height, vector3);
        } else if (graphicImpl instanceof SVGUseElementImpl) {
            SVGUseElementImpl sVGUseElementImpl = (SVGUseElementImpl)((Object)graphicImpl);
            String string = sVGUseElementImpl.link;
            string = string.substring(1, string.length());
            GraphicImpl graphicImpl2 = null;
            if (graphicImpl2 != null) {
                this.renderElement(sVGArea, graphicImpl2, n, n2, vector3);
            }
        } else if (graphicImpl instanceof SVGPolylineElementImpl) {
            this.graphics.setColor(color);
            Vector vector5 = ((SVGPolylineElementImpl)((Object)graphicImpl)).points;
            PathPoint pathPoint = null;
            Point2D.Double double_ = null;
            Point2D.Double double_2 = null;
            if (vector5.size() > 0) {
                pathPoint = (PathPoint)vector5.elementAt(0);
                double d = pathPoint.x * 1000.0f + (float)n;
                double d2 = (float)n2 - pathPoint.y * 1000.0f;
                double_ = new Point2D.Double(d / 1000.0, (double)this.pageHeight - d2 / 1000.0);
                int[] nArray = new int[]{(int)d};
                int[] nArray2 = new int[]{(int)d2};
                this.graphics.drawPolyline(nArray, nArray2, 1);
            }
            int n6 = 1;
            while (n6 < vector5.size()) {
                pathPoint = (PathPoint)vector5.elementAt(n6);
                double_2 = new Point2D.Double(pathPoint.x + (float)n / 1000.0f, (float)this.pageHeight - ((float)n2 - pathPoint.y * 1000.0f) / 1000.0f);
                Line2D.Double double_3 = new Line2D.Double(double_, double_2);
                this.graphics.draw(this.transformShape(vector3, double_3));
                double_ = double_2;
                ++n6;
            }
            this.graphics.setColor(color2);
        } else if (graphicImpl instanceof SVGPolygonElementImpl) {
            this.graphics.setColor(color);
            Polygon polygon = this.convertPolygon((SVGPolygonElementImpl)((Object)graphicImpl), n, n2);
            this.drawShape(this.transformShape(vector3, polygon), drawingInstruction);
            this.graphics.setColor(color2);
        } else if (graphicImpl instanceof SVGGElementImpl) {
            this.renderGArea(sVGArea, (SVGGElementImpl)((Object)graphicImpl), n3, n4, vector);
        } else if (graphicImpl instanceof SVGPathElementImpl) {
            this.graphics.setColor(color);
            GeneralPath generalPath = this.convertPath((SVGPathElementImpl)((Object)graphicImpl), n, n2);
            this.drawShape(this.transformShape(vector3, generalPath), drawingInstruction);
            this.graphics.setColor(color2);
        } else if (graphicImpl instanceof SVGTextElementImpl) {
            MessageHandler.errorln("SVGTextElementImpl  is not implemented yet.");
        } else if (graphicImpl instanceof SVGArea) {
            Enumeration enumeration = ((SVGArea)((Object)graphicImpl)).getChildren().elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(var10_10 instanceof GraphicImpl)) continue;
                this.renderElement((SVGArea)((Object)graphicImpl), (GraphicImpl)e, n3, n4, vector);
            }
        }
    }

    public void renderForeignObjectArea(ForeignObjectArea foreignObjectArea) {
        foreignObjectArea.getObject().render(this);
    }

    public void renderGArea(SVGArea sVGArea, SVGGElementImpl sVGGElementImpl, int n, int n2) {
        this.renderGArea(sVGArea, sVGGElementImpl, n, n2, new Vector());
    }

    public void renderGArea(SVGArea sVGArea, SVGGElementImpl sVGGElementImpl, int n, int n2, Vector vector) {
        Object var6_6 = null;
    }

    public void renderImage(String string, float f, float f2, float f3, float f4, Vector vector) {
        try {
            Object object;
            Object object2;
            URL uRL = new URL(string);
            ImageIcon imageIcon = new ImageIcon(uRL);
            AffineTransform affineTransform = new AffineTransform();
            vector = vector == null ? new Vector() : vector;
            int n = 0;
            while (n < vector.size()) {
                object2 = (SVGTransform)vector.elementAt(n);
                object = object2.getMatrix();
                AffineTransform affineTransform2 = new AffineTransform(object.getA(), object.getB(), object.getC(), object.getD(), object.getE(), object.getF());
                affineTransform.concatenate(affineTransform2);
                ++n;
            }
            object2 = new BufferedImage((int)f3, (int)f4, 1);
            object = ((BufferedImage)object2).createGraphics();
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
            ((Graphics)object).drawImage(imageIcon.getImage(), 0, 0, (int)f3, (int)f4, imageIcon.getImageObserver());
            this.graphics.drawImage((BufferedImage)object2, affineTransformOp, (int)f, (int)f2);
        }
        catch (Exception exception) {
            MessageHandler.errorln("AWTRenderer: renderImage(): " + exception.getMessage());
        }
    }

    public void renderImageArea(ImageArea imageArea) {
        int n = this.currentAreaContainerXPosition + imageArea.getXOffset();
        int n2 = this.currentYPosition;
        int n3 = imageArea.getContentWidth();
        int n4 = imageArea.getHeight();
        FopImage fopImage = imageArea.getImage();
        if (fopImage == null) {
            MessageHandler.logln("Error while loading image : area.getImage() is null");
            this.graphics.drawRect(n / 1000, this.pageHeight - n2 / 1000, n3 / 1000, n4 / 1000);
            Font font = this.graphics.getFont();
            Font font2 = new Font(font.getFontName(), font.getStyle(), 8);
            this.graphics.setFont(font2);
            this.graphics.drawString("area.getImage() is null", n / 1000, this.pageHeight - n2 / 1000);
            this.graphics.setFont(font);
        } else {
            String string = fopImage.getURL();
            try {
                URL uRL = new URL(string);
                ImageIcon imageIcon = new ImageIcon(uRL);
                Image image = imageIcon.getImage();
                this.graphics.drawImage(image, n / 1000, this.pageHeight - n2 / 1000, n3 / 1000, n4 / 1000, null);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.currentYPosition -= n4;
    }

    public void renderInlineSpace(InlineSpace inlineSpace) {
        this.currentXPosition += inlineSpace.getSize();
    }

    public void renderLeaderArea(LeaderArea leaderArea) {
        int n = this.currentXPosition;
        int n2 = this.currentYPosition;
        int n3 = leaderArea.getLeaderLength();
        int n4 = leaderArea.getHeight();
        int n5 = leaderArea.getRuleThickness();
        int n6 = leaderArea.getRuleStyle();
        float f = leaderArea.getRed();
        float f2 = leaderArea.getGreen();
        float f3 = leaderArea.getBlue();
        Color color = this.graphics.getColor();
        this.graphics.setColor(new Color(f, f2, f3));
        this.graphics.fillRect((int)((float)n / 1000.0f), (int)((float)this.pageHeight - (float)n2 / 1000.0f), (int)((float)n3 / 1000.0f), (int)((float)n5 / 1000.0f));
        this.graphics.setColor(color);
        this.currentXPosition += leaderArea.getContentWidth();
    }

    public void renderLineArea(LineArea lineArea) {
        int n = this.currentAreaContainerXPosition + lineArea.getStartIndent();
        int n2 = this.currentYPosition;
        int n3 = lineArea.getContentWidth();
        int n4 = lineArea.getHeight();
        this.currentYPosition -= lineArea.getPlacementOffset();
        this.currentXPosition = n;
        int n5 = this.currentYPosition;
        Enumeration enumeration = lineArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        this.currentYPosition = n2 - n4;
    }

    public void renderPage(Page page) {
        BodyAreaContainer bodyAreaContainer = page.getBody();
        AreaContainer areaContainer = page.getBefore();
        AreaContainer areaContainer2 = page.getAfter();
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.renderBodyAreaContainer(bodyAreaContainer);
        if (areaContainer != null) {
            this.renderAreaContainer(areaContainer);
        }
        if (areaContainer2 != null) {
            this.renderAreaContainer(areaContainer2);
        }
    }

    public void renderSVGArea(SVGArea sVGArea) {
        int n = this.currentAreaContainerXPosition;
        int n2 = this.currentYPosition;
        int n3 = sVGArea.getContentWidth();
        int n4 = sVGArea.getHeight();
        Enumeration enumeration = sVGArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof GraphicImpl)) continue;
            this.renderElement(sVGArea, (GraphicImpl)e, n, n2, null);
        }
        this.currentYPosition -= n4;
    }

    public void renderSpanArea(SpanArea spanArea) {
        Enumeration enumeration = spanArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
    }

    public void renderWordArea(WordArea wordArea) {
        FontMetricsMapper fontMetricsMapper;
        StringBuffer stringBuffer = new StringBuffer();
        String string = wordArea.getFontState().getFontName();
        int n = wordArea.getFontState().getFontSize();
        boolean bl = wordArea.getUnderlined();
        float f = wordArea.getRed();
        float f2 = wordArea.getGreen();
        float f3 = wordArea.getBlue();
        try {
            fontMetricsMapper = (FontMetricsMapper)wordArea.getFontState().getFontInfo().getMetricsFor(string);
        }
        catch (FOPException fOPException) {
            fontMetricsMapper = new FontMetricsMapper("MonoSpaced", 0, this.parent);
        }
        if (!string.equals(this.currentFontName) || n != this.currentFontSize) {
            this.currentFontName = string;
            this.currentFontSize = n;
        }
        if (f != this.currentRed || f2 != this.currentGreen || f3 != this.currentBlue) {
            this.currentRed = f;
            this.currentGreen = f2;
            this.currentBlue = f3;
        }
        int n2 = this.currentXPosition;
        int n3 = this.currentYPosition;
        String string2 = wordArea.getText();
        Color color = this.graphics.getColor();
        Font font = this.graphics.getFont();
        Font font2 = fontMetricsMapper.getFont(n);
        if (this.saveColor != null) {
            if ((float)this.saveColor.getRed() != f || (float)this.saveColor.getGreen() != f2 || (float)this.saveColor.getBlue() != f3) {
                this.saveColor = new Color(f, f2, f3);
            }
        } else {
            this.saveColor = new Color(f, f2, f3);
        }
        this.graphics.setColor(this.saveColor);
        FontRenderContext fontRenderContext = this.graphics.getFontRenderContext();
        AttributedString attributedString = new AttributedString(string2);
        attributedString.addAttribute(TextAttribute.FONT, font2);
        if (bl) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        this.graphics.drawString(attributedCharacterIterator, (float)n2 / 1000.0f, (float)((int)((float)this.pageHeight - (float)n3 / 1000.0f)));
        this.graphics.setColor(color);
        this.currentXPosition += wordArea.getContentWidth();
    }

    public void setComponent(Component component) {
        this.parent = component;
    }

    public void setPageNumber(int n) {
        this.pageNumber = n;
    }

    public void setProducer(String string) {
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public void setupFontInfo(FontInfo fontInfo) {
        FontSetup.setup(fontInfo, this.parent);
    }

    public void transform(Graphics2D graphics2D, double d, double d2) {
        AffineTransform affineTransform = graphics2D.getTransform();
        affineTransform.rotate(d2);
        affineTransform.scale(d / 100.0, d / 100.0);
        graphics2D.setTransform(affineTransform);
    }

    public Shape transformShape(Vector vector, Shape shape) {
        if (vector == null || vector.size() == 0) {
            return shape;
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            SVGTransform sVGTransform = (SVGTransform)vector.elementAt(n);
            SVGMatrix sVGMatrix = sVGTransform.getMatrix();
            AffineTransform affineTransform = new AffineTransform(sVGMatrix.getA(), sVGMatrix.getB(), sVGMatrix.getC(), sVGMatrix.getD(), sVGMatrix.getE(), sVGMatrix.getF());
            shape = affineTransform.createTransformedShape(shape);
            --n;
        }
        return shape;
    }

    class DrawingInstruction {
        boolean stroke = false;
        boolean nonzero = false;
        boolean fill = false;
        int linecap = 0;
        int linejoin = 0;
        int miterwidth = 8;

        DrawingInstruction() {
        }
    }
}

