/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;
import org.apache.fop.messaging.MessageHandler;

public class PageSequenceMaster
extends FObj {
    LayoutMasterSet layoutMasterSet;
    Vector subSequenceSpecifiers;

    protected PageSequenceMaster(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:page-sequence-master";
        this.subSequenceSpecifiers = new Vector();
        if (fObj.getName().equals("fo:layout-master-set")) {
            this.layoutMasterSet = (LayoutMasterSet)fObj;
            String string = this.properties.get("master-name").getString();
            if (string == null) {
                MessageHandler.errorln("WARNING: page-sequence-master does not have a page-master-name and so is being ignored");
            } else {
                this.layoutMasterSet.addPageSequenceMaster(string, this);
            }
        } else {
            throw new FOPException("fo:page-sequence-master must be child of fo:layout-master-set, not " + fObj.getName());
        }
    }

    protected void addSubsequenceSpecifier(SubSequenceSpecifier subSequenceSpecifier) {
        this.subSequenceSpecifiers.addElement(subSequenceSpecifier);
    }

    protected SubSequenceSpecifier getSubSequenceSpecifier(int n) {
        if (n >= 0 && n < this.getSubSequenceSpecifierCount()) {
            return (SubSequenceSpecifier)this.subSequenceSpecifiers.elementAt(n);
        }
        return null;
    }

    protected int getSubSequenceSpecifierCount() {
        return this.subSequenceSpecifiers.size();
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void reset() {
        Enumeration enumeration = this.subSequenceSpecifiers.elements();
        while (enumeration.hasMoreElements()) {
            ((SubSequenceSpecifier)enumeration.nextElement()).reset();
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new PageSequenceMaster(fObj, propertyList);
        }
    }
}

