/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.Vector;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.optimizer.OptClassNameHelper;
import org.mozilla.javascript.optimizer.OptVariableTable;

public class OptFunctionNode
extends FunctionNode {
    private String itsClassName;
    private boolean itsIsTargetOfDirectCall;
    private boolean itsContainsCalls;
    private boolean[] itsContainsCallsCount = new boolean[4];
    private boolean itsParameterNumberContext;
    private Vector itsDirectCallTargets;

    public OptFunctionNode(String string, Node node, Node node2, ClassNameHelper classNameHelper) {
        super(string, node, node2);
        this.itsVariableTable = new OptVariableTable();
        OptClassNameHelper optClassNameHelper = (OptClassNameHelper)classNameHelper;
        this.itsClassName = optClassNameHelper.getJavaScriptClassName(string, false);
    }

    public void addDirectCallTarget(FunctionNode functionNode) {
        if (this.itsDirectCallTargets == null) {
            this.itsDirectCallTargets = new Vector();
        }
        int n = 0;
        while (n < this.itsDirectCallTargets.size()) {
            if ((FunctionNode)this.itsDirectCallTargets.elementAt(n) == functionNode) {
                return;
            }
            ++n;
        }
        this.itsDirectCallTargets.addElement(functionNode);
    }

    public boolean containsCalls(int n) {
        if (n < this.itsContainsCallsCount.length && n >= 0) {
            return this.itsContainsCallsCount[n];
        }
        return this.itsContainsCalls;
    }

    public String getClassName() {
        return this.itsClassName;
    }

    public String getDirectCallParameterSignature() {
        StringBuffer stringBuffer = new StringBuffer("(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;");
        int n = this.itsVariableTable.getParameterCount();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("Ljava/lang/Object;D");
            ++n2;
        }
        stringBuffer.append("[Ljava/lang/Object;)");
        return stringBuffer.toString();
    }

    public Vector getDirectCallTargets() {
        return this.itsDirectCallTargets;
    }

    public boolean getParameterNumberContext() {
        return this.itsParameterNumberContext;
    }

    public void incrementLocalCount() {
        Integer n = (Integer)this.getProp(22);
        if (n == null) {
            this.putProp(22, new Integer(1));
        } else {
            this.putProp(22, new Integer(n + 1));
        }
    }

    public boolean isTargetOfDirectCall() {
        return this.itsIsTargetOfDirectCall;
    }

    public void setContainsCalls(int n) {
        if (n < this.itsContainsCallsCount.length) {
            this.itsContainsCallsCount[n] = true;
        }
        this.itsContainsCalls = true;
    }

    public void setIsTargetOfDirectCall() {
        this.itsIsTargetOfDirectCall = true;
    }

    public void setParameterNumberContext(boolean bl) {
        this.itsParameterNumberContext = bl;
    }
}

