/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.LocalVariable;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecuritySupport;
import org.mozilla.javascript.ShallowNodeIterator;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.optimizer.ConstantList;
import org.mozilla.javascript.optimizer.JavaScriptClassLoader;
import org.mozilla.javascript.optimizer.OptClassNameHelper;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptIRFactory;
import org.mozilla.javascript.optimizer.OptLocalVariable;
import org.mozilla.javascript.optimizer.OptTransformer;
import org.mozilla.javascript.optimizer.OptVariableTable;
import org.mozilla.javascript.optimizer.Optimizer;

public class Codegen
extends Interpreter {
    private static final String normalFunctionSuperClassName = "org.mozilla.javascript.NativeFunction";
    private static final String normalScriptSuperClassName = "org.mozilla.javascript.NativeScript";
    private static final String debugFunctionSuperClassName = "org.mozilla.javascript.debug.NativeFunctionDebug";
    private static final String debugScriptSuperClassName = "org.mozilla.javascript.debug.NativeScriptDebug";
    private String superClassName;
    private String superClassSlashName;
    private String name;
    private int ordinal;
    boolean inFunction;
    boolean inDirectCallFunction;
    private ClassFileWriter classFile;
    private Vector namesVector;
    private Vector classFilesVector;
    private short scriptRuntimeIndex;
    private int version;
    private OptClassNameHelper itsNameHelper;
    private static JavaScriptClassLoader classLoader;
    private String itsSourceFile;
    private int itsLineNumber;
    private int stackDepth;
    private int stackDepthMax;
    private static final int MAX_LOCALS = 256;
    private boolean[] locals;
    private short firstFreeLocal;
    private short localsMax;
    private ConstantList itsConstantList = new ConstantList();
    private short variableObjectLocal;
    private short scriptResultLocal;
    private short contextLocal;
    private short argsLocal;
    private short thisObjLocal;
    private short funObjLocal;
    private short debug_pcLocal;
    private short debugStopSubRetLocal;
    private short itsZeroArgArray;
    private short itsOneArgArray;
    private boolean hasVarsInRegs;
    private boolean itsForcedObjectParameters;
    private boolean trivialInit;
    private short itsLocalAllocationBase;
    private OptVariableTable vars;
    private OptVariableTable debugVars;
    private int epilogueLabel;
    private int optLevel;
    private static final int debugLevel = 0;
    private int debugStopSubLabel;
    private short[] debugLineMap;
    private short debugLineEntryCount;
    private static final int DEBUG_LINE_MAP_INITIAL_SIZE = 100;
    private static final int DEBUG_LINE_MAP_RESIZE_INCREMENT = 100;
    static /* synthetic */ Class class$java$lang$Object;

    public int acquireLabel() {
        return this.classFile.acquireLabel();
    }

    void addByteCode(byte by) {
        this.classFile.add(by);
    }

    void addByteCode(byte by, int n) {
        this.classFile.add(by, n);
    }

    void addByteCode(byte by, String string) {
        this.classFile.add(by, string);
    }

    private short addDebugPCEntry(short s) {
        return -1;
    }

    void addDoubleConstructor() {
        this.classFile.add((byte)-73, "java/lang/Double", "<init>", "(D)", "V");
    }

    void addOptRuntimeInvoke(String string, String string2, String string3) {
        this.classFile.add((byte)-72, "org/mozilla/javascript/optimizer/OptRuntime", string, string2, string3);
    }

    void addScriptRuntimeInvoke(String string, String string2, String string3) {
        this.classFile.add((byte)-72, "org/mozilla/javascript/ScriptRuntime", string, string2, string3);
    }

    void addSpecialInvoke(String string, String string2, String string3, String string4) {
        this.classFile.add((byte)-73, string, string2, string3, string4);
    }

    void addStaticInvoke(String string, String string2, String string3, String string4) {
        this.classFile.add((byte)-72, string, string2, string3, string4);
    }

    void addVirtualInvoke(String string, String string2, String string3, String string4) {
        this.classFile.add((byte)-74, string, string2, string3, string4);
    }

    private void aload(short s) {
        this.xload((byte)42, (byte)25, s);
    }

    private void astore(short s) {
        this.xstore((byte)75, (byte)58, s);
    }

    private void badTree() {
        throw new RuntimeException("Bad tree in codegen");
    }

    private void buildDebugTrapMap() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object compile(Context context, Scriptable scriptable, Node node, Object object, SecuritySupport securitySupport, ClassNameHelper classNameHelper) throws IOException {
        Object object2;
        Object object3;
        Object object4;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        String string = null;
        RuntimeException runtimeException = null;
        Class clazz = null;
        try {
            if (context.getOptimizationLevel() > 0) {
                new Optimizer().optimize(node, context.getOptimizationLevel());
            }
            string = this.generateCode(node, vector2, vector, classNameHelper);
            int n = 0;
            while (n < vector2.size()) {
                object4 = (String)vector2.elementAt(n);
                object3 = (byte[])vector.elementAt(n);
                if (classNameHelper.getGeneratingDirectory() != null) {
                    try {
                        int n2 = ((String)object4).lastIndexOf(46);
                        if (n2 != -1) {
                            object4 = ((String)object4).substring(n2 + 1);
                        }
                        object2 = classNameHelper.getTargetClassFileName((String)object4);
                        FileOutputStream fileOutputStream = new FileOutputStream((String)object2);
                        fileOutputStream.write((byte[])object3);
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        throw WrappedException.wrapException(iOException);
                    }
                }
                try {
                    Class<?> clazz2;
                    if (securitySupport == null) {
                        if (Context.isSecurityDomainRequired()) {
                            throw new SecurityException("Required security context missing");
                        }
                        if (classLoader == null) {
                            classLoader = new JavaScriptClassLoader();
                        }
                        clazz2 = classLoader.defineClass((String)object4, (byte[])object3);
                        object2 = clazz2.getClassLoader();
                        clazz2 = ((ClassLoader)object2).loadClass((String)object4);
                    } else {
                        clazz2 = securitySupport.defineClass((String)object4, (byte[])object3, object);
                    }
                    if (((String)object4).equals(string)) {
                        clazz = clazz2;
                    }
                }
                catch (ClassFormatError classFormatError) {
                    throw new RuntimeException(classFormatError.toString());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException.toString());
                }
                ++n;
            }
        }
        catch (SecurityException securityException) {
            runtimeException = securityException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            runtimeException = illegalArgumentException;
        }
        if (runtimeException != null) {
            throw new RuntimeException("Malformed optimizer package " + runtimeException);
        }
        OptClassNameHelper optClassNameHelper = (OptClassNameHelper)classNameHelper;
        if (optClassNameHelper.getTargetImplements() != null || optClassNameHelper.getTargetExtends() != null) {
            object4 = optClassNameHelper.getJavaScriptClassName(null, true);
            object3 = new NativeObject();
            ShallowNodeIterator shallowNodeIterator = node.getChildIterator();
            while (shallowNodeIterator.hasMoreElements()) {
                object2 = shallowNodeIterator.nextNode();
                if (((Node)object2).getType() != 109) continue;
                ((ScriptableObject)object3).put((String)((Node)object2).getDatum(), (Scriptable)object3, ((Node)object2).getProp(5));
            }
            try {
                object2 = optClassNameHelper.getTargetExtends();
                if (object2 == null) {
                    object2 = class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = Codegen.class$("java.lang.Object"));
                }
                JavaAdapter.createAdapterClass(context, (Scriptable)object3, (String)object4, (Class)object2, optClassNameHelper.getTargetImplements(), string, optClassNameHelper);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error(classNotFoundException.toString());
            }
        }
        if (node instanceof OptFunctionNode) {
            return ScriptRuntime.createFunctionObject(scriptable, clazz, context, true);
        }
        try {
            if (clazz == null) {
                return null;
            }
            object4 = (NativeScript)clazz.newInstance();
            if (scriptable != null) {
                ((ScriptableObject)object4).setPrototype(ScriptableObject.getClassPrototype(scriptable, "Script"));
                ((ScriptableObject)object4).setParentScope(scriptable);
            }
            return object4;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        throw new RuntimeException("Unable to instantiate compiled class");
    }

    private void constructArgArray(int n) {
        if (n == 0) {
            if (this.itsZeroArgArray >= 0) {
                this.aload(this.itsZeroArgArray);
            } else {
                this.push(0L);
                this.addByteCode((byte)-67, "java/lang/Object");
            }
        } else if (n == 1) {
            if (this.itsOneArgArray >= 0) {
                this.aload(this.itsOneArgArray);
            } else {
                this.push(1L);
                this.addByteCode((byte)-67, "java/lang/Object");
            }
        } else {
            this.push(n);
            this.addByteCode((byte)-67, "java/lang/Object");
        }
    }

    public IRFactory createIRFactory(TokenStream tokenStream, ClassNameHelper classNameHelper, Scriptable scriptable) {
        return new OptIRFactory(tokenStream, classNameHelper, scriptable);
    }

    private void dload(short s) {
        this.xload((byte)38, (byte)24, s);
    }

    private void dstore(short s) {
        this.xstore((byte)71, (byte)57, s);
    }

    private void emitConstantDudeInitializers() {
        if (this.itsConstantList.itsTop == 0) {
            return;
        }
        this.classFile.startMethod("<clinit>", "()V", (short)24);
        int n = 0;
        while (n < this.itsConstantList.itsTop) {
            this.addByteCode((byte)-69, "java/lang/" + this.itsConstantList.itsList[n].itsWrapperType);
            this.addByteCode((byte)89);
            if (this.itsConstantList.itsList[n].itsIsInteger) {
                this.push(this.itsConstantList.itsList[n].itsLValue);
            } else {
                this.push(this.itsConstantList.itsList[n].itsDValue);
            }
            this.addSpecialInvoke("java/lang/" + this.itsConstantList.itsList[n].itsWrapperType, "<init>", "(" + this.itsConstantList.itsList[n].itsSignature + ")", "V");
            this.classFile.addField("jsK_" + n, "Ljava/lang/" + this.itsConstantList.itsList[n].itsWrapperType + ";", (short)8);
            this.classFile.add((byte)-77, ClassFileWriter.fullyQualifiedForm(this.name), "jsK_" + n, "Ljava/lang/" + this.itsConstantList.itsList[n].itsWrapperType + ";");
            ++n;
        }
        this.addByteCode((byte)-79);
        this.classFile.stopMethod((short)0, null);
    }

    public void emitDirectConstructor(OptFunctionNode optFunctionNode) {
        short s = 17;
        this.classFile.startMethod("constructDirect", String.valueOf(optFunctionNode.getDirectCallParameterSignature()) + "Ljava/lang/Object;", s);
        int n = optFunctionNode.getVariableTable().getParameterCount();
        short s2 = (short)(4 + n * 3 + 1);
        this.addByteCode((byte)-69, "org/mozilla/javascript/NativeObject");
        this.addByteCode((byte)89);
        this.classFile.add((byte)-73, "org/mozilla/javascript/NativeObject", "<init>", "()", "V");
        this.astore(s2);
        this.aload(s2);
        this.aload((short)0);
        this.addVirtualInvoke("org/mozilla/javascript/NativeFunction", "getClassPrototype", "()", "Lorg/mozilla/javascript/Scriptable;");
        this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "setPrototype", "(Lorg/mozilla/javascript/Scriptable;)", "V");
        this.aload(s2);
        this.aload((short)0);
        this.addVirtualInvoke("org/mozilla/javascript/NativeFunction", "getParentScope", "()", "Lorg/mozilla/javascript/Scriptable;");
        this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "setPrototype", "(Lorg/mozilla/javascript/Scriptable;)", "V");
        this.aload((short)0);
        this.aload((short)1);
        this.aload((short)2);
        this.aload(s2);
        int n2 = 0;
        while (n2 < n) {
            this.aload((short)(4 + n2 * 3));
            this.dload((short)(5 + n2 * 3));
            ++n2;
        }
        this.aload((short)(4 + n * 3));
        this.addVirtualInvoke(this.name, "callDirect", optFunctionNode.getDirectCallParameterSignature(), "Ljava/lang/Object;");
        this.astore((short)(s2 + 1));
        int n3 = this.acquireLabel();
        this.aload((short)(s2 + 1));
        this.addByteCode((byte)-58, n3);
        this.aload((short)(s2 + 1));
        this.pushUndefined();
        this.addByteCode((byte)-91, n3);
        this.aload((short)(s2 + 1));
        this.addByteCode((byte)-63, "org/mozilla/javascript/Scriptable");
        this.addByteCode((byte)-103, n3);
        this.aload((short)(s2 + 1));
        this.addByteCode((byte)-64, "org/mozilla/javascript/Scriptable");
        this.addByteCode((byte)-80);
        this.markLabel(n3);
        this.aload(s2);
        this.addByteCode((byte)-80);
        this.classFile.stopMethod((short)(s2 + 2), null);
    }

    private void finishMethod(Context context, VariableTable variableTable) {
        this.classFile.stopMethod((short)(this.localsMax + 1), variableTable);
        this.contextLocal = (short)-1;
    }

    private void genSimpleCompare(int n, int n2, int n3) {
        switch (n) {
            case 17: {
                this.addByteCode((byte)-104);
                this.addByteCode((byte)-98, n2);
                break;
            }
            case 19: {
                this.addByteCode((byte)-105);
                this.addByteCode((byte)-100, n2);
                break;
            }
            case 16: {
                this.addByteCode((byte)-104);
                this.addByteCode((byte)-101, n2);
                break;
            }
            case 18: {
                this.addByteCode((byte)-105);
                this.addByteCode((byte)-99, n2);
                break;
            }
        }
        if (n3 != -1) {
            this.addByteCode((byte)-89, n3);
        }
    }

    public String generateCode(Node node, Vector vector, Vector vector2, ClassNameHelper classNameHelper) {
        Node node2;
        Object object;
        Object object2;
        this.itsNameHelper = (OptClassNameHelper)classNameHelper;
        this.namesVector = vector;
        this.classFilesVector = vector2;
        Context context = Context.getCurrentContext();
        this.itsSourceFile = null;
        if (context.isGeneratingDebug()) {
            this.itsSourceFile = (String)node.getProp(16);
        }
        this.version = context.getLanguageVersion();
        this.optLevel = context.getOptimizationLevel();
        this.inFunction = node.getType() == 109;
        this.superClassName = this.inFunction ? normalFunctionSuperClassName : normalScriptSuperClassName;
        this.superClassSlashName = this.superClassName.replace('.', '/');
        if (this.inFunction) {
            object2 = (OptFunctionNode)node;
            this.inDirectCallFunction = ((OptFunctionNode)object2).isTargetOfDirectCall();
            this.vars = (OptVariableTable)((FunctionNode)object2).getVariableTable();
            this.name = ((OptFunctionNode)object2).getClassName();
            this.classFile = new ClassFileWriter(this.name, this.superClassName, this.itsSourceFile);
            object = node.getFirstChild();
            String string = ((FunctionNode)object2).getFunctionName();
            this.generateInit(context, "<init>", node, string, (Node)object);
            if (((OptFunctionNode)object2).isTargetOfDirectCall()) {
                int n;
                this.classFile.startMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", (short)17);
                this.addByteCode((byte)42);
                this.addByteCode((byte)43);
                this.addByteCode((byte)44);
                this.addByteCode((byte)45);
                int n2 = 0;
                while (n2 < this.vars.getParameterCount()) {
                    this.push(n2);
                    this.addByteCode((byte)25, 4);
                    this.addByteCode((byte)-66);
                    n = this.acquireLabel();
                    int n3 = this.acquireLabel();
                    this.addByteCode((byte)-94, n);
                    this.addByteCode((byte)25, 4);
                    this.push(n2);
                    this.addByteCode((byte)50);
                    this.push(0.0);
                    this.addByteCode((byte)-89, n3);
                    this.markLabel(n);
                    this.pushUndefined();
                    this.push(0.0);
                    this.markLabel(n3);
                    ++n2;
                }
                this.addByteCode((byte)25, 4);
                this.addVirtualInvoke(this.name, "callDirect", ((OptFunctionNode)object2).getDirectCallParameterSignature(), "Ljava/lang/Object;");
                this.addByteCode((byte)-80);
                this.classFile.stopMethod((short)5, null);
                this.emitDirectConstructor((OptFunctionNode)object2);
                this.startNewMethod("callDirect", String.valueOf(((OptFunctionNode)object2).getDirectCallParameterSignature()) + "Ljava/lang/Object;", 1, false, true);
                this.vars.assignParameterJRegs();
                if (!((OptFunctionNode)object2).getParameterNumberContext()) {
                    this.itsForcedObjectParameters = true;
                    n = 0;
                    while (n < this.vars.getParameterCount()) {
                        OptLocalVariable optLocalVariable = (OptLocalVariable)this.vars.get(n);
                        this.aload(optLocalVariable.getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        int n4 = this.acquireLabel();
                        this.addByteCode((byte)-90, n4);
                        this.addByteCode((byte)-69, "java/lang/Double");
                        this.addByteCode((byte)89);
                        this.dload((short)(optLocalVariable.getJRegister() + 1));
                        this.addDoubleConstructor();
                        this.astore(optLocalVariable.getJRegister());
                        this.markLabel(n4);
                        ++n;
                    }
                }
                this.generatePrologue(context, node, true, this.vars.getParameterCount());
            } else {
                this.startNewMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", 1, false, true);
                this.generatePrologue(context, node, true, -1);
            }
            node2 = node.getLastChild();
        } else {
            if (node.getType() != 145) {
                this.badTree();
            }
            this.vars = (OptVariableTable)node.getProp(10);
            boolean bl = this.itsNameHelper.getTargetExtends() == null && this.itsNameHelper.getTargetImplements() == null;
            this.name = this.itsNameHelper.getJavaScriptClassName(null, bl);
            this.classFile = new ClassFileWriter(this.name, this.superClassName, this.itsSourceFile);
            this.classFile.addInterface("org/mozilla/javascript/Script");
            this.generateScriptCtor(context, node);
            this.generateMain(context);
            this.generateInit(context, "initScript", node, "", null);
            this.generateExecute(context);
            this.startNewMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", 1, false, true);
            this.generatePrologue(context, node, false, -1);
            node.addChildToBack(new Node(5));
            node2 = node;
        }
        this.generateCodeFromNode(node2, null, -1, -1);
        this.generateEpilogue();
        this.finishMethod(context, this.debugVars);
        this.emitConstantDudeInitializers();
        object2 = new ByteArrayOutputStream(512);
        try {
            this.classFile.write((OutputStream)object2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("unexpected IOException");
        }
        object = ((ByteArrayOutputStream)object2).toByteArray();
        this.namesVector.addElement(this.name);
        this.classFilesVector.addElement(object);
        this.classFile = null;
        return this.name;
    }

    /*
     * Exception decompiling
     */
    private void generateCodeFromNode(Node var1_1, Node var2_2, int var3_3, int var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [57[DOLOOP]], but top level block is 38[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void generateDebugInit(Context context, Node node) {
    }

    private void generateDebugStopSubroutine() {
    }

    private void generateEpilogue() {
        if (this.epilogueLabel != -1) {
            this.classFile.markLabel(this.epilogueLabel);
        }
        if (!this.hasVarsInRegs || !this.inFunction) {
            this.aload(this.contextLocal);
            this.addScriptRuntimeInvoke("popActivation", "(Lorg/mozilla/javascript/Context;)", "V");
        }
        this.addByteCode((byte)-80);
    }

    private void generateExecute(Context context) {
        String string = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
        this.startNewMethod("exec", string, 2, false, true);
        String string2 = this.name.replace('.', '/');
        if (!this.trivialInit) {
            this.addByteCode((byte)42);
            this.addByteCode((byte)44);
            this.addByteCode((byte)43);
            this.addVirtualInvoke(string2, "initScript", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)", "V");
        }
        this.addByteCode((byte)42);
        this.addByteCode((byte)43);
        this.addByteCode((byte)44);
        this.addByteCode((byte)89);
        this.addByteCode((byte)1);
        this.addVirtualInvoke(string2, "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)", "Ljava/lang/Object;");
        this.addByteCode((byte)-80);
        this.finishMethod(context, null);
    }

    private void generateFunctionInits(Vector vector) {
        this.push(vector.size());
        this.addByteCode((byte)-67, "org/mozilla/javascript/NativeFunction");
        short s = 0;
        while (s < vector.size()) {
            this.addByteCode((byte)89);
            this.push(s);
            Node node = (Node)vector.elementAt(s);
            Codegen codegen = new Codegen();
            String string = codegen.generateCode(node, this.namesVector, this.classFilesVector, this.itsNameHelper);
            this.addByteCode((byte)-69, string);
            this.addByteCode((byte)89);
            if (this.inFunction) {
                this.addByteCode((byte)42);
            } else {
                this.aload(this.variableObjectLocal);
            }
            this.aload(this.contextLocal);
            this.addSpecialInvoke(string, "<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)", "V");
            if (this.inFunction) {
                this.addByteCode((byte)42);
            } else {
                this.aload(this.variableObjectLocal);
            }
            String string2 = node.getString();
            if (string2 != null) {
                this.push(string2);
            } else {
                this.addByteCode((byte)1);
            }
            this.aload(this.contextLocal);
            this.addScriptRuntimeInvoke("initFunction", "(Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Context;)", "Lorg/mozilla/javascript/NativeFunction;");
            node.putProp(5, new Short(s));
            this.addByteCode((byte)83);
            s = (short)(s + 1);
        }
        this.addByteCode((byte)42);
        this.addByteCode((byte)95);
        this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "nestedFunctions", "[Lorg/mozilla/javascript/NativeFunction;");
    }

    private void generateGOTO(int n, Node node) {
        Node node2 = new Node(n);
        node2.putProp(1, node);
        this.visitGOTO(node2, n, null);
    }

    private void generateInit(Context context, String string, Node node, String string2, Node node2) {
        Vector vector;
        Vector vector2;
        String string3;
        int n;
        this.trivialInit = true;
        boolean bl = false;
        VariableTable variableTable = node instanceof OptFunctionNode ? ((OptFunctionNode)node).getVariableTable() : (VariableTable)node.getProp(10);
        if (string.equals("<init>")) {
            bl = true;
            this.setNonTrivialInit(string);
            this.addByteCode((byte)42);
            this.addSpecialInvoke(this.superClassSlashName, "<init>", "()", "V");
            this.addByteCode((byte)42);
            this.addByteCode((byte)43);
            this.classFile.add((byte)-75, "org/mozilla/javascript/ScriptableObject", "parent", "Lorg/mozilla/javascript/Scriptable;");
        }
        if (string2.length() != 0 || variableTable != null && variableTable.size() > 0) {
            this.setNonTrivialInit(string);
            if (variableTable == null) {
                variableTable = new OptVariableTable();
            }
            this.push(variableTable.size() + 1);
            this.addByteCode((byte)-67, "java/lang/String");
            this.addByteCode((byte)89);
            n = this.getNewWordLocal();
            this.astore((short)n);
            this.addByteCode((byte)89);
            this.push(0L);
            this.classFile.addLoadConstant(string2);
            this.addByteCode((byte)83);
            if (variableTable != null) {
                int n2 = 0;
                while (n2 < variableTable.size()) {
                    this.aload((short)n);
                    this.push(n2 + 1);
                    this.push(variableTable.getName(n2));
                    this.addByteCode((byte)83);
                    ++n2;
                }
            }
            this.releaseWordLocal((short)n);
            this.addByteCode((byte)42);
            this.addByteCode((byte)95);
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "names", "[Ljava/lang/String;");
        }
        int n3 = n = variableTable == null ? 0 : variableTable.getParameterCount();
        if (n != 0) {
            this.setNonTrivialInit(string);
            this.addByteCode((byte)42);
            this.push(n);
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "argCount", "S");
        }
        if (context.getLanguageVersion() != 0) {
            this.setNonTrivialInit(string);
            this.addByteCode((byte)42);
            this.push(context.getLanguageVersion());
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "version", "S");
        }
        if ((string3 = (String)node.getProp(17)) != null && context.isGeneratingSource() && string3.length() < 65536) {
            this.setNonTrivialInit(string);
            this.addByteCode((byte)42);
            this.push(string3);
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "source", "Ljava/lang/String;");
        }
        if ((vector2 = (Vector)node.getProp(12)) != null) {
            this.setNonTrivialInit(string);
            this.generateRegExpLiterals(vector2, bl);
        }
        if ((vector = (Vector)node.getProp(5)) != null) {
            this.setNonTrivialInit(string);
            this.generateFunctionInits(vector);
        }
        if (node instanceof OptFunctionNode) {
            OptFunctionNode optFunctionNode = (OptFunctionNode)node;
            Vector vector3 = ((OptFunctionNode)node).getDirectCallTargets();
            if (vector3 != null) {
                this.setNonTrivialInit(string);
                this.classFile.addField("EmptyArray", "[Ljava/lang/Object;", (short)2);
                this.addByteCode((byte)42);
                this.push(0L);
                this.addByteCode((byte)-67, "java/lang/Object");
                this.classFile.add((byte)-75, ClassFileWriter.fullyQualifiedForm(this.name), "EmptyArray", "[Ljava/lang/Object;");
            }
            if (optFunctionNode.isTargetOfDirectCall()) {
                this.setNonTrivialInit(string);
                String string4 = ClassFileWriter.fullyQualifiedForm(optFunctionNode.getClassName());
                String string5 = string4.replace('/', '_');
                this.classFile.addField(string5, "L" + string4 + ";", (short)9);
                this.addByteCode((byte)42);
                this.classFile.add((byte)-77, string4, string5, "L" + string4 + ";");
            }
        }
        if (!this.trivialInit) {
            this.addByteCode((byte)-79);
            this.finishMethod(context, null);
        }
    }

    private void generateMain(Context context) {
        this.startNewMethod("main", "([Ljava/lang/String;)V", 1, true, true);
        this.push(this.name);
        this.addByteCode((byte)42);
        this.addScriptRuntimeInvoke("main", "(Ljava/lang/String;[Ljava/lang/String;)", "V");
        this.addByteCode((byte)-79);
        this.finishMethod(context, null);
    }

    private void generatePrologue(Context context, Node node, boolean bl, int n) {
        String string;
        int n2;
        this.funObjLocal = this.reserveWordLocal(0);
        this.contextLocal = this.reserveWordLocal(1);
        this.variableObjectLocal = this.reserveWordLocal(2);
        this.thisObjLocal = this.reserveWordLocal(3);
        if (bl && !context.hasCompileFunctionsWithDynamicScope()) {
            this.aload(this.funObjLocal);
            this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "getParentScope", "()", "Lorg/mozilla/javascript/Scriptable;");
            this.astore(this.variableObjectLocal);
        }
        if (n > 0) {
            int n3 = 0;
            while (n3 < 3 * n) {
                this.reserveWordLocal(n3 + 4);
                ++n3;
            }
        }
        this.argsLocal = this.reserveWordLocal(n <= 0 ? 4 : 3 * n + 4);
        Integer n4 = (Integer)node.getProp(22);
        if (n4 != null) {
            this.itsLocalAllocationBase = (short)(this.argsLocal + 1);
            n2 = 0;
            while (n2 < n4) {
                this.reserveWordLocal(this.itsLocalAllocationBase + n2);
                ++n2;
            }
        }
        boolean bl2 = this.hasVarsInRegs = bl && !((OptFunctionNode)node).requiresActivation();
        if (this.hasVarsInRegs) {
            short s;
            n2 = this.vars.getParameterCount();
            if (bl && n2 > 0 && n < 0) {
                this.aload(this.argsLocal);
                this.addByteCode((byte)-66);
                this.push(n2);
                s = this.acquireLabel();
                this.addByteCode((byte)-94, s);
                this.aload(this.argsLocal);
                this.push(n2);
                this.addScriptRuntimeInvoke("padArguments", "([Ljava/lang/Object;I)", "[Ljava/lang/Object;");
                this.astore(this.argsLocal);
                this.markLabel(s);
            }
            s = -1;
            int n5 = 0;
            while (n5 < this.vars.size()) {
                OptLocalVariable optLocalVariable = (OptLocalVariable)this.vars.get(n5);
                if (optLocalVariable.isNumber()) {
                    optLocalVariable.assignJRegister(this.getNewWordPairLocal());
                    this.push(0.0);
                    this.dstore(optLocalVariable.getJRegister());
                } else if (optLocalVariable.isParameter()) {
                    if (n < 0) {
                        optLocalVariable.assignJRegister(this.getNewWordLocal());
                        this.aload(this.argsLocal);
                        this.push(n5);
                        this.addByteCode((byte)50);
                        this.astore(optLocalVariable.getJRegister());
                    }
                } else {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                    if (s == -1) {
                        this.pushUndefined();
                        s = optLocalVariable.getJRegister();
                    } else {
                        this.aload(s);
                    }
                    this.astore(optLocalVariable.getJRegister());
                }
                optLocalVariable.setStartPC(this.classFile.getCurrentCodeOffset());
                ++n5;
            }
            this.debugVars = this.vars;
            return;
        }
        if (n > 0) {
            this.aload(this.argsLocal);
            this.push(n);
            this.addOptRuntimeInvoke("padStart", "([Ljava/lang/Object;I)", "[Ljava/lang/Object;");
            this.astore(this.argsLocal);
            n2 = 0;
            while (n2 < n) {
                this.aload(this.argsLocal);
                this.push(n2);
                this.aload((short)(3 * n2 + 4));
                this.addByteCode((byte)83);
                ++n2;
            }
        }
        if (bl) {
            this.aload(this.contextLocal);
            this.aload(this.variableObjectLocal);
            this.aload(this.funObjLocal);
            this.aload(this.thisObjLocal);
            this.aload(this.argsLocal);
            this.addScriptRuntimeInvoke("initVarObj", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)", "Lorg/mozilla/javascript/Scriptable;");
            string = "activation";
        } else {
            this.aload(this.contextLocal);
            this.aload(this.variableObjectLocal);
            this.aload(this.funObjLocal);
            this.aload(this.thisObjLocal);
            this.push(0L);
            this.addScriptRuntimeInvoke("initScript", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;Z)", "Lorg/mozilla/javascript/Scriptable;");
            string = "global";
        }
        this.astore(this.variableObjectLocal);
        Vector vector = (Vector)node.getProp(5);
        if (bl && vector != null) {
            int n6 = 0;
            while (n6 < vector.size()) {
                FunctionNode functionNode = (FunctionNode)vector.elementAt(n6);
                if (functionNode.getFunctionType() == 1) {
                    this.visitFunction(functionNode, true);
                }
                ++n6;
            }
        }
        if (context.isGeneratingDebug()) {
            this.debugVars = new OptVariableTable();
            this.debugVars.addLocal(string);
            OptLocalVariable optLocalVariable = (OptLocalVariable)this.debugVars.get(string);
            optLocalVariable.assignJRegister(this.variableObjectLocal);
            optLocalVariable.setStartPC(this.classFile.getCurrentCodeOffset());
        }
        if (!bl) {
            this.scriptResultLocal = this.getNewWordLocal();
            this.pushUndefined();
            this.astore(this.scriptResultLocal);
        }
        if (bl && ((OptFunctionNode)node).containsCalls(-1)) {
            if (((OptFunctionNode)node).containsCalls(0)) {
                this.itsZeroArgArray = this.getNewWordLocal();
                this.classFile.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
                this.astore(this.itsZeroArgArray);
            }
            if (((OptFunctionNode)node).containsCalls(1)) {
                this.itsOneArgArray = this.getNewWordLocal();
                this.push(1L);
                this.addByteCode((byte)-67, "java/lang/Object");
                this.astore(this.itsOneArgArray);
            }
        }
    }

    private void generateRegExpLiterals(Vector vector, boolean bl) {
        int n = 0;
        while (n < vector.size()) {
            Node node = (Node)vector.elementAt(n);
            StringBuffer stringBuffer = new StringBuffer("_re");
            stringBuffer.append(n);
            String string = stringBuffer.toString();
            short s = 2;
            if (bl) {
                s = (short)(s | 0x10);
            }
            this.classFile.addField(string, "Lorg/mozilla/javascript/regexp/NativeRegExp;", s);
            this.addByteCode((byte)42);
            this.addByteCode((byte)-69, "org/mozilla/javascript/regexp/NativeRegExp");
            this.addByteCode((byte)89);
            this.aload(this.contextLocal);
            this.aload(this.variableObjectLocal);
            Node node2 = node.getFirstChild();
            this.push(node2.getString());
            Node node3 = node.getLastChild();
            if (node2 == node3) {
                this.addByteCode((byte)1);
            } else {
                this.push(node3.getString());
            }
            this.push(0L);
            this.addSpecialInvoke("org/mozilla/javascript/regexp/NativeRegExp", "<init>", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Ljava/lang/String;Z)", "V");
            node.putProp(12, string);
            this.classFile.add((byte)-75, ClassFileWriter.fullyQualifiedForm(this.name), string, "Lorg/mozilla/javascript/regexp/NativeRegExp;");
            ++n;
        }
    }

    private void generateScriptCtor(Context context, Node node) {
        this.startNewMethod("<init>", "()V", 1, false, false);
        this.addByteCode((byte)42);
        this.addSpecialInvoke(this.superClassSlashName, "<init>", "()", "V");
        this.addByteCode((byte)-79);
        this.finishMethod(context, null);
    }

    private short getLocalFromNode(Node node) {
        Integer n = (Integer)node.getProp(7);
        if (n == null) {
            short s;
            if (node.getType() == 143 || node.getType() == 144) {
                short s2 = this.itsLocalAllocationBase;
                s = s2;
                this.itsLocalAllocationBase = (short)(s2 + 1);
            } else {
                s = this.getNewWordLocal();
            }
            short s3 = s;
            node.putProp(7, new Integer(s3));
            return s3;
        }
        return n.shortValue();
    }

    private short getNewWordLocal() {
        short s = this.firstFreeLocal;
        this.locals[s] = true;
        int n = this.firstFreeLocal + 1;
        while (n < 256) {
            if (!this.locals[n]) {
                this.firstFreeLocal = (short)n;
                if (this.localsMax < this.firstFreeLocal) {
                    this.localsMax = this.firstFreeLocal;
                }
                return s;
            }
            ++n;
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private short getNewWordPairLocal() {
        short s;
        for (s = this.firstFreeLocal; s < 255 && (this.locals[s] || this.locals[s + 1]); s = (short)(s + 1)) {
        }
        if (s < 255) {
            this.locals[s] = true;
            this.locals[s + 1] = true;
            if (s == this.firstFreeLocal) {
                int n = this.firstFreeLocal + 2;
                while (n < 256) {
                    if (!this.locals[n]) {
                        this.firstFreeLocal = (short)n;
                        if (this.localsMax < this.firstFreeLocal) {
                            this.localsMax = this.firstFreeLocal;
                        }
                        return s;
                    }
                    ++n;
                }
            } else {
                return s;
            }
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private String getSimpleCallName(Node node) {
        Node node2;
        Node node3 = node.getFirstChild();
        if (node3.getType() == 39 && (node2 = node3.getFirstChild()).getType() == 69) {
            Node node4 = node2.getNextSibling();
            Node node5 = node2.getFirstChild();
            if (node5.getType() == 71) {
                Node node6;
                Node node7;
                Node node8;
                String string = node5.getString();
                if (node4 != null && node4.getType() == 46 && string.equals(node4.getString()) && (node8 = node3.getNextSibling()).getType() == 68 && (node7 = node8.getFirstChild()).getType() == 70 && (node6 = (Node)node7.getProp(6)) == node2) {
                    return string;
                }
            }
        }
        return null;
    }

    private void iload(short s) {
        this.xload((byte)26, (byte)21, s);
    }

    private boolean isArithmeticNode(Node node) {
        int n = node.getType();
        return n == 24 || n == 27 || n == 26 || n == 25;
    }

    private void istore(short s) {
        this.xstore((byte)59, (byte)54, s);
    }

    public int markLabel(int n) {
        return this.classFile.markLabel(n);
    }

    public int markLabel(int n, short s) {
        return this.classFile.markLabel(n, s);
    }

    private Number nodeIsConvertToObjectOfNumber(Node node) {
        Node node2;
        Object object;
        if (node.getType() == 141 && (object = node.getProp(18)) == ScriptRuntime.ObjectClass && (node2 = node.getFirstChild()).getType() == 45) {
            return (Number)node2.getDatum();
        }
        return null;
    }

    private boolean nodeIsDirectCallParameter(Node node) {
        OptLocalVariable optLocalVariable;
        return node.getType() == 72 && (optLocalVariable = (OptLocalVariable)node.getProp(24)) != null && optLocalVariable.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters;
    }

    private void push(double d) {
        if (d == 0.0) {
            this.addByteCode((byte)14);
        } else if (d == 1.0) {
            this.addByteCode((byte)15);
        } else {
            this.classFile.addLoadConstant(d);
        }
    }

    private void push(long l) {
        if (l == -1L) {
            this.addByteCode((byte)2);
        } else if (l >= 0L && l <= 5L) {
            this.addByteCode((byte)(3L + l));
        } else if (l >= -128L && l <= 127L) {
            this.addByteCode((byte)16, (byte)l);
        } else if (l >= -32768L && l <= 32767L) {
            this.addByteCode((byte)17, (short)l);
        } else if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            this.classFile.addLoadConstant((int)l);
        } else {
            this.classFile.addLoadConstant(l);
        }
    }

    private void push(String string) {
        this.classFile.addLoadConstant(string);
    }

    private void pushUndefined() {
        this.classFile.add((byte)-78, "org/mozilla/javascript/Undefined", "instance", "Lorg/mozilla/javascript/Scriptable;");
    }

    private void releaseWordLocal(short s) {
        if (s < this.firstFreeLocal) {
            this.firstFreeLocal = s;
        }
        this.locals[s] = false;
    }

    private void releaseWordpairLocal(short s) {
        if (s < this.firstFreeLocal) {
            this.firstFreeLocal = s;
        }
        this.locals[s] = false;
        this.locals[s + 1] = false;
    }

    private short reserveWordLocal(int n) {
        if (this.getNewWordLocal() != n) {
            throw new RuntimeException("Local allocation error");
        }
        return (short)n;
    }

    private void resetTargets(Node node) {
        if (node.getType() == 136) {
            node.putProp(20, null);
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.resetTargets(node2);
            node2 = node2.getNextSibling();
        }
    }

    private void setNonTrivialInit(String string) {
        if (!this.trivialInit) {
            return;
        }
        this.trivialInit = false;
        this.startNewMethod(string, "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)V", 1, false, false);
        this.reserveWordLocal(0);
        this.variableObjectLocal = this.reserveWordLocal(1);
        this.contextLocal = this.reserveWordLocal(2);
    }

    private void startNewMethod(String string, String string2, int n, boolean bl, boolean bl2) {
        this.locals = new boolean[256];
        this.localsMax = (short)(n + 1);
        this.firstFreeLocal = 0;
        this.contextLocal = (short)-1;
        this.variableObjectLocal = (short)-1;
        this.scriptResultLocal = (short)-1;
        this.argsLocal = (short)-1;
        this.thisObjLocal = (short)-1;
        this.funObjLocal = (short)-1;
        this.debug_pcLocal = (short)-1;
        this.debugStopSubRetLocal = (short)-1;
        this.itsZeroArgArray = (short)-1;
        this.itsOneArgArray = (short)-1;
        short s = 1;
        if (bl) {
            s = (short)(s | 8);
        }
        if (bl2) {
            s = (short)(s | 0x10);
        }
        this.epilogueLabel = -1;
        this.classFile.startMethod(string, string2, s);
    }

    public Node transform(Node node, TokenStream tokenStream, Scriptable scriptable) {
        OptTransformer optTransformer = new OptTransformer(new Hashtable(11));
        return optTransformer.transform(node, null, tokenStream, scriptable);
    }

    private void visitArithmetic(Node node, byte by, Node node2, Node node3) {
        Integer n = (Integer)node.getProp(26);
        if (n != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            this.addByteCode(by);
        } else {
            boolean bl = this.isArithmeticNode(node3);
            if (!bl) {
                this.addByteCode((byte)-69, "java/lang/Double");
                this.addByteCode((byte)89);
            }
            this.generateCodeFromNode(node2, node, -1, -1);
            if (!this.isArithmeticNode(node2)) {
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
            }
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            if (!this.isArithmeticNode(node2.getNextSibling())) {
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
            }
            this.addByteCode(by);
            if (!bl) {
                this.addDoubleConstructor();
            }
        }
    }

    private void visitBind(Node node, int n, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        this.aload(this.variableObjectLocal);
        this.push(node.getString());
        this.addScriptRuntimeInvoke(n == 61 ? "bind" : "getBase", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Lorg/mozilla/javascript/Scriptable;");
    }

    private void visitBitOp(Node node, int n, Node node2) {
        Integer n2 = (Integer)node.getProp(26);
        if (n2 == null) {
            this.addByteCode((byte)-69, "java/lang/Double");
            this.addByteCode((byte)89);
        }
        this.generateCodeFromNode(node2, node, -1, -1);
        if (n == 22) {
            this.addScriptRuntimeInvoke("toUint32", "(Ljava/lang/Object;)", "J");
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
            this.push(31L);
            this.addByteCode((byte)126);
            this.addByteCode((byte)125);
            this.addByteCode((byte)-118);
            this.addDoubleConstructor();
            return;
        }
        if (n2 == null) {
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
        } else {
            this.addScriptRuntimeInvoke("toInt32", "(D)", "I");
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            this.addScriptRuntimeInvoke("toInt32", "(D)", "I");
        }
        switch (n) {
            case 11: {
                this.addByteCode((byte)-128);
                break;
            }
            case 12: {
                this.addByteCode((byte)-126);
                break;
            }
            case 13: {
                this.addByteCode((byte)126);
                break;
            }
            case 21: {
                this.addByteCode((byte)122);
                break;
            }
            case 20: {
                this.addByteCode((byte)120);
                break;
            }
            default: {
                this.badTree();
            }
        }
        this.addByteCode((byte)-121);
        if (n2 == null) {
            this.addDoubleConstructor();
        }
    }

    private void visitCall(Node node, int n, Node node2) {
        Node node3 = node2;
        OptFunctionNode optFunctionNode = (OptFunctionNode)node.getProp(27);
        if (optFunctionNode != null) {
            int n2;
            this.generateCodeFromNode(node2, node, -1, -1);
            int n3 = this.acquireLabel();
            String string = ClassFileWriter.fullyQualifiedForm(optFunctionNode.getClassName());
            String string2 = string.replace('/', '_');
            this.classFile.add((byte)-78, ClassFileWriter.fullyQualifiedForm(string), string2, "L" + string + ";");
            short s = this.classFile.getStackTop();
            this.addByteCode((byte)92);
            this.addByteCode((byte)-90, n3);
            this.addByteCode((byte)95);
            this.addByteCode((byte)87);
            this.addByteCode((byte)89);
            this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "getParentScope", "()", "Lorg/mozilla/javascript/Scriptable;");
            this.aload(this.contextLocal);
            this.addByteCode((byte)95);
            if (n == 30) {
                this.addByteCode((byte)1);
            } else {
                node2 = node2.getNextSibling();
                this.generateCodeFromNode(node2, node, -1, -1);
            }
            node2 = node2.getNextSibling();
            while (node2 != null) {
                Object object;
                n2 = 0;
                if (node2.getType() == 72 && this.inDirectCallFunction && ((LocalVariable)(object = (OptLocalVariable)node2.getProp(24))).isParameter()) {
                    n2 = 1;
                    this.aload(((OptLocalVariable)object).getJRegister());
                    this.dload((short)(((OptLocalVariable)object).getJRegister() + 1));
                }
                if (n2 == 0) {
                    object = (Integer)node2.getProp(26);
                    if (object != null && (Integer)object == 0) {
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        this.generateCodeFromNode(node2, node, -1, -1);
                    } else {
                        this.generateCodeFromNode(node2, node, -1, -1);
                        this.push(0.0);
                    }
                }
                this.resetTargets(node2);
                node2 = node2.getNextSibling();
            }
            this.addByteCode((byte)42);
            this.classFile.add((byte)-76, ClassFileWriter.fullyQualifiedForm(this.name), "EmptyArray", "[Ljava/lang/Object;");
            if (n == 30) {
                this.addVirtualInvoke(optFunctionNode.getClassName(), "constructDirect", optFunctionNode.getDirectCallParameterSignature(), "Ljava/lang/Object;");
            } else {
                this.addVirtualInvoke(optFunctionNode.getClassName(), "callDirect", optFunctionNode.getDirectCallParameterSignature(), "Ljava/lang/Object;");
            }
            n2 = this.acquireLabel();
            this.addByteCode((byte)-89, n2);
            this.markLabel(n3, s);
            this.addByteCode((byte)87);
            this.visitRegularCall(node, n, node3, true);
            this.markLabel(n2);
        } else {
            this.visitRegularCall(node, n, node3, false);
        }
    }

    private void visitEnterWith(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("enterWith", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
        this.astore(this.variableObjectLocal);
    }

    private void visitEnumDone(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        Node node3 = (Node)node.getProp(4);
        Integer n = (Integer)node3.getProp(7);
        this.releaseWordLocal(n.shortValue());
    }

    private void visitEnumInit(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("initEnum", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/util/Enumeration;");
        short s = this.getNewWordLocal();
        this.astore(s);
        node.putProp(7, new Integer(s));
    }

    private void visitEnumNext(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        Node node3 = (Node)node.getProp(4);
        Integer n = (Integer)node3.getProp(7);
        this.aload(n.shortValue());
        this.addScriptRuntimeInvoke("nextEnum", "(Ljava/util/Enumeration;)", "Ljava/lang/Object;");
    }

    private void visitEqOp(Node node, Node node2, Node node3, int n, int n2) {
        int n3 = node.getInt();
        Node node4 = node2.getNextSibling();
        if (n == -1) {
            String string;
            if (node4.getType() == 108 && node4.getInt() == 49) {
                this.generateCodeFromNode(node2, node, -1, -1);
                this.addByteCode((byte)89);
                this.addByteCode((byte)-58, 15);
                this.pushUndefined();
                this.addByteCode((byte)-91, 10);
                if (n3 == 14 || n3 == 53) {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                } else {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                }
                this.addByteCode((byte)-89, 7);
                this.addByteCode((byte)87);
                if (n3 == 14 || n3 == 53) {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                } else {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                }
                return;
            }
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            switch (n3) {
                case 14: {
                    string = this.version == 120 ? "seqB" : "eqB";
                    break;
                }
                case 15: {
                    string = this.version == 120 ? "sneB" : "neB";
                    break;
                }
                case 53: {
                    string = "seqB";
                    break;
                }
                case 54: {
                    string = "sneB";
                    break;
                }
                default: {
                    string = null;
                    this.badTree();
                }
            }
            this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Boolean;");
        } else {
            Object object;
            if (node4.getType() == 108 && node4.getInt() == 49) {
                boolean bl;
                this.generateCodeFromNode(node2, node, -1, -1);
                boolean bl2 = bl = node2.getType() == 72;
                if (!bl) {
                    this.addByteCode((byte)89);
                }
                int n4 = this.acquireLabel();
                if (n3 == 14 || n3 == 53) {
                    this.addByteCode((byte)-58, bl ? n : n4);
                    short s = this.classFile.getStackTop();
                    if (bl) {
                        this.generateCodeFromNode(node2, node, -1, -1);
                    }
                    this.pushUndefined();
                    this.addByteCode((byte)-91, n);
                    this.addByteCode((byte)-89, n2);
                    if (!bl) {
                        this.markLabel(n4, s);
                        this.addByteCode((byte)87);
                        this.addByteCode((byte)-89, n);
                    }
                } else {
                    this.addByteCode((byte)-58, bl ? n2 : n4);
                    short s = this.classFile.getStackTop();
                    if (bl) {
                        this.generateCodeFromNode(node2, node, -1, -1);
                    }
                    this.pushUndefined();
                    this.addByteCode((byte)-91, n2);
                    this.addByteCode((byte)-89, n);
                    if (!bl) {
                        this.markLabel(n4, s);
                        this.addByteCode((byte)87);
                        this.addByteCode((byte)-89, n2);
                    }
                }
                return;
            }
            Node node5 = node2.getNextSibling();
            Number number = this.nodeIsConvertToObjectOfNumber(node5);
            if (this.nodeIsDirectCallParameter(node2) && number != null) {
                object = (OptLocalVariable)node2.getProp(24);
                this.aload(((OptLocalVariable)object).getJRegister());
                this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int n5 = this.acquireLabel();
                this.addByteCode((byte)-90, n5);
                this.dload((short)(((OptLocalVariable)object).getJRegister() + 1));
                this.push(number.doubleValue());
                this.addByteCode((byte)-105);
                if (n3 == 14) {
                    this.addByteCode((byte)-103, n);
                } else {
                    this.addByteCode((byte)-102, n);
                }
                this.addByteCode((byte)-89, n2);
                this.markLabel(n5);
            }
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node5, node, -1, -1);
            switch (n3) {
                case 14: {
                    object = this.version == 120 ? "shallowEq" : "eq";
                    this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                case 15: {
                    object = this.version == 120 ? "shallowNeq" : "neq";
                    this.addOptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                case 53: {
                    object = "shallowEq";
                    this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                case 54: {
                    object = "shallowNeq";
                    this.addOptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                default: {
                    object = null;
                    this.badTree();
                }
            }
            this.addByteCode((byte)-102, n);
            this.addByteCode((byte)-89, n2);
        }
    }

    private void visitFunction(Node node, boolean bl) {
        this.aload(this.variableObjectLocal);
        Short s = (Short)node.getProp(5);
        this.aload(this.funObjLocal);
        this.classFile.add((byte)-76, "org/mozilla/javascript/NativeFunction", "nestedFunctions", "[Lorg/mozilla/javascript/NativeFunction;");
        this.push(s.shortValue());
        this.addByteCode((byte)50);
        this.addVirtualInvoke("java/lang/Object", "getClass", "()", "Ljava/lang/Class;");
        this.aload(this.contextLocal);
        this.addByteCode((byte)16, bl ? 1 : 0);
        this.addScriptRuntimeInvoke("createFunctionObject", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Class;Lorg/mozilla/javascript/Context;Z)", "Lorg/mozilla/javascript/NativeFunction;");
    }

    /*
     * Unable to fully structure code
     */
    private void visitGOTO(Node var1_1, int var2_2, Node var3_3) {
        block15: {
            block14: {
                var4_4 = (Node)var1_1.getProp(1);
                var5_5 = var4_4.getProp(20);
                if (var5_5 == null) {
                    var6_6 = this.acquireLabel();
                    var4_4.putProp(20, new Integer(var6_6));
                } else {
                    var6_6 = (Integer)var5_5;
                }
                var7_7 = this.acquireLabel();
                if (var2_2 != 7 && var2_2 != 8) ** GOTO lbl31
                if (var3_3 != null) break block14;
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                if (var2_2 == 7) {
                    this.addByteCode((byte)-102, var6_6);
                } else {
                    this.addByteCode((byte)-103, var6_6);
                }
                break block15;
            }
            if (var2_2 == 7) {
                this.generateCodeFromNode(var3_3, var1_1, var6_6, var7_7);
            } else {
                this.generateCodeFromNode(var3_3, var1_1, var7_7, var6_6);
            }
            if (var3_3.getType() == 104 && var3_3.getInt() == 128 || var3_3.getType() == 100 || var3_3.getType() == 99 || var3_3.getType() == 102 || var3_3.getType() == 101) break block15;
            this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
            if (var2_2 == 7) {
                this.addByteCode((byte)-102, var6_6);
            } else {
                this.addByteCode((byte)-103, var6_6);
            }
            break block15;
lbl-1000:
            // 1 sources

            {
                this.generateCodeFromNode(var3_3, var1_1, -1, -1);
                var3_3 = var3_3.getNextSibling();
lbl31:
                // 2 sources

                ** while (var3_3 != null)
            }
lbl32:
            // 1 sources

            if (var2_2 == 142) {
                this.addByteCode((byte)-88, var6_6);
            } else {
                this.addByteCode((byte)-89, var6_6);
            }
        }
        this.markLabel(var7_7);
    }

    private void visitGOTOingRelOp(Node node, Node node2, Node node3, int n, int n2) {
        int n3 = node.getInt();
        Integer n4 = (Integer)node.getProp(26);
        if (n4 != null && n4 == 0) {
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            this.genSimpleCompare(n3, n, n2);
        } else if (n3 == 64) {
            this.aload(this.variableObjectLocal);
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            this.addScriptRuntimeInvoke("instanceOf", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;)", "Z");
            this.addByteCode((byte)-102, n);
            this.addByteCode((byte)-89, n2);
        } else if (n3 == 63) {
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            this.aload(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("in", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Z");
            this.addByteCode((byte)-102, n);
            this.addByteCode((byte)-89, n2);
        } else {
            Object object;
            Node node4 = node2.getNextSibling();
            boolean bl = this.nodeIsDirectCallParameter(node2);
            boolean bl2 = this.nodeIsDirectCallParameter(node4);
            if (bl || bl2) {
                int n5;
                if (bl) {
                    if (bl2) {
                        object = (OptLocalVariable)node2.getProp(24);
                        this.aload(((OptLocalVariable)object).getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        n5 = this.acquireLabel();
                        this.addByteCode((byte)-90, n5);
                        OptLocalVariable optLocalVariable = (OptLocalVariable)node4.getProp(24);
                        this.aload(optLocalVariable.getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        this.addByteCode((byte)-90, n5);
                        this.dload((short)(((OptLocalVariable)object).getJRegister() + 1));
                        this.dload((short)(optLocalVariable.getJRegister() + 1));
                        this.genSimpleCompare(n3, n, n2);
                        this.markLabel(n5);
                    } else if (n4 != null && n4 == 2) {
                        object = (OptLocalVariable)node2.getProp(24);
                        this.aload(((OptLocalVariable)object).getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        n5 = this.acquireLabel();
                        this.addByteCode((byte)-90, n5);
                        this.dload((short)(((OptLocalVariable)object).getJRegister() + 1));
                        this.generateCodeFromNode(node4, node, -1, -1);
                        this.genSimpleCompare(n3, n, n2);
                        this.markLabel(n5);
                    }
                } else if (n4 != null && n4 == 1) {
                    object = (OptLocalVariable)node4.getProp(24);
                    this.aload(((OptLocalVariable)object).getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    n5 = this.acquireLabel();
                    this.addByteCode((byte)-90, n5);
                    this.generateCodeFromNode(node2, node, -1, -1);
                    this.dload((short)(((OptLocalVariable)object).getJRegister() + 1));
                    this.genSimpleCompare(n3, n, n2);
                    this.markLabel(n5);
                }
            }
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node4, node, -1, -1);
            if (n4 == null) {
                if (n3 == 19 || n3 == 18) {
                    this.addByteCode((byte)95);
                }
                object = n3 == 16 || n3 == 18 ? "cmp_LT" : "cmp_LE";
                this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)", "I");
            } else {
                String string;
                boolean bl3;
                boolean bl4 = bl3 = n4 == 1;
                if (n3 == 19 || n3 == 18) {
                    if (bl3) {
                        this.addByteCode((byte)91);
                        this.addByteCode((byte)87);
                        bl3 = false;
                    } else {
                        this.addByteCode((byte)93);
                        this.addByteCode((byte)88);
                        bl3 = true;
                    }
                }
                String string2 = string = n3 == 16 || n3 == 18 ? "cmp_LT" : "cmp_LE";
                if (bl3) {
                    this.addOptRuntimeInvoke(string, "(DLjava/lang/Object;)", "I");
                } else {
                    this.addOptRuntimeInvoke(string, "(Ljava/lang/Object;D)", "I");
                }
            }
            this.addByteCode((byte)-102, n);
            this.addByteCode((byte)-89, n2);
        }
    }

    private void visitGetProp(Node node, Node node2) {
        String string = (String)node.getProp(19);
        if (string != null) {
            while (node2 != null) {
                this.generateCodeFromNode(node2, node, -1, -1);
                node2 = node2.getNextSibling();
            }
            this.aload(this.variableObjectLocal);
            String string2 = null;
            if (string.equals("__proto__")) {
                string2 = "getProto";
            } else if (string.equals("__parent__")) {
                string2 = "getParent";
            } else {
                this.badTree();
            }
            this.addScriptRuntimeInvoke(string2, "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
            return;
        }
        Node node3 = node2.getNextSibling();
        this.generateCodeFromNode(node2, node, -1, -1);
        this.generateCodeFromNode(node3, node, -1, -1);
        if (node3.getType() == 46) {
            if (node2.getType() == 108 && node2.getInt() == 50 || node2.getType() == 69 && node2.getFirstChild().getType() == 108 && node2.getFirstChild().getInt() == 50) {
                this.aload(this.variableObjectLocal);
                this.addOptRuntimeInvoke("thisGet", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            } else {
                this.aload(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            }
        } else {
            this.aload(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
        }
    }

    private void visitGetVar(OptLocalVariable optLocalVariable, boolean bl, String string) {
        if (this.hasVarsInRegs && optLocalVariable == null) {
            optLocalVariable = (OptLocalVariable)this.vars.get(string);
        }
        if (optLocalVariable != null) {
            if (optLocalVariable.getJRegister() == -1) {
                if (optLocalVariable.isNumber()) {
                    optLocalVariable.assignJRegister(this.getNewWordPairLocal());
                } else {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                }
            }
            if (optLocalVariable.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters) {
                if (bl) {
                    this.aload(optLocalVariable.getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n = this.acquireLabel();
                    int n2 = this.acquireLabel();
                    this.addByteCode((byte)-91, n);
                    this.aload(optLocalVariable.getJRegister());
                    this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
                    this.addByteCode((byte)-89, n2);
                    this.markLabel(n);
                    this.dload((short)(optLocalVariable.getJRegister() + 1));
                    this.markLabel(n2);
                } else {
                    this.aload(optLocalVariable.getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n = this.acquireLabel();
                    int n3 = this.acquireLabel();
                    this.addByteCode((byte)-91, n);
                    this.aload(optLocalVariable.getJRegister());
                    this.addByteCode((byte)-89, n3);
                    this.markLabel(n);
                    this.addByteCode((byte)-69, "java/lang/Double");
                    this.addByteCode((byte)89);
                    this.dload((short)(optLocalVariable.getJRegister() + 1));
                    this.addDoubleConstructor();
                    this.markLabel(n3);
                }
            } else if (optLocalVariable.isNumber()) {
                this.dload(optLocalVariable.getJRegister());
            } else {
                this.aload(optLocalVariable.getJRegister());
            }
            return;
        }
        this.aload(this.variableObjectLocal);
        this.push(string);
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
    }

    private void visitIncDec(Node node, boolean bl) {
        Node node2 = node.getFirstChild();
        if (node.getProp(26) != null) {
            OptLocalVariable optLocalVariable = (OptLocalVariable)node2.getProp(24);
            if (optLocalVariable.getJRegister() == -1) {
                optLocalVariable.assignJRegister(this.getNewWordPairLocal());
            }
            this.dload(optLocalVariable.getJRegister());
            this.addByteCode((byte)92);
            this.push(1.0);
            this.addByteCode(bl ? (byte)99 : 103);
            this.dstore(optLocalVariable.getJRegister());
        } else {
            String string;
            OptLocalVariable optLocalVariable = (OptLocalVariable)node2.getProp(24);
            String string2 = string = bl ? "postIncrement" : "postDecrement";
            if (this.hasVarsInRegs && node2.getType() == 72) {
                if (optLocalVariable == null) {
                    optLocalVariable = (OptLocalVariable)this.vars.get(node2.getString());
                }
                if (optLocalVariable.getJRegister() == -1) {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                }
                this.aload(optLocalVariable.getJRegister());
                this.addByteCode((byte)89);
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;)", "Ljava/lang/Object;");
                this.astore(optLocalVariable.getJRegister());
            } else if (node2.getType() == 39) {
                Node node3 = node2.getFirstChild();
                this.generateCodeFromNode(node3, node, -1, -1);
                this.generateCodeFromNode(node3.getNextSibling(), node, -1, -1);
                this.aload(this.variableObjectLocal);
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            } else if (node2.getType() == 41) {
                string = String.valueOf(string) + "Elem";
                Node node4 = node2.getFirstChild();
                this.generateCodeFromNode(node4, node, -1, -1);
                this.generateCodeFromNode(node4.getNextSibling(), node, -1, -1);
                this.aload(this.variableObjectLocal);
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            } else {
                this.aload(this.variableObjectLocal);
                this.push(node2.getString());
                this.addScriptRuntimeInvoke(string, "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/Object;");
            }
        }
    }

    private void visitLeaveWith(Node node, Node node2) {
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("leaveWith", "(Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
        this.astore(this.variableObjectLocal);
    }

    private void visitLiteral(Node node) {
        if (node.getType() == 46) {
            this.push(node.getString());
        } else {
            Number number = (Number)node.getDatum();
            if (node.getProp(26) != null) {
                this.push(number.doubleValue());
            } else {
                String string = "";
                String string2 = "";
                boolean bl = false;
                if (number instanceof Float) {
                    number = new Double(number.floatValue());
                }
                if (number instanceof Integer) {
                    string = "Integer";
                    string2 = "I";
                    bl = true;
                } else if (number instanceof Double) {
                    string = "Double";
                    string2 = "D";
                } else if (number instanceof Byte) {
                    string = "Byte";
                    string2 = "B";
                    bl = true;
                } else if (number instanceof Short) {
                    string = "Short";
                    string2 = "S";
                    bl = true;
                } else {
                    throw Context.reportRuntimeError("NumberNode contains unsupported Number type: " + number.getClass().getName());
                }
                if (this.itsConstantList.itsTop >= 2000) {
                    this.addByteCode((byte)-69, "java/lang/" + string);
                    this.addByteCode((byte)89);
                    if (bl) {
                        this.push(number.longValue());
                    } else {
                        this.push(number.doubleValue());
                    }
                    this.addSpecialInvoke("java/lang/" + string, "<init>", "(" + string2 + ")", "V");
                } else {
                    this.classFile.add((byte)-78, ClassFileWriter.fullyQualifiedForm(this.name), "jsK_" + this.itsConstantList.addConstant(string, string2, number, bl), "Ljava/lang/" + string + ";");
                }
            }
        }
    }

    private void visitName(Node node) {
        this.aload(this.variableObjectLocal);
        this.push(node.getString());
        this.addScriptRuntimeInvoke("name", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/Object;");
    }

    private void visitNewLocal(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        short s = this.getLocalFromNode(node);
        this.addByteCode((byte)89);
        this.astore(s);
    }

    private void visitNewTemp(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        short s = this.getLocalFromNode(node);
        this.addByteCode((byte)89);
        this.astore(s);
        Integer n = (Integer)node.getProp(11);
        if (n == null || n == 0) {
            this.releaseWordLocal(s);
        }
    }

    private void visitObject(Node node) {
        Node node2 = (Node)node.getProp(12);
        String string = (String)node2.getProp(12);
        this.aload(this.funObjLocal);
        this.classFile.add((byte)-76, ClassFileWriter.fullyQualifiedForm(this.name), string, "Lorg/mozilla/javascript/regexp/NativeRegExp;");
    }

    private void visitPrimary(Node node) {
        int n = node.getInt();
        switch (n) {
            case 50: {
                this.aload(this.thisObjLocal);
                break;
            }
            case 49: {
                this.addByteCode((byte)1);
                break;
            }
            case 52: {
                this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                break;
            }
            case 51: {
                this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                break;
            }
            case 74: {
                this.pushUndefined();
                break;
            }
            default: {
                this.badTree();
            }
        }
    }

    private void visitRegularCall(Node node, int n, Node node2, boolean bl) {
        String string;
        String string2;
        String string3;
        Object object;
        OptFunctionNode optFunctionNode = (OptFunctionNode)node.getProp(27);
        Node node3 = node2;
        int n2 = 0;
        int n3 = n == 30 ? 1 : 2;
        while (node2 != null) {
            ++n2;
            node2 = node2.getNextSibling();
        }
        node2 = node3;
        int n4 = -n3;
        if (bl && node2 != null) {
            node2 = node2.getNextSibling();
            ++n4;
            this.aload(this.contextLocal);
            this.addByteCode((byte)95);
        } else {
            this.aload(this.contextLocal);
        }
        if (bl && n == 30) {
            this.constructArgArray(n2 - n3);
        }
        boolean bl2 = node.getProp(30) != null;
        boolean bl3 = false;
        String string4 = null;
        if (n != 30 && (string4 = this.getSimpleCallName(node)) != null && !bl2) {
            bl3 = true;
            this.push(string4);
            this.aload(this.variableObjectLocal);
            node2 = node2.getNextSibling().getNextSibling();
            n4 = 0;
            this.push(n2 - n3);
            this.addByteCode((byte)-67, "java/lang/Object");
        }
        while (node2 != null) {
            if (n4 < 0) {
                this.generateCodeFromNode(node2, node, -1, -1);
            } else {
                this.addByteCode((byte)89);
                this.push(n4);
                if (optFunctionNode != null) {
                    boolean bl4 = false;
                    if (node2.getType() == 72 && this.inDirectCallFunction && ((LocalVariable)(object = (OptLocalVariable)node2.getProp(24))).isParameter()) {
                        node2.putProp(26, null);
                        this.generateCodeFromNode(node2, node, -1, -1);
                        bl4 = true;
                    }
                    if (!bl4) {
                        object = (Integer)node2.getProp(26);
                        if (object != null && (Integer)object == 0) {
                            this.addByteCode((byte)-69, "java/lang/Double");
                            this.addByteCode((byte)89);
                            this.generateCodeFromNode(node2, node, -1, -1);
                            this.addDoubleConstructor();
                        } else {
                            this.generateCodeFromNode(node2, node, -1, -1);
                        }
                    }
                } else {
                    this.generateCodeFromNode(node2, node, -1, -1);
                }
                this.addByteCode((byte)83);
            }
            if (++n4 == 0) {
                this.constructArgArray(n2 - n3);
            }
            node2 = node2.getNextSibling();
        }
        if (bl2) {
            string3 = "org/mozilla/javascript/ScriptRuntime";
            object = "newObjectSpecial";
            string2 = "callSpecial";
            if (n != 30) {
                string = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;I)";
                this.aload(this.thisObjLocal);
                this.aload(this.variableObjectLocal);
                this.push(this.itsSourceFile == null ? "" : this.itsSourceFile);
                this.push(this.itsLineNumber);
            } else {
                string = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)";
                this.aload(this.variableObjectLocal);
            }
        } else {
            object = "newObject";
            if (bl3) {
                string = "(Lorg/mozilla/javascript/Context;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)";
                string2 = "callSimple";
                string3 = "org/mozilla/javascript/optimizer/OptRuntime";
            } else {
                this.aload(this.variableObjectLocal);
                string = n == 30 ? "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)" : "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)";
                string2 = "call";
                string3 = "org/mozilla/javascript/ScriptRuntime";
            }
        }
        if (n == 30) {
            this.addStaticInvoke(string3, (String)object, string, "Lorg/mozilla/javascript/Scriptable;");
        } else {
            this.addStaticInvoke(string3, string2, string, "Ljava/lang/Object;");
        }
    }

    private void visitRelOp(Node node, Node node2, Node node3) {
        int n = node.getInt();
        Integer n2 = (Integer)node.getProp(26);
        if (n2 != null && n2 == 0 || n == 64 || n == 63) {
            if (n == 64) {
                this.aload(this.variableObjectLocal);
            }
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            int n3 = this.acquireLabel();
            int n4 = this.acquireLabel();
            if (n == 64) {
                this.addScriptRuntimeInvoke("instanceOf", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                this.addByteCode((byte)-102, n3);
            } else if (n == 63) {
                this.addScriptRuntimeInvoke("in", "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                this.addByteCode((byte)-102, n3);
            } else {
                this.genSimpleCompare(n, n3, -1);
            }
            this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            this.addByteCode((byte)-89, n4);
            this.markLabel(n3);
            this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            this.markLabel(n4);
            this.classFile.adjustStackTop(-1);
        } else {
            String string = n == 16 || n == 18 ? "cmp_LTB" : "cmp_LEB";
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            if (n2 == null) {
                if (n == 19 || n == 18) {
                    this.addByteCode((byte)95);
                }
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Boolean;");
            } else {
                boolean bl;
                boolean bl2 = bl = n2 == 1;
                if (n == 19 || n == 18) {
                    if (bl) {
                        this.addByteCode((byte)91);
                        this.addByteCode((byte)87);
                        bl = false;
                    } else {
                        this.addByteCode((byte)93);
                        this.addByteCode((byte)88);
                        bl = true;
                    }
                }
                if (bl) {
                    this.addOptRuntimeInvoke(string, "(DLjava/lang/Object;)", "Ljava/lang/Boolean;");
                } else {
                    this.addOptRuntimeInvoke(string, "(Ljava/lang/Object;D)", "Ljava/lang/Boolean;");
                }
            }
        }
    }

    private void visitReturn(Node node, Node node2) {
        this.visitStatement(node);
        if (node2 != null) {
            do {
                this.generateCodeFromNode(node2, node, -1, -1);
            } while ((node2 = node2.getNextSibling()) != null);
        } else if (this.inFunction) {
            this.pushUndefined();
        } else {
            this.aload(this.scriptResultLocal);
        }
        if (this.epilogueLabel == -1) {
            this.epilogueLabel = this.classFile.acquireLabel();
        }
        this.addByteCode((byte)-89, this.epilogueLabel);
    }

    private void visitSetName(Node node, Node node2) {
        String string = node.getFirstChild().getString();
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        this.aload(this.variableObjectLocal);
        this.push(string);
        this.addScriptRuntimeInvoke("setName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/Object;");
    }

    /*
     * Unable to fully structure code
     */
    private void visitSetProp(Node var1_1, Node var2_2) {
        var3_3 = (String)var1_1.getProp(19);
        if (var3_3 == null) ** GOTO lbl20
        while (var2_2 != null) {
            this.generateCodeFromNode(var2_2, var1_1, -1, -1);
            var2_2 = var2_2.getNextSibling();
        }
        this.aload(this.variableObjectLocal);
        var4_4 = null;
        if (var3_3.equals("__proto__")) {
            var4_4 = "setProto";
        } else if (var3_3.equals("__parent__")) {
            var4_4 = "setParent";
        } else {
            this.badTree();
        }
        this.addScriptRuntimeInvoke(var4_4, "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
        return;
lbl-1000:
        // 1 sources

        {
            this.generateCodeFromNode(var2_2, var1_1, -1, -1);
            var2_2 = var2_2.getNextSibling();
lbl20:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl21:
        // 1 sources

        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("setProp", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
    }

    private void visitSetVar(Node node, Node node2, boolean bl) {
        OptLocalVariable optLocalVariable = (OptLocalVariable)node.getProp(24);
        if (this.hasVarsInRegs && optLocalVariable == null) {
            optLocalVariable = (OptLocalVariable)this.vars.get(node2.getString());
        }
        if (optLocalVariable != null) {
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            if (optLocalVariable.getJRegister() == -1) {
                if (optLocalVariable.isNumber()) {
                    optLocalVariable.assignJRegister(this.getNewWordPairLocal());
                } else {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                }
            }
            if (optLocalVariable.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters) {
                if (node.getProp(26) != null) {
                    if (bl) {
                        this.addByteCode((byte)92);
                    }
                    this.aload(optLocalVariable.getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n = this.acquireLabel();
                    int n2 = this.acquireLabel();
                    this.addByteCode((byte)-91, n);
                    this.addByteCode((byte)-69, "java/lang/Double");
                    this.addByteCode((byte)89);
                    this.addByteCode((byte)94);
                    this.addByteCode((byte)88);
                    this.addDoubleConstructor();
                    this.astore(optLocalVariable.getJRegister());
                    this.addByteCode((byte)-89, n2);
                    this.markLabel(n);
                    this.dstore((short)(optLocalVariable.getJRegister() + 1));
                    this.markLabel(n2);
                } else {
                    if (bl) {
                        this.addByteCode((byte)89);
                    }
                    this.astore(optLocalVariable.getJRegister());
                }
            } else if (node.getProp(26) != null) {
                this.dstore(optLocalVariable.getJRegister());
                if (bl) {
                    this.dload(optLocalVariable.getJRegister());
                }
            } else {
                this.astore(optLocalVariable.getJRegister());
                if (bl) {
                    this.aload(optLocalVariable.getJRegister());
                }
            }
            return;
        }
        node2.setType(61);
        node.setType(10);
        this.visitSetName(node, node2);
        if (!bl) {
            this.addByteCode((byte)87);
        }
    }

    private void visitStatement(Node node) {
        Object object = node.getDatum();
        if (object == null || !(object instanceof Number)) {
            return;
        }
        this.itsLineNumber = ((Number)object).shortValue();
        if (this.itsLineNumber == -1) {
            return;
        }
        this.classFile.addLineNumberEntry((short)this.itsLineNumber);
    }

    private void visitSwitch(Node node, Node node2) {
        Node node3;
        Node node4;
        this.visitStatement(node);
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        short s = this.getNewWordLocal();
        this.astore(s);
        Vector vector = (Vector)node.getProp(13);
        int n = 0;
        while (n < vector.size()) {
            node4 = (Node)vector.elementAt(n);
            node3 = node4.getFirstChild();
            this.generateCodeFromNode(node3, node4, -1, -1);
            this.aload(s);
            this.addScriptRuntimeInvoke("seqB", "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Boolean;");
            Node node5 = new Node(136);
            node4.replaceChild(node3, node5);
            this.generateGOTO(7, node5);
            ++n;
        }
        node4 = (Node)node.getProp(14);
        if (node4 != null) {
            node3 = new Node(136);
            node4.getFirstChild().addChildToFront(node3);
            this.generateGOTO(6, node3);
        }
        node3 = (Node)node.getProp(2);
        this.generateGOTO(6, node3);
    }

    private void visitTarget(Node node) {
        Object object = node.getProp(20);
        if (object == null) {
            int n = this.markLabel(this.acquireLabel());
            node.putProp(20, new Integer(n));
        } else {
            int n = (Integer)object;
            this.markLabel(n);
        }
    }

    private void visitThrow(Node node, Node node2) {
        this.visitStatement(node);
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        this.addByteCode((byte)-69, "org/mozilla/javascript/JavaScriptException");
        this.addByteCode((byte)90);
        this.addByteCode((byte)95);
        this.addSpecialInvoke("org/mozilla/javascript/JavaScriptException", "<init>", "(Ljava/lang/Object;)", "V");
        this.addByteCode((byte)-65);
    }

    private void visitTryCatchFinally(Node node, Node node2) {
        int n;
        short s;
        int n2;
        short s2 = this.getNewWordLocal();
        this.aload(this.variableObjectLocal);
        this.astore(s2);
        int n3 = this.markLabel(this.acquireLabel(), (short)1);
        this.visitStatement(node);
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        Node node3 = (Node)node.getProp(1);
        Node node4 = (Node)node.getProp(21);
        int n4 = this.acquireLabel();
        this.addByteCode((byte)-89, n4);
        if (node3 != null) {
            n2 = this.classFile.markHandler(this.acquireLabel());
            s = this.getNewWordLocal();
            this.astore(s);
            this.aload(s2);
            this.astore(this.variableObjectLocal);
            this.aload(s);
            this.releaseWordLocal(s);
            this.addScriptRuntimeInvoke("unwrapJavaScriptException", "(Lorg/mozilla/javascript/JavaScriptException;)", "Ljava/lang/Object;");
            n = (Integer)node3.getProp(20);
            this.addByteCode((byte)-89, n);
            this.classFile.addExceptionHandler(n3, n, n2, "org/mozilla/javascript/JavaScriptException");
            n2 = this.classFile.markHandler(this.acquireLabel());
            s = this.getNewWordLocal();
            this.astore(s);
            this.aload(s2);
            this.astore(this.variableObjectLocal);
            this.aload(s);
            this.addVirtualInvoke("org/mozilla/javascript/EcmaError", "getErrorObject", "()", "Lorg/mozilla/javascript/Scriptable;");
            this.releaseWordLocal(s);
            this.addByteCode((byte)-89, n);
            this.classFile.addExceptionHandler(n3, n, n2, "org/mozilla/javascript/EcmaError");
        }
        if (node4 != null) {
            n2 = this.classFile.markHandler(this.acquireLabel());
            this.aload(s2);
            this.astore(this.variableObjectLocal);
            short s3 = this.itsLocalAllocationBase;
            this.itsLocalAllocationBase = (short)(s3 + 1);
            s = s3;
            this.astore(s);
            n = (Integer)node4.getProp(20);
            this.addByteCode((byte)-88, n);
            this.aload(s);
            this.addByteCode((byte)-65);
            this.classFile.addExceptionHandler(n3, n, n2, null);
        }
        this.releaseWordLocal(s2);
        this.markLabel(n4);
    }

    private void visitTypeof(Node node, Node node2) {
        OptLocalVariable optLocalVariable;
        if (node.getType() == 104) {
            this.generateCodeFromNode(node2, node, -1, -1);
            this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)", "Ljava/lang/String;");
            return;
        }
        String string = node.getString();
        if (this.hasVarsInRegs && (optLocalVariable = (OptLocalVariable)this.vars.get(string)) != null) {
            if (optLocalVariable.isNumber()) {
                this.push("number");
                return;
            }
            this.visitGetVar(optLocalVariable, false, string);
            this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)", "Ljava/lang/String;");
            return;
        }
        this.aload(this.variableObjectLocal);
        this.push(string);
        this.addScriptRuntimeInvoke("typeofName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/String;");
    }

    private void visitUnary(Node node, Node node2, int n, int n2) {
        int n3 = node.getInt();
        switch (n3) {
            case 128: {
                if (n != -1) {
                    this.generateCodeFromNode(node2, node, n2, n);
                    if (node2.getType() == 104 && node2.getInt() == 128 || node2.getType() == 100 || node2.getType() == 99 || node2.getType() == 102 || node2.getType() == 101) break;
                    this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                    this.addByteCode((byte)-102, n2);
                    this.addByteCode((byte)-89, n);
                    break;
                }
                int n4 = this.acquireLabel();
                int n5 = this.acquireLabel();
                int n6 = this.acquireLabel();
                this.generateCodeFromNode(node2, node, n4, n5);
                if ((node2.getType() != 104 || node2.getInt() != 128) && node2.getType() != 100 && node2.getType() != 99 && node2.getType() != 102 && node2.getType() != 101) {
                    this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                    this.addByteCode((byte)-103, n5);
                    this.addByteCode((byte)-89, n4);
                }
                this.markLabel(n4);
                this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                this.addByteCode((byte)-89, n6);
                this.markLabel(n5);
                this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                this.markLabel(n6);
                this.classFile.adjustStackTop(-1);
                break;
            }
            case 32: {
                this.visitTypeof(node, node2);
                break;
            }
            case 131: {
                this.generateCodeFromNode(node2, node, -1, -1);
                this.addByteCode((byte)87);
                this.pushUndefined();
                break;
            }
            case 28: {
                this.addByteCode((byte)-69, "java/lang/Double");
                this.addByteCode((byte)89);
                this.generateCodeFromNode(node2, node, -1, -1);
                this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
                this.push(-1L);
                this.addByteCode((byte)-126);
                this.addByteCode((byte)-121);
                this.addDoubleConstructor();
                break;
            }
            case 23: 
            case 24: {
                this.addByteCode((byte)-69, "java/lang/Double");
                this.addByteCode((byte)89);
                this.generateCodeFromNode(node2, node, -1, -1);
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
                if (n3 == 24) {
                    this.addByteCode((byte)119);
                }
                this.addDoubleConstructor();
                break;
            }
            default: {
                this.badTree();
            }
        }
    }

    private void visitUseLocal(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        Node node3 = (Node)node.getProp(7);
        short s = this.getLocalFromNode(node3);
        if (node.getProp(1) != null) {
            this.addByteCode((byte)-87, s);
        } else {
            this.aload(s);
        }
    }

    private void visitUseTemp(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        Node node3 = (Node)node.getProp(6);
        short s = this.getLocalFromNode(node3);
        if (node.getProp(1) != null) {
            this.addByteCode((byte)-87, s);
        } else {
            this.aload(s);
        }
        Integer n = (Integer)node3.getProp(11);
        if (n == null) {
            this.releaseWordLocal(s);
        } else if (n < Integer.MAX_VALUE) {
            int n2 = n - 1;
            if (n2 == 0) {
                this.releaseWordLocal(s);
            }
            node3.putProp(11, new Integer(n2));
        }
    }

    private void writeDebugPCEntries() {
    }

    private void xload(byte by, byte by2, short s) {
        switch (s) {
            case 0: {
                this.addByteCode(by);
                break;
            }
            case 1: {
                this.addByteCode((byte)(by + 1));
                break;
            }
            case 2: {
                this.addByteCode((byte)(by + 2));
                break;
            }
            case 3: {
                this.addByteCode((byte)(by + 3));
                break;
            }
            default: {
                if (s < 0 || s >= 127) {
                    throw new RuntimeException("bad local");
                }
                this.addByteCode(by2, (byte)s);
            }
        }
    }

    private void xstore(byte by, byte by2, short s) {
        switch (s) {
            case 0: {
                this.addByteCode(by);
                break;
            }
            case 1: {
                this.addByteCode((byte)(by + 1));
                break;
            }
            case 2: {
                this.addByteCode((byte)(by + 2));
                break;
            }
            case 3: {
                this.addByteCode((byte)(by + 3));
                break;
            }
            default: {
                if (s < 0 || s >= 127) {
                    throw new RuntimeException("bad local");
                }
                this.addByteCode(by2, (byte)s);
            }
        }
    }
}

