/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.TokenStream;

class TestScan {
    static /* synthetic */ Class class$org$mozilla$javascript$Node;
    static /* synthetic */ Class class$java$lang$Integer;

    TestScan() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = null;
        String string2 = "nt";
        int n = 0;
        if (stringArray.length == 1) {
            string = stringArray[0];
            string2 = "-nt";
        } else if (stringArray.length == 2) {
            string = stringArray[1];
            string2 = stringArray[0];
        } else if (stringArray.length == 3 && stringArray[0].equals("-opt")) {
            n = Integer.parseInt(stringArray[1]);
            string = stringArray[2];
            string2 = "-opt";
        } else if (stringArray.length > 1 && stringArray[0].equals("-compile")) {
            string2 = "-compile";
            if (stringArray.length == 3) {
                string = stringArray[2];
                n = Integer.parseInt(stringArray[1]);
            } else if (stringArray.length == 2) {
                string = stringArray[1];
            } else {
                TestScan.usage();
                System.exit(1);
            }
        } else {
            TestScan.usage();
            System.exit(1);
        }
        TestScan.scan(string2, string, n);
    }

    public static void scan(String string, String string2, int n) throws IOException {
        FileReader fileReader = null;
        string = string.intern();
        try {
            fileReader = new FileReader(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("couldn't open file " + string2);
            System.exit(1);
        }
        Context context = new Context();
        try {
            Context.enter();
        }
        catch (Throwable throwable) {}
        if (string == "-compile") {
            context.setOptimizationLevel(n);
            context.compileReader(null, fileReader, string2, 1, null);
            return;
        }
        TokenStream tokenStream = new TokenStream(fileReader, null, string2, 1);
        if (string == "-scan") {
            int n2;
            while ((n2 = tokenStream.getToken()) != 0) {
            }
        } else if (string == "-ir") {
            IRFactory iRFactory = new IRFactory(tokenStream, null);
            Parser parser = new Parser(iRFactory);
            Node node = (Node)parser.parse(tokenStream);
            System.out.print(node.toStringTree());
        } else if (string == "-nt") {
            IRFactory iRFactory = new IRFactory(tokenStream, null);
            NodeTransformer nodeTransformer = new NodeTransformer();
            Parser parser = new Parser(iRFactory);
            Node node = (Node)parser.parse(tokenStream);
            nodeTransformer.transform(node, null, tokenStream, null);
            System.out.print(node.toStringTree());
        } else if (string == "-opt") {
            IRFactory iRFactory = new IRFactory(tokenStream, null);
            NodeTransformer nodeTransformer = new NodeTransformer();
            Parser parser = new Parser(iRFactory);
            Node node = (Node)parser.parse(tokenStream);
            nodeTransformer.transform(node, null, tokenStream, null);
            context.setOptimizationLevel(n);
            try {
                Class<?> clazz = Class.forName("org.mozilla.javascript.optimizer.Optimizer");
                Object obj = clazz.newInstance();
                Class[] classArray = new Class[]{class$org$mozilla$javascript$Node != null ? class$org$mozilla$javascript$Node : (class$org$mozilla$javascript$Node = TestScan.class$("org.mozilla.javascript.Node")), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = TestScan.class$("java.lang.Integer"))};
                Method method = clazz.getDeclaredMethod("optimize", classArray);
                Object[] objectArray = new Object[]{node, new Integer(n)};
                method.invoke(obj, objectArray);
                System.out.print(node.toStringTree());
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        } else {
            TestScan.usage();
            return;
        }
    }

    static void usage() {
        System.err.println("usage: TestScan    [-compile [level] | -scan | -ir | -nt | -opt [level] ] filename.js");
        System.err.println("\t-compile [level] - compile the given file and return, for profiling");
        System.err.println("\t-scan            - list tokens");
        System.err.println("\t-ir              - print Internal Representation parse tree");
        System.err.println("\t-nt              - print NodeTransformed IR tree");
        System.err.println("\t-opt [level]     - print transformed and optimized IR tree");
        System.err.println();
        System.err.println("(note that nothing may be printed by the above if Context.printTrees is false.)");
    }
}

