/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeArray
extends ScriptableObject {
    private static final int lengthAttr = 6;
    private long length;
    private Object[] dense;
    private static final int maximumDenseLength = 10000;

    public NativeArray() {
        this.dense = null;
        this.length = 0L;
    }

    public NativeArray(long l) {
        int n = (int)l;
        if ((long)n == l && n > 0) {
            if (n > 10000) {
                n = 10000;
            }
            this.dense = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                this.dense[n2] = Scriptable.NOT_FOUND;
                ++n2;
            }
        }
        this.length = l;
    }

    public NativeArray(Object[] objectArray) {
        this.dense = objectArray;
        this.length = objectArray.length;
    }

    public void delete(int n) {
        if (this.dense != null && n >= 0 && n < this.dense.length) {
            this.dense[n] = Scriptable.NOT_FOUND;
            return;
        }
        super.delete(n);
    }

    public static void finishInit(Scriptable scriptable, FunctionObject functionObject, Scriptable scriptable2) {
        String[] stringArray = new String[]{"reverse", "toString"};
        short[] sArray = new short[2];
        int n = 0;
        while (n < stringArray.length) {
            Object object = scriptable2.get(stringArray[n], scriptable2);
            ((FunctionObject)object).setLength(sArray[n]);
            ++n;
        }
    }

    public Object get(int n, Scriptable scriptable) {
        if (this.dense != null && n >= 0 && n < this.dense.length) {
            return this.dense[n];
        }
        return super.get(n, scriptable);
    }

    public String getClassName() {
        return "Array";
    }

    public Object getDefaultValue(Class clazz) {
        Context context;
        if (clazz == ScriptRuntime.NumberClass && (context = Context.getContext()).getLanguageVersion() == 120) {
            return new Long(this.length);
        }
        return super.getDefaultValue(clazz);
    }

    private static Object getElem(Scriptable scriptable, long l) {
        if (l > Integer.MAX_VALUE) {
            String string = Long.toString(l);
            return ScriptRuntime.getElem(scriptable, string, scriptable);
        }
        return ScriptRuntime.getElem(scriptable, (int)l);
    }

    public Object[] getIds() {
        Object[] objectArray = super.getIds();
        if (this.dense == null) {
            return objectArray;
        }
        int n = 0;
        int n2 = this.dense.length;
        if ((long)n2 > this.length) {
            n2 = (int)this.length;
        }
        int n3 = n2 - 1;
        while (n3 >= 0) {
            if (this.dense[n3] != Scriptable.NOT_FOUND) {
                ++n;
            }
            --n3;
        }
        Object[] objectArray2 = new Object[n += objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        int n4 = n2 - 1;
        while (n4 >= 0) {
            if (this.dense[n4] != Scriptable.NOT_FOUND) {
                objectArray2[--n] = new Integer(n4);
            }
            --n4;
        }
        return objectArray2;
    }

    static double getLengthProperty(Scriptable scriptable) {
        if (scriptable instanceof NativeString) {
            return ((NativeString)scriptable).jsGet_length();
        }
        if (scriptable instanceof NativeArray) {
            return ((NativeArray)scriptable).jsGet_length();
        }
        return ScriptRuntime.toUint32(ScriptRuntime.getProp(scriptable, "length", scriptable));
    }

    public boolean has(int n, Scriptable scriptable) {
        if (this.dense != null && n >= 0 && n < this.dense.length) {
            return this.dense[n] != Scriptable.NOT_FOUND;
        }
        return super.has(n, scriptable);
    }

    private static boolean hasElem(Scriptable scriptable, long l) {
        return l > Integer.MAX_VALUE ? scriptable.has(Long.toString(l), scriptable) : scriptable.has((int)l, scriptable);
    }

    static boolean hasLengthProperty(Object object) {
        if (!(object instanceof Scriptable) || object == Context.getUndefinedValue()) {
            return false;
        }
        if (object instanceof NativeString || object instanceof NativeArray) {
            return true;
        }
        Scriptable scriptable = (Scriptable)object;
        Object object2 = ScriptRuntime.getProp(scriptable, "length", scriptable);
        return object2 instanceof Number;
    }

    public static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) throws JavaScriptException {
        if (!bl) {
            return function.construct(context, function.getParentScope(), objectArray);
        }
        if (objectArray.length == 0) {
            return new NativeArray();
        }
        if (context.getLanguageVersion() == 120) {
            return new NativeArray(objectArray);
        }
        if (objectArray.length > 1 || !(objectArray[0] instanceof Number)) {
            return new NativeArray(objectArray);
        }
        long l = ScriptRuntime.toUint32(objectArray[0]);
        if ((double)l != ((Number)objectArray[0]).doubleValue()) {
            throw Context.reportRuntimeError(Context.getMessage("msg.arraylength.bad", null));
        }
        return new NativeArray(l);
    }

    public static Scriptable jsFunction_concat(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(function);
        Scriptable scriptable3 = ScriptRuntime.newObject(context, scriptable2, "Array", null);
        long l = 0L;
        if (NativeArray.hasLengthProperty(scriptable)) {
            d = NativeArray.getLengthProperty(scriptable);
            l = 0L;
            while ((double)l < d) {
                Object object = NativeArray.getElem(scriptable, l);
                NativeArray.setElem(scriptable3, l, object);
                ++l;
            }
        } else {
            NativeArray.setElem(scriptable3, l++, scriptable);
        }
        int n = 0;
        while (n < objectArray.length) {
            if (NativeArray.hasLengthProperty(objectArray[n])) {
                Scriptable scriptable4 = (Scriptable)objectArray[n];
                d = NativeArray.getLengthProperty(scriptable4);
                long l2 = 0L;
                while ((double)l2 < d) {
                    Object object = NativeArray.getElem(scriptable4, l2);
                    NativeArray.setElem(scriptable3, l, object);
                    ++l2;
                    ++l;
                }
            } else {
                NativeArray.setElem(scriptable3, l++, objectArray[n]);
            }
            ++n;
        }
        return scriptable3;
    }

    public static String jsFunction_join(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        StringBuffer stringBuffer = new StringBuffer();
        double d = NativeArray.getLengthProperty(scriptable);
        String string = objectArray.length < 1 ? "," : ScriptRuntime.toString(objectArray[0]);
        long l = 0L;
        while ((double)l < d) {
            Object object;
            if (l > 0L) {
                stringBuffer.append(string);
            }
            if ((object = NativeArray.getElem(scriptable, l)) != null && object != Undefined.instance) {
                stringBuffer.append(ScriptRuntime.toString(object));
            }
            ++l;
        }
        return stringBuffer.toString();
    }

    public static Object jsFunction_pop(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d = NativeArray.getLengthProperty(scriptable);
        Object object = d > 0.0 ? NativeArray.getElem(scriptable, (long)(d -= 1.0)) : Context.getUndefinedValue();
        ScriptRuntime.setProp(scriptable, "length", new Double(d), scriptable);
        return object;
    }

    public static Object jsFunction_push(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d = NativeArray.getLengthProperty(scriptable);
        int n = 0;
        while (n < objectArray.length) {
            NativeArray.setElem(scriptable, (long)d + (long)n, objectArray[n]);
            ++n;
        }
        ScriptRuntime.setProp(scriptable, "length", new Double(d += (double)objectArray.length), scriptable);
        if (context.getLanguageVersion() == 120) {
            return objectArray.length == 0 ? Context.getUndefinedValue() : objectArray[objectArray.length - 1];
        }
        return new Long((long)d);
    }

    public static Scriptable jsFunction_reverse(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        long l = (long)NativeArray.getLengthProperty(scriptable);
        long l2 = l / 2L;
        long l3 = 0L;
        while (l3 < l2) {
            long l4 = l - l3 - 1L;
            Object object = NativeArray.getElem(scriptable, l3);
            Object object2 = NativeArray.getElem(scriptable, l4);
            NativeArray.setElem(scriptable, l3, object2);
            NativeArray.setElem(scriptable, l4, object);
            ++l3;
        }
        return scriptable;
    }

    public static Object jsFunction_shift(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Object object;
        double d = NativeArray.getLengthProperty(scriptable);
        if (d > 0.0) {
            long l = 0L;
            d -= 1.0;
            object = NativeArray.getElem(scriptable, l);
            if (d > 0.0) {
                l = 1L;
                while ((double)l <= d) {
                    Object object2 = NativeArray.getElem(scriptable, l);
                    NativeArray.setElem(scriptable, l - 1L, object2);
                    ++l;
                }
            }
        } else {
            object = Context.getUndefinedValue();
        }
        ScriptRuntime.setProp(scriptable, "length", new Double(d), scriptable);
        return object;
    }

    public static Scriptable jsFunction_slice(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(function);
        Scriptable scriptable3 = ScriptRuntime.newObject(context, scriptable2, "Array", null);
        double d = NativeArray.getLengthProperty(scriptable);
        double d2 = 0.0;
        double d3 = d;
        if (objectArray.length > 0) {
            d2 = ScriptRuntime.toInteger(objectArray[0]);
            if (d2 < 0.0) {
                if ((d2 += d) < 0.0) {
                    d2 = 0.0;
                }
            } else if (d2 > d) {
                d2 = d;
            }
            if (objectArray.length > 1) {
                d3 = ScriptRuntime.toInteger(objectArray[1]);
                if (d3 < 0.0) {
                    if ((d3 += d) < 0.0) {
                        d3 = 0.0;
                    }
                } else if (d3 > d) {
                    d3 = d;
                }
            }
        }
        long l = (long)d2;
        long l2 = (long)d3;
        long l3 = l;
        while (l3 < l2) {
            Object object = NativeArray.getElem(scriptable, l3);
            NativeArray.setElem(scriptable3, l3 - l, object);
            ++l3;
        }
        return scriptable3;
    }

    public static Scriptable jsFunction_sort(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        long l = (long)NativeArray.getLengthProperty(scriptable);
        Object object = objectArray.length > 0 && Undefined.instance != objectArray[0] ? objectArray[0] : null;
        if (l >= Integer.MAX_VALUE) {
            NativeArray.qsort_extended(context, object, scriptable, 0L, l - 1L);
        } else {
            Object[] objectArray2 = new Object[(int)l];
            int n = 0;
            while ((long)n < l) {
                objectArray2[n] = NativeArray.getElem(scriptable, n);
                ++n;
            }
            NativeArray.qsort(context, object, objectArray2, 0, (int)l - 1, function);
            int n2 = 0;
            while ((long)n2 < l) {
                NativeArray.setElem(scriptable, n2, objectArray2[n2]);
                ++n2;
            }
        }
        return scriptable;
    }

    public static Object jsFunction_splice(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Object object;
        long l;
        double d;
        double d2;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(function);
        Object object2 = ScriptRuntime.newObject(context, scriptable2, "Array", null);
        int n = objectArray.length;
        if (n == 0) {
            return object2;
        }
        double d3 = NativeArray.getLengthProperty(scriptable);
        double d4 = ScriptRuntime.toInteger(objectArray[0]);
        if (d4 < 0.0) {
            if ((d4 += d3) < 0.0) {
                d4 = 0.0;
            }
        } else if (d4 > d3) {
            d4 = d3;
        }
        --n;
        double d5 = d3 - d4;
        if (objectArray.length == 1) {
            d2 = d5;
            d = d3;
        } else {
            d2 = ScriptRuntime.toInteger(objectArray[1]);
            if (d2 < 0.0) {
                d2 = 0.0;
            } else if (d2 > d5) {
                d2 = d5;
            }
            d = d4 + d2;
            --n;
        }
        long l2 = (long)d4;
        long l3 = (long)d;
        if (d2 > 0.0) {
            if (d2 == 1.0 && context.getLanguageVersion() == 120) {
                object2 = NativeArray.getElem(scriptable, l2);
            } else {
                l = l2;
                while (l < l3) {
                    object = (Scriptable)object2;
                    Object object3 = NativeArray.getElem(scriptable, l);
                    NativeArray.setElem((Scriptable)object, l - l2, object3);
                    ++l;
                }
            }
        } else if (d2 == 0.0 && context.getLanguageVersion() == 120) {
            object2 = Context.getUndefinedValue();
        }
        d5 = (double)n - d2;
        if (d5 > 0.0) {
            l = (long)d3 - 1L;
            while (l >= l3) {
                object = NativeArray.getElem(scriptable, l);
                NativeArray.setElem(scriptable, l + (long)d5, object);
                --l;
            }
        } else if (d5 < 0.0) {
            l = l3;
            while ((double)l < d3) {
                object = NativeArray.getElem(scriptable, l);
                NativeArray.setElem(scriptable, l + (long)d5, object);
                ++l;
            }
        }
        int n2 = objectArray.length - n;
        int n3 = 0;
        while (n3 < n) {
            NativeArray.setElem(scriptable, l2 + (long)n3, objectArray[n3 + n2]);
            ++n3;
        }
        ScriptRuntime.setProp(scriptable, "length", new Double(d3 + d5), scriptable);
        return object2;
    }

    public static String jsFunction_toString(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeArray.toStringHelper(context, scriptable, context.getLanguageVersion() == 120);
    }

    public static Object jsFunction_unshift(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d = NativeArray.getLengthProperty(scriptable);
        int n = objectArray.length;
        if (objectArray.length > 0) {
            if (d > 0.0) {
                long l = (long)d - 1L;
                while (l >= 0L) {
                    Object object = NativeArray.getElem(scriptable, l);
                    NativeArray.setElem(scriptable, l + (long)n, object);
                    --l;
                }
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                NativeArray.setElem(scriptable, n2, objectArray[n2]);
                ++n2;
            }
            ScriptRuntime.setProp(scriptable, "length", new Double(d += (double)objectArray.length), scriptable);
        }
        return new Long((long)d);
    }

    public long jsGet_length() {
        return this.length;
    }

    public void jsSet_length(Object object) {
        if (!(object instanceof Number)) {
            throw Context.reportRuntimeError(Context.getMessage("msg.arraylength.bad", null));
        }
        long l = ScriptRuntime.toUint32(object);
        if ((double)l != ((Number)object).doubleValue()) {
            throw Context.reportRuntimeError(Context.getMessage("msg.arraylength.bad", null));
        }
        if (l < this.length) {
            if (this.length - l > 4096L) {
                Object[] objectArray = this.getIds();
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] instanceof String) {
                        String string = (String)objectArray[n];
                        double d = ScriptRuntime.toNumber(string);
                        if (d == d && d < (double)this.length) {
                            this.delete(string);
                        }
                    } else {
                        int n2 = ((Number)objectArray[n]).intValue();
                        if ((long)n2 >= l) {
                            this.delete(n2);
                        }
                    }
                    ++n;
                }
            } else {
                long l2 = l;
                while (l2 < this.length) {
                    if (NativeArray.hasElem(this, l2)) {
                        ScriptRuntime.delete(this, new Long(l2));
                    }
                    ++l2;
                }
            }
        }
        this.length = l;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (this.length <= (long)n) {
            this.length = (long)n + 1L;
        }
        if (this.dense != null && n >= 0 && n < this.dense.length) {
            this.dense[n] = object;
            return;
        }
        super.put(n, scriptable, object);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        double d = ScriptRuntime.toNumber(string);
        if ((double)ScriptRuntime.toUint32(d) == d && ScriptRuntime.numberToString(d, 10).equals(string) && (double)this.length <= d && d != 4.294967295E9) {
            this.length = (long)d + 1L;
        }
        super.put(string, scriptable, object);
    }

    private static void qsort(Context context, Object object, Object[] objectArray, int n, int n2, Scriptable scriptable) throws JavaScriptException {
        while (n < n2) {
            int n3 = n;
            int n4 = n2;
            int n5 = n3;
            Object object2 = objectArray[n5];
            while (n3 < n4) {
                int n6;
                do {
                    n6 = --n4;
                } while (!(NativeArray.qsortCompare(context, object, objectArray[n4], object2, scriptable) <= 0.0));
                objectArray[n5] = objectArray[n6];
                while (n3 < n4 && NativeArray.qsortCompare(context, object, objectArray[n5], object2, scriptable) <= 0.0) {
                    n5 = ++n3;
                }
                objectArray[n6] = objectArray[n5];
            }
            objectArray[n5] = object2;
            if (n3 - n < n2 - n3) {
                NativeArray.qsort(context, object, objectArray, n, n3 - 1, scriptable);
                n = n3 + 1;
                continue;
            }
            NativeArray.qsort(context, object, objectArray, n3 + 1, n2, scriptable);
            n2 = n3 - 1;
        }
    }

    private static double qsortCompare(Context context, Object object, Object object2, Object object3, Scriptable scriptable) throws JavaScriptException {
        Scriptable scriptable2 = Undefined.instance;
        if (scriptable2 == object2 || scriptable2 == object3) {
            if (scriptable2 != object2) {
                return -1.0;
            }
            if (scriptable2 != object3) {
                return 1.0;
            }
            return 0.0;
        }
        if (object == null) {
            String string = ScriptRuntime.toString(object2);
            String string2 = ScriptRuntime.toString(object3);
            return string.compareTo(string2);
        }
        Object[] objectArray = new Object[]{object2, object3};
        double d = ScriptRuntime.toNumber(ScriptRuntime.call(context, object, null, objectArray, scriptable));
        return d == d ? d : 0.0;
    }

    private static void qsort_extended(Context context, Object object, Scriptable scriptable, long l, long l2) throws JavaScriptException {
        while (l < l2) {
            long l3 = l;
            long l4 = l2;
            long l5 = l3;
            Object object2 = NativeArray.getElem(scriptable, l5);
            while (l3 < l4) {
                long l6;
                do {
                    l6 = --l4;
                } while (!(NativeArray.qsortCompare(context, object, NativeArray.getElem(scriptable, l4), object2, scriptable) <= 0.0));
                NativeArray.setElem(scriptable, l5, NativeArray.getElem(scriptable, l6));
                while (l3 < l4 && NativeArray.qsortCompare(context, object, NativeArray.getElem(scriptable, l5), object2, scriptable) <= 0.0) {
                    l5 = ++l3;
                }
                NativeArray.setElem(scriptable, l6, NativeArray.getElem(scriptable, l5));
            }
            NativeArray.setElem(scriptable, l5, object2);
            if (l3 - l < l2 - l3) {
                NativeArray.qsort_extended(context, object, scriptable, l, l3 - 1L);
                l = l3 + 1L;
                continue;
            }
            NativeArray.qsort_extended(context, object, scriptable, l3 + 1L, l2);
            l2 = l3 - 1L;
        }
    }

    private static void setElem(Scriptable scriptable, long l, Object object) {
        if (l > Integer.MAX_VALUE) {
            String string = Long.toString(l);
            ScriptRuntime.setElem(scriptable, string, object, scriptable);
        } else {
            ScriptRuntime.setElem(scriptable, (int)l, object);
        }
    }

    private static String toStringHelper(Context context, Scriptable scriptable, boolean bl) {
        String string;
        boolean bl2;
        long l = (long)NativeArray.getLengthProperty(scriptable);
        StringBuffer stringBuffer = new StringBuffer();
        if (context.iterating == null) {
            context.iterating = new Hashtable(31);
        }
        boolean bl3 = bl2 = context.iterating.get(scriptable) == Boolean.TRUE;
        if (bl) {
            stringBuffer.append("[");
            string = ", ";
        } else {
            string = ",";
        }
        boolean bl4 = false;
        long l2 = 0L;
        if (!bl2) {
            l2 = 0L;
            while (l2 < l) {
                Object object;
                if (l2 > 0L) {
                    stringBuffer.append(string);
                }
                if ((object = NativeArray.getElem(scriptable, l2)) == null || object == Undefined.instance) {
                    bl4 = false;
                } else {
                    bl4 = true;
                    if (object instanceof String) {
                        if (bl) {
                            stringBuffer.append("\"");
                            stringBuffer.append(ScriptRuntime.escapeString(ScriptRuntime.toString(object)));
                            stringBuffer.append("\"");
                        } else {
                            stringBuffer.append(ScriptRuntime.toString(object));
                        }
                    } else {
                        try {
                            context.iterating.put(scriptable, Boolean.TRUE);
                            stringBuffer.append(ScriptRuntime.toString(object));
                        }
                        finally {
                            Object var13_10 = null;
                            context.iterating.remove(scriptable);
                        }
                    }
                }
                ++l2;
            }
        }
        if (bl) {
            if (!bl4 && l2 > 0L) {
                stringBuffer.append(", ]");
            } else {
                stringBuffer.append("]");
            }
        }
        return stringBuffer.toString();
    }
}

