/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;

public class FunctionObject
extends NativeFunction {
    private static final short VARARGS_METHOD = -1;
    private static final short VARARGS_CTOR = -2;
    private static boolean sawSecurityException;
    static Method[] methodsCache;
    Method method;
    Constructor ctor;
    private Class[] types;
    private short parmsLength;
    private short lengthPropertyValue;
    private boolean hasVoidReturn;
    private boolean isStatic;
    private boolean useDynamicScope;
    static /* synthetic */ Class class$org$mozilla$javascript$Context;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;

    public FunctionObject(String string, Member member, Scriptable scriptable) {
        short s;
        String string2;
        if (member instanceof Constructor) {
            this.ctor = (Constructor)member;
            this.isStatic = true;
            this.types = this.ctor.getParameterTypes();
            string2 = this.ctor.getName();
        } else {
            this.method = (Method)member;
            this.isStatic = Modifier.isStatic(this.method.getModifiers());
            this.types = this.method.getParameterTypes();
            string2 = this.method.getName();
        }
        String[] stringArray = new String[]{string};
        this.names = stringArray;
        if (this.types.length == 4 && (this.types[1].isArray() || this.types[2].isArray())) {
            if (this.types[1].isArray()) {
                if (!this.isStatic || this.types[0] != (class$org$mozilla$javascript$Context != null ? class$org$mozilla$javascript$Context : (class$org$mozilla$javascript$Context = FunctionObject.class$("org.mozilla.javascript.Context"))) || this.types[1].getComponentType() != ScriptRuntime.ObjectClass || this.types[2] != ScriptRuntime.FunctionClass || this.types[3] != Boolean.TYPE) {
                    Object[] objectArray = new String[]{string2};
                    String string3 = Context.getMessage("msg.varargs.ctor", objectArray);
                    throw Context.reportRuntimeError(string3);
                }
                this.parmsLength = (short)-2;
            } else {
                if (!this.isStatic || this.types[0] != (class$org$mozilla$javascript$Context != null ? class$org$mozilla$javascript$Context : (class$org$mozilla$javascript$Context = FunctionObject.class$("org.mozilla.javascript.Context"))) || this.types[1] != ScriptRuntime.ScriptableClass || this.types[2].getComponentType() != ScriptRuntime.ObjectClass || this.types[3] != ScriptRuntime.FunctionClass) {
                    Object[] objectArray = new String[]{string2};
                    String string4 = Context.getMessage("msg.varargs.fun", objectArray);
                    throw Context.reportRuntimeError(string4);
                }
                this.parmsLength = (short)-1;
            }
            s = 1;
        } else {
            this.parmsLength = (short)this.types.length;
            boolean bl = false;
            int n = 0;
            while (n < this.parmsLength) {
                Class clazz = this.types[n];
                if (clazz != ScriptRuntime.ObjectClass) {
                    if (clazz == ScriptRuntime.StringClass || clazz == ScriptRuntime.BooleanClass || ScriptRuntime.NumberClass.isAssignableFrom(clazz) || (class$org$mozilla$javascript$Scriptable != null ? class$org$mozilla$javascript$Scriptable : FunctionObject.class$("org.mozilla.javascript.Scriptable")).isAssignableFrom(clazz)) {
                        bl = true;
                    } else if (clazz == Boolean.TYPE) {
                        bl = true;
                        this.types[n] = ScriptRuntime.BooleanClass;
                    } else if (clazz == Byte.TYPE) {
                        bl = true;
                        this.types[n] = ScriptRuntime.ByteClass;
                    } else if (clazz == Short.TYPE) {
                        bl = true;
                        this.types[n] = ScriptRuntime.ShortClass;
                    } else if (clazz == Integer.TYPE) {
                        bl = true;
                        this.types[n] = ScriptRuntime.IntegerClass;
                    } else if (clazz == Float.TYPE) {
                        bl = true;
                        this.types[n] = ScriptRuntime.FloatClass;
                    } else if (clazz == Double.TYPE) {
                        bl = true;
                        this.types[n] = ScriptRuntime.DoubleClass;
                    } else {
                        Object[] objectArray = new Object[]{string2};
                        throw Context.reportRuntimeError(Context.getMessage("msg.bad.parms", objectArray));
                    }
                }
                ++n;
            }
            if (!bl) {
                this.types = null;
            }
            s = this.parmsLength;
        }
        this.lengthPropertyValue = s;
        this.hasVoidReturn = this.method != null && this.method.getReturnType() == Void.TYPE;
        this.argCount = s;
        this.setParentScope(scriptable);
        this.setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
        Context context = Context.getCurrentContext();
        this.useDynamicScope = context != null && context.hasCompileFunctionsWithDynamicScope();
    }

    public void addAsConstructor(Scriptable scriptable, Scriptable scriptable2) {
        this.setParentScope(scriptable);
        this.setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
        scriptable2.setParentScope(this);
        int n = 7;
        this.defineProperty("prototype", scriptable2, 7);
        String string = scriptable2.getClassName();
        if (!string.equals("With")) {
            if (scriptable2 instanceof ScriptableObject) {
                ((ScriptableObject)scriptable2).defineProperty("constructor", this, 7);
            } else {
                scriptable2.put("constructor", scriptable2, (Object)this);
            }
        }
        if (scriptable instanceof ScriptableObject) {
            ((ScriptableObject)scriptable).defineProperty(string, this, 2);
        } else {
            scriptable.put(string, scriptable, (Object)this);
        }
        this.setParentScope(scriptable);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        Object object;
        short s;
        Object[] objectArray2;
        if (this.parmsLength < 0) {
            return this.callVarargs(context, scriptable2, objectArray, false);
        }
        if (!this.isStatic) {
            objectArray2 = this.method != null ? this.method.getDeclaringClass() : this.ctor.getDeclaringClass();
            while (!objectArray2.isInstance(scriptable2)) {
                if ((scriptable2 = scriptable2.getPrototype()) != null && this.useDynamicScope) continue;
                Object[] objectArray3 = new Object[]{this.names[0]};
                String string = Context.getMessage("msg.incompat.call", objectArray3);
                throw NativeGlobal.constructError(context, "TypeError", string, scriptable);
            }
        }
        if (this.parmsLength == objectArray.length) {
            objectArray2 = objectArray;
            s = this.types == null ? this.parmsLength : (short)0;
        } else {
            objectArray2 = new Object[this.parmsLength];
            s = 0;
        }
        while (s < this.parmsLength) {
            Object object2 = object = s < objectArray.length ? objectArray[s] : Undefined.instance;
            if (this.types != null) {
                object = FunctionObject.convertArg(this, object, this.types[s]);
            }
            objectArray2[s] = object;
            s = (short)(s + 1);
        }
        try {
            object = this.method != null ? this.method.invoke((Object)scriptable2, objectArray2) : this.ctor.newInstance(objectArray2);
            return this.hasVoidReturn ? Undefined.instance : object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JavaScriptException.wrapException(scriptable, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw WrappedException.wrapException(instantiationException);
        }
    }

    private Object callVarargs(Context context, Scriptable scriptable, Object[] objectArray, boolean bl) throws JavaScriptException {
        try {
            if (this.parmsLength == -1) {
                Object[] objectArray2 = new Object[]{context, scriptable, objectArray, this};
                Object object = this.method.invoke(null, objectArray2);
                return this.hasVoidReturn ? Undefined.instance : object;
            }
            Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
            Object[] objectArray3 = new Object[]{context, objectArray, this, bl2};
            return this.method == null ? this.ctor.newInstance(objectArray3) : this.method.invoke(null, objectArray3);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof EvaluatorException) {
                throw (EvaluatorException)throwable;
            }
            if (throwable instanceof EcmaError) {
                throw (EcmaError)throwable;
            }
            Scriptable scriptable2 = scriptable == null ? this : scriptable;
            throw JavaScriptException.wrapException(scriptable2, throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw WrappedException.wrapException(instantiationException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        if (this.method == null || this.parmsLength == -2) {
            Scriptable scriptable2;
            Scriptable scriptable3;
            if (this.method != null) {
                context.ctorScope = scriptable;
                scriptable3 = (Scriptable)this.callVarargs(context, null, objectArray, true);
                context.ctorScope = null;
            } else {
                scriptable3 = (Scriptable)this.call(context, scriptable, null, objectArray);
            }
            if (scriptable3.getPrototype() == null) {
                scriptable3.setPrototype(this.getClassPrototype());
            }
            if (scriptable3.getParentScope() == null && scriptable3 != (scriptable2 = this.getParentScope())) {
                scriptable3.setParentScope(scriptable2);
            }
            return scriptable3;
        }
        if (this.method != null && !this.isStatic) {
            Scriptable scriptable4;
            try {
                scriptable4 = (Scriptable)this.method.getDeclaringClass().newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw WrappedException.wrapException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw WrappedException.wrapException(instantiationException);
            }
            scriptable4.setPrototype(this.getClassPrototype());
            scriptable4.setParentScope(this.getParentScope());
            Object object = this.call(context, scriptable, scriptable4, objectArray);
            if (object != null && object != Undefined.instance && object instanceof Scriptable) {
                return (Scriptable)object;
            }
            return scriptable4;
        }
        return super.construct(context, scriptable, objectArray);
    }

    public static Object convertArg(Scriptable scriptable, Object object, Class clazz) {
        if (clazz == ScriptRuntime.BooleanClass || clazz == Boolean.TYPE) {
            return ScriptRuntime.toBoolean(object) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (clazz == ScriptRuntime.StringClass) {
            return ScriptRuntime.toString(object);
        }
        if (clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE) {
            return new Integer(ScriptRuntime.toInt32(object));
        }
        if (clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
            return new Double(ScriptRuntime.toNumber(object));
        }
        if (clazz == ScriptRuntime.ScriptableClass) {
            return ScriptRuntime.toObject(scriptable, object);
        }
        if (clazz == ScriptRuntime.ObjectClass) {
            return object;
        }
        Object[] objectArray = new Object[]{clazz.getName()};
        throw Context.reportRuntimeError(Context.getMessage("msg.cant.convert", objectArray));
    }

    public static Method[] findMethods(Class clazz, String string) {
        return FunctionObject.findMethods(FunctionObject.getMethodList(clazz), string);
    }

    static Method[] findMethods(Method[] methodArray, String string) {
        Vector<Method> vector = null;
        Method method = null;
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n] != null && methodArray[n].getName().equals(string)) {
                if (method == null) {
                    method = methodArray[n];
                } else {
                    if (vector == null) {
                        vector = new Vector<Method>(5);
                        vector.addElement(method);
                    }
                    vector.addElement(methodArray[n]);
                }
            }
            ++n;
        }
        if (vector == null) {
            if (method == null) {
                return null;
            }
            Method[] methodArray2 = new Method[]{method};
            return methodArray2;
        }
        Object[] objectArray = new Method[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object get(String string, Scriptable scriptable) {
        if (string.equals("length")) {
            return new Integer(this.lengthPropertyValue);
        }
        return super.get(string, scriptable);
    }

    /*
     * Unable to fully structure code
     */
    static Method[] getMethodList(Class var0) {
        var1_1 = FunctionObject.methodsCache;
        if (var1_1 != null && var1_1[0].getDeclaringClass() == var0) {
            return var1_1;
        }
        var2_2 = null;
        try {
            if (!FunctionObject.sawSecurityException) {
                var2_2 = var0.getDeclaredMethods();
            }
        }
        catch (SecurityException v0) {
            FunctionObject.sawSecurityException = true;
        }
        if (var2_2 == null) {
            var2_2 = var0.getMethods();
        }
        var3_3 = 0;
        var4_4 = 0;
        while (var4_4 < var2_2.length) {
            block12: {
                block11: {
                    if (!FunctionObject.sawSecurityException) break block11;
                    if (var2_2[var4_4].getDeclaringClass() != var0) ** GOTO lbl-1000
                    v1 = false;
                    break block12;
                }
                v1 = Modifier.isPublic(var2_2[var4_4].getModifiers()) ^ true;
            }
            if (v1) lbl-1000:
            // 2 sources

            {
                var2_2[var4_4] = null;
            } else {
                ++var3_3;
            }
            ++var4_4;
        }
        var5_5 = new Method[var3_3];
        var6_6 = 0;
        var7_7 = 0;
        while (var7_7 < var2_2.length) {
            if (var2_2[var7_7] != null) {
                var5_5[var6_6++] = var2_2[var7_7];
            }
            ++var7_7;
        }
        if (var5_5.length > 0 && Context.isCachingEnabled) {
            FunctionObject.methodsCache = var5_5;
        }
        return var5_5;
    }

    public boolean has(String string, Scriptable scriptable) {
        return string.equals("length") || super.has(string, scriptable);
    }

    boolean isVarArgsConstructor() {
        return this.parmsLength == -2;
    }

    boolean isVarArgsMethod() {
        return this.parmsLength == -1;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (!string.equals("length")) {
            super.put(string, scriptable, object);
        }
    }

    public void setLength(short s) {
        this.lengthPropertyValue = s;
    }
}

