/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.DriverManager;

public class ConnectionDialog
extends Dialog
implements ActionListener,
ItemListener {
    static final String[][] sJDBCTypes = new String[][]{{"HSQL Database Engine In-Memory", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:."}, {"HSQL Database Engine Standalone", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:test"}, {"HSQL Database Engine Server", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:hsql://localhost"}, {"HSQL Database Engine WebServer", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:http://localhost"}, {"JDBC-ODBC Brigde from Sun", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:test"}, {"Oracle", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci8:@"}, {"IBM DB2", "COM.ibm.db2.jdbc.app.DB2Driver", "jdbc:db2:test"}, {"Cloudscape RMI", "RmiJdbc.RJDriver", "jdbc:rmi://localhost:1099/jdbc:cloudscape:test;create=true"}, {"InstantDb", "jdbc.idbDriver", "jdbc:idb:sample.prp"}, {"PointBase", "com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase://localhost/sample"}};
    Connection mConnection;
    TextField mDriver;
    TextField mURL;
    TextField mUser;
    TextField mPassword;
    Label mError;

    ConnectionDialog(Frame frame, String string) {
        super(frame, string, true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ConnectOk")) {
            try {
                this.mConnection = ConnectionDialog.createConnection(this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), this.mPassword.getText());
                this.dispose();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.mError.setText(exception.toString());
            }
        } else if (string.equals("ConnectCancel")) {
            this.dispose();
        }
    }

    void create() {
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(new GridLayout(6, 2, 10, 10));
        panel.setBackground(SystemColor.control);
        panel.add(ConnectionDialog.createLabel("Type:"));
        Choice choice = new Choice();
        choice.addItemListener(this);
        int n = 0;
        while (n < sJDBCTypes.length) {
            choice.add(sJDBCTypes[n][0]);
            ++n;
        }
        panel.add(choice);
        panel.add(ConnectionDialog.createLabel("Driver:"));
        this.mDriver = new TextField("org.hsqldb.jdbcDriver");
        panel.add(this.mDriver);
        panel.add(ConnectionDialog.createLabel("URL:"));
        this.mURL = new TextField("jdbc:hsqldb:.");
        panel.add(this.mURL);
        panel.add(ConnectionDialog.createLabel("User:"));
        this.mUser = new TextField("sa");
        panel.add(this.mUser);
        panel.add(ConnectionDialog.createLabel("Password:"));
        this.mPassword = new TextField("");
        this.mPassword.setEchoChar('*');
        panel.add(this.mPassword);
        Button button = new Button("Ok");
        button.setActionCommand("ConnectOk");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Cancel");
        button.setActionCommand("ConnectCancel");
        button.addActionListener(this);
        panel.add(button);
        this.setLayout(new BorderLayout());
        this.add("East", ConnectionDialog.createLabel(""));
        this.add("West", ConnectionDialog.createLabel(""));
        this.mError = new Label("");
        Panel panel2 = ConnectionDialog.createBorderPanel(this.mError);
        this.add("South", panel2);
        this.add("North", ConnectionDialog.createLabel(""));
        this.add("Center", panel);
        this.doLayout();
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        ((Component)this).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.show();
    }

    public static Panel createBorderPanel(Component component) {
        Panel panel = new Panel();
        panel.setBackground(SystemColor.control);
        panel.setLayout(new BorderLayout());
        panel.add("Center", component);
        panel.add("North", ConnectionDialog.createLabel(""));
        panel.add("South", ConnectionDialog.createLabel(""));
        panel.add("East", ConnectionDialog.createLabel(""));
        panel.add("West", ConnectionDialog.createLabel(""));
        panel.setBackground(SystemColor.control);
        return panel;
    }

    public static Connection createConnection(Frame frame, String string) {
        ConnectionDialog connectionDialog = new ConnectionDialog(frame, string);
        connectionDialog.create();
        return connectionDialog.mConnection;
    }

    public static Connection createConnection(String string, String string2, String string3, String string4) throws Exception {
        Class.forName(string).newInstance();
        return DriverManager.getConnection(string2, string3, string4);
    }

    public static Label createLabel(String string) {
        Label label = new Label(string);
        label.setBackground(SystemColor.control);
        return label;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        int n = 0;
        while (n < sJDBCTypes.length) {
            if (string.equals(sJDBCTypes[n][0])) {
                this.mDriver.setText(sJDBCTypes[n][1]);
                this.mURL.setText(sJDBCTypes[n][2]);
            }
            ++n;
        }
    }

    void trace(String string) {
        this.mError.setText(string);
        System.out.println(string);
    }
}

