/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.thread;

import org.apache.avalon.Loggable;
import org.apache.avalon.Poolable;
import org.apache.excalibur.pool.SoftResourceLimitingPool;
import org.apache.excalibur.thread.ThreadContext;
import org.apache.excalibur.thread.ThreadPool;
import org.apache.log.Logger;

class WorkerThread
extends Thread
implements Poolable,
Loggable {
    protected static final boolean DEBUG = false;
    protected Logger m_logger;
    protected ThreadPool m_threadPool;
    protected SoftResourceLimitingPool m_pool;
    protected Runnable m_work;
    protected boolean m_alive;

    public void setLogger(Logger logger) {
        this.m_logger = logger;
    }

    public final synchronized void run() {
        ThreadContext.setCurrentThreadPool(this.m_threadPool);
        while (this.m_alive) {
            this.waitUntilCondition(true);
            try {
                this.m_work.run();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.m_work = null;
            this.notify();
            if (this.m_pool != null) {
                this.m_pool.put(this);
                continue;
            }
            this.m_alive = false;
        }
    }

    protected synchronized void executeAndWait(Runnable runnable) {
        this.execute(runnable);
        this.waitUntilCondition(false);
    }

    protected synchronized void waitUntilCondition(boolean bl) {
        while (bl == (this.m_work == null)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected synchronized void execute(Runnable runnable) {
        this.m_work = runnable;
        this.notify();
    }

    public void dispose() {
        this.m_alive = false;
    }

    protected WorkerThread(ThreadGroup threadGroup, ThreadPool threadPool, SoftResourceLimitingPool softResourceLimitingPool, String string) {
        super(threadGroup, string);
        this.m_threadPool = threadPool;
        this.m_pool = softResourceLimitingPool;
        this.m_work = null;
        this.m_alive = true;
        this.setDaemon(false);
    }
}

