/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.avalon.util.CircularDependencyException;

public class DependencyGraph {
    protected final HashMap m_map = new HashMap();
    protected boolean m_allowCircularity = true;

    public void setAllowCircularity(boolean bl) {
        this.m_allowCircularity = bl;
    }

    public void add(String string, String[] stringArray) {
        this.m_map.put(string, new GraphNode(string, stringArray));
    }

    public void remove(String string) {
        this.m_map.remove(string);
    }

    public Dependency[] getDependencyList(String string) throws CircularDependencyException {
        ArrayList<Dependency> arrayList = new ArrayList<Dependency>();
        Dependency dependency = new Dependency(string, null);
        arrayList.add(dependency);
        if (this.m_map.get(string) != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(string);
            this.buildDependencyList(string, arrayList, new ArrayList(), arrayList2);
        }
        return arrayList.toArray(new Dependency[0]);
    }

    protected void buildDependencyList(String string, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) throws CircularDependencyException {
        if (arrayList2.contains(string)) {
            return;
        }
        arrayList2.add(string);
        GraphNode graphNode = (GraphNode)this.m_map.get(string);
        if (graphNode == null) {
            return;
        }
        String[] stringArray = graphNode.getDependencies();
        int n = 0;
        while (n < stringArray.length) {
            if (arrayList3.contains(stringArray[n])) {
                if (!this.m_allowCircularity) {
                    throw new CircularDependencyException(stringArray[n], string, arrayList3);
                }
            } else if (!arrayList2.contains(stringArray[n])) {
                Dependency dependency = new Dependency(stringArray[n], string);
                arrayList.add(dependency);
                arrayList3.add(stringArray[n]);
                this.buildDependencyList(stringArray[n], arrayList, arrayList2, arrayList3);
                arrayList3.remove(arrayList3.size() - 1);
            }
            ++n;
        }
    }

    public static final class Dependency {
        protected final String m_name;
        protected final String m_requiredBy;

        public String getName() {
            return this.m_name;
        }

        public String getRequiredBy() {
            return this.m_requiredBy;
        }

        public String toString() {
            return this.getName();
        }

        protected Dependency(String string, String string2) {
            this.m_name = string;
            this.m_requiredBy = string2;
        }
    }

    protected static final class GraphNode {
        protected final String m_name;
        protected final String[] m_dependencies;

        public String getName() {
            return this.m_name;
        }

        public String[] getDependencies() {
            return this.m_dependencies;
        }

        protected GraphNode(String string, String[] stringArray) {
            this.m_name = string;
            this.m_dependencies = stringArray;
        }
    }
}

