/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.Component;
import org.apache.avalon.ComponentManager;
import org.apache.avalon.ComponentManagerException;
import org.apache.avalon.ComponentSelector;
import org.apache.avalon.Composer;
import org.apache.avalon.Context;
import org.apache.avalon.Contextualizable;
import org.apache.avalon.Disposable;
import org.apache.avalon.ThreadSafe;
import org.apache.avalon.component.ComponentException;
import org.apache.avalon.component.DefaultComponentHandler;
import org.apache.avalon.component.RoleManager;
import org.apache.avalon.configuration.Configurable;
import org.apache.avalon.configuration.Configuration;
import org.apache.avalon.configuration.ConfigurationException;

public class DefaultComponentSelector
extends AbstractLoggable
implements Contextualizable,
ComponentSelector,
Composer,
Configurable,
ThreadSafe,
Disposable {
    private static final String DEFAULT_NAME = "UnnamedSelector";
    private String m_rolename;
    protected Context m_context;
    private ComponentManager m_componentManager;
    private Map m_componentMapping;
    private Configuration m_configuration;
    private Map m_componentHandlers = Collections.synchronizedMap(new HashMap());
    private boolean m_disposed;
    private Map m_hints;
    private RoleManager m_roles;

    public void contextualize(Context context) {
        if (this.m_context == null) {
            this.m_context = context;
        }
    }

    public void compose(ComponentManager componentManager) throws ComponentManagerException {
        if (this.m_componentManager == null) {
            this.m_componentManager = componentManager;
        }
    }

    public synchronized void dispose() {
        this.m_disposed = true;
        Iterator<Object> iterator = this.m_componentHandlers.keySet().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            DefaultComponentHandler defaultComponentHandler = (DefaultComponentHandler)this.m_componentHandlers.get(k);
            defaultComponentHandler.dispose();
            arrayList.add(k);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.m_componentHandlers.remove(iterator.next());
        }
        arrayList.clear();
    }

    public Component select(Object object) throws ComponentException {
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot select a Component from a disposed ComponentSelector");
        }
        if (object == null) {
            String string = this.getName() + ": ComponentSelector Attempted to retrieve component with null hint.";
            this.getLogger().error(string);
            throw new ComponentException(string);
        }
        DefaultComponentHandler defaultComponentHandler = (DefaultComponentHandler)this.m_componentHandlers.get(object);
        if (defaultComponentHandler == null) {
            String string = this.getName() + ": ComponentSelector could not find the component for hint: " + object;
            throw new ComponentException(string);
        }
        Component component = null;
        try {
            component = defaultComponentHandler.get();
        }
        catch (Exception exception) {
            String string = this.getName() + ": ComponentSelector could not access the Component for hint: " + object;
            throw new ComponentException(string, exception);
        }
        if (component == null) {
            String string = this.getName() + ": ComponentSelector could not find the component for hint: " + object;
            throw new ComponentException(string);
        }
        this.m_componentMapping.put(component, defaultComponentHandler);
        return component;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_configuration = configuration;
        this.getLogger().debug("ComponentSelector setting up with root element: " + this.m_configuration.getName());
        String string = configuration.getName();
        this.m_rolename = string.equals("component") ? this.m_configuration.getAttribute("role") : this.m_roles.getRoleForName(string);
        Configuration[] configurationArray = this.m_configuration.getChildren();
        int n = 0;
        while (n < configurationArray.length) {
            String string2 = configurationArray[n].getAttribute("name").trim();
            String string3 = "component-instance".equals(configurationArray[n].getName()) ? configurationArray[n].getAttribute("class").trim() : this.m_roles.getDefaultClassNameForHint(this.m_rolename, configurationArray[n].getName());
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(string3);
                this.addComponent(string2, clazz, configurationArray[n]);
            }
            catch (Exception exception) {
                String string4 = "The component instance for '" + string2 + "' has an invalid class name.";
                this.getLogger().error(string4, (Throwable)exception);
                throw new ConfigurationException(string4, exception);
            }
            ++n;
        }
    }

    public void setRoleManager(RoleManager roleManager) {
        if (this.m_roles == null) {
            this.m_roles = roleManager;
        }
    }

    public void release(Component component) {
        if (component == null) {
            return;
        }
        DefaultComponentHandler defaultComponentHandler = (DefaultComponentHandler)this.m_componentMapping.get(component);
        if (defaultComponentHandler == null) {
            return;
        }
        defaultComponentHandler.put(component);
        this.m_componentMapping.remove(component);
    }

    public void addComponent(Object object, Class clazz, Configuration configuration) throws ComponentException {
        try {
            DefaultComponentHandler defaultComponentHandler = new DefaultComponentHandler(clazz, configuration, this.m_componentManager, this.m_context, this.m_roles);
            defaultComponentHandler.setLogger(this.getLogger());
            defaultComponentHandler.init();
            this.m_componentHandlers.put(object, defaultComponentHandler);
            this.getLogger().debug("Adding " + clazz.getName() + " for " + object.toString());
        }
        catch (Exception exception) {
            String string = "Could not set up Component for hint: " + object;
            this.getLogger().error(string, (Throwable)exception);
            throw new ComponentException(string, exception);
        }
    }

    public void addComponentInstance(String string, Object object) {
        try {
            DefaultComponentHandler defaultComponentHandler = new DefaultComponentHandler((Component)object);
            defaultComponentHandler.setLogger(this.getLogger());
            defaultComponentHandler.init();
            this.m_componentHandlers.put(string, defaultComponentHandler);
            this.getLogger().debug("Adding " + object.getClass().getName() + " for " + string.toString());
        }
        catch (Exception exception) {
            this.getLogger().error("Could not set up Component for hint: " + string, (Throwable)exception);
        }
    }

    private String getName() {
        if (this.m_configuration != null && !this.m_configuration.getName().equals("")) {
            return this.m_configuration.getName();
        }
        return DEFAULT_NAME;
    }

    public DefaultComponentSelector() {
        this.m_componentMapping = Collections.synchronizedMap(new HashMap());
    }
}

