/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.camelot;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.Component;
import org.apache.avalon.camelot.Deployer;
import org.apache.avalon.camelot.DeploymentException;
import org.apache.excalibur.io.FileUtil;

public abstract class AbstractDeployer
extends AbstractLoggable
implements Deployer {
    protected final HashMap m_deployments = new HashMap();
    protected boolean m_autoUndeploy;
    protected String m_type;

    public void deploy(String string, URL uRL) throws DeploymentException {
        this.checkDeployment(string, uRL);
        File file = this.getFileFor(uRL);
        this.getLogger().info("Deploying " + this.m_type + " file (" + file + ") as " + string);
        this.deployFromFile(string, file);
    }

    protected void checkDeployment(String string, URL uRL) throws DeploymentException {
        if (this.m_deployments.get(string) != null) {
            throw new DeploymentException(this.m_type + " already exists at " + string);
        }
        if (!this.isValidLocation(string)) {
            throw new DeploymentException("Invalid location (" + string + ") for " + this.m_type);
        }
    }

    public void undeploy(String string) throws DeploymentException {
        Component component = (Component)this.m_deployments.get(string);
        if (component == null) {
            throw new DeploymentException(this.m_type + " does not exist at " + string);
        }
        boolean bl = this.canUndeploy(component);
        if (!bl) {
            if (!this.m_autoUndeploy) {
                throw new DeploymentException(this.m_type + " not ready to undeploy at " + string);
            }
            this.shutdownDeployment(component);
        }
        this.m_deployments.remove(string);
    }

    protected File getCacheLocationFor(URL uRL) throws DeploymentException {
        throw new DeploymentException("Unable to deploy non-local resources");
    }

    protected File getFileFor(URL uRL) throws DeploymentException {
        File file = null;
        if (uRL.getProtocol().equals("file")) {
            file = new File(uRL.getFile());
        } else {
            file = this.getCacheLocationFor(uRL);
            try {
                FileUtil.copyURLToFile(uRL, file);
            }
            catch (IOException iOException) {
                throw new DeploymentException("Failed attempting to copy from  " + uRL + " to local file cache " + file, iOException);
            }
        }
        file = file.getAbsoluteFile();
        if (!file.exists()) {
            throw new DeploymentException("Could not find application archive at " + file);
        }
        if (file.isDirectory()) {
            throw new DeploymentException("Could not find application archive at " + file + " as it is a directory.");
        }
        return file;
    }

    protected boolean isValidLocation(String string) {
        return true;
    }

    protected boolean canUndeploy(Component component) throws DeploymentException {
        return true;
    }

    protected void shutdownDeployment(Component component) throws DeploymentException {
    }

    protected abstract void deployFromFile(String var1, File var2) throws DeploymentException;
}

