/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.BasicStroke;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.GraphicContext;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGStrokeDescriptor;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGBasicStroke
extends AbstractSVGConverter {
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        if (graphicContext.getStroke() instanceof BasicStroke) {
            return SVGBasicStroke.toSVG((BasicStroke)graphicContext.getStroke());
        }
        return null;
    }

    public static SVGStrokeDescriptor toSVG(BasicStroke basicStroke) {
        String string = AbstractSVGConverter.doubleString(basicStroke.getLineWidth());
        String string2 = SVGBasicStroke.endCapToSVG(basicStroke.getEndCap());
        String string3 = SVGBasicStroke.joinToSVG(basicStroke.getLineJoin());
        String string4 = AbstractSVGConverter.doubleString(basicStroke.getMiterLimit());
        float[] fArray = basicStroke.getDashArray();
        String string5 = null;
        string5 = fArray != null ? SVGBasicStroke.dashArrayToSVG(fArray) : "none";
        String string6 = AbstractSVGConverter.doubleString(basicStroke.getDashPhase());
        return new SVGStrokeDescriptor(string, string2, string3, string4, string5, string6);
    }

    private static String dashArrayToSVG(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (fArray.length > 0) {
            stringBuffer.append(AbstractSVGConverter.doubleString(fArray[0]));
        }
        int n = 1;
        while (n < fArray.length) {
            stringBuffer.append(" ");
            stringBuffer.append(AbstractSVGConverter.doubleString(fArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String joinToSVG(int n) {
        switch (n) {
            case 2: {
                return "bevel";
            }
            case 1: {
                return "round";
            }
        }
        return "miter";
    }

    private static String endCapToSVG(int n) {
        switch (n) {
            case 0: {
                return "butt";
            }
            case 1: {
                return "round";
            }
        }
        return "square";
    }

    public static void main(String[] stringArray) throws Exception {
        Document document = TestUtil.getDocumentPrototype();
        BasicStroke[] basicStrokeArray = new BasicStroke[]{new BasicStroke(), new BasicStroke(2.0f), new BasicStroke(4.5f), new BasicStroke(10.0f, 0, 0), new BasicStroke(10.0f, 2, 0), new BasicStroke(10.0f, 1, 0), new BasicStroke(10.0f, 0, 2), new BasicStroke(10.0f, 0, 1), new BasicStroke(50.0f, 1, 0, 100.0f), new BasicStroke(75.0f, 1, 1, 50.0f, new float[]{1.0f, 2.0f, 3.0f, 4.0f}, 0.5f), new BasicStroke(75.0f, 1, 1, 60.0f, new float[]{10.1f, 2.4f, 3.5f, 4.2f}, 10.0f)};
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n = 0;
        while (n < basicStrokeArray.length) {
            BasicStroke basicStroke = basicStrokeArray[n];
            Map map = SVGBasicStroke.toSVG(basicStroke).getAttributeMap(null);
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                element2.setAttributeNS(null, string, string2);
            }
            element.appendChild(element2);
            ++n;
        }
        TestUtil.trace(element, System.out);
    }
}

