/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.parser.DefaultErrorHandler;
import org.apache.batik.parser.ErrorHandler;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.Parser;
import org.apache.batik.util.InputBuffer;

public abstract class AbstractParser
implements Parser {
    public static final String BUNDLE_CLASSNAME = "org.apache.batik.parser.resources.Messages";
    protected ErrorHandler errorHandler = new DefaultErrorHandler();
    protected LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.parser.resources.Messages");
    protected InputBuffer inputBuffer;
    protected int current;

    public int getCurrent() {
        return this.current;
    }

    public void setLocale(Locale locale) {
        this.localizableSupport.setLocale(locale);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        return this.localizableSupport.formatMessage(string, objectArray);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected void initialize(Reader reader) {
        try {
            this.inputBuffer = new InputBuffer(reader);
        }
        catch (IOException iOException) {
            this.errorHandler.error(new ParseException(this.createErrorMessage("io.exception", null), iOException));
        }
    }

    protected void read() {
        try {
            this.current = this.inputBuffer.current();
            this.inputBuffer.next();
        }
        catch (IOException iOException) {
            this.errorHandler.error(new ParseException(this.createErrorMessage("io.exception", null), iOException));
        }
    }

    protected void reportError(String string, Object[] objectArray) throws ParseException {
        this.errorHandler.error(new ParseException(this.createErrorMessage(string, objectArray), this.inputBuffer.getLine(), this.inputBuffer.getColumn()));
    }

    protected String createErrorMessage(String string, Object[] objectArray) {
        try {
            return this.formatMessage(string, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    protected String getBundleClassName() {
        return BUNDLE_CLASSNAME;
    }

    protected void skipSpaces() {
        while (true) {
            switch (this.current) {
                default: {
                    return;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
            }
            this.read();
        }
    }

    protected void skipCommaSpaces() {
        block6: while (true) {
            switch (this.current) {
                default: {
                    break block6;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.read();
                    continue block6;
                }
            }
            break;
        }
        if (this.current == 44) {
            block7: while (true) {
                this.read();
                switch (this.current) {
                    default: {
                        break block7;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        continue block7;
                    }
                }
                break;
            }
        }
    }

    public abstract void parse(Reader var1) throws ParseException;
}

