/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.ShapePainter;

public class CompositeShapePainter
implements ShapePainter {
    protected Shape shape;
    protected ShapePainter[] painters;
    protected int count;

    public CompositeShapePainter(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
    }

    public void addShapePainter(ShapePainter shapePainter) {
        if (shapePainter == null) {
            return;
        }
        if (this.shape != shapePainter.getShape()) {
            shapePainter.setShape(this.shape);
        }
        if (this.painters == null) {
            this.painters = new ShapePainter[2];
        }
        if (this.count == this.painters.length) {
            ShapePainter[] shapePainterArray = new ShapePainter[this.count * 3 / 2 + 1];
            System.arraycopy(this.painters, 0, shapePainterArray, 0, this.count);
            this.painters = shapePainterArray;
        }
        this.painters[this.count++] = shapePainter;
    }

    public void paint(Graphics2D graphics2D, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        if (this.painters != null) {
            int n = 0;
            while (n < this.count) {
                this.painters[n].paint(graphics2D, graphicsNodeRenderContext);
                ++n;
            }
        }
    }

    public Shape getPaintedArea(GraphicsNodeRenderContext graphicsNodeRenderContext) {
        GeneralPath generalPath = new GeneralPath();
        if (this.painters != null) {
            int n = 0;
            while (n < this.count) {
                generalPath.append(this.painters[n].getPaintedArea(graphicsNodeRenderContext), false);
                ++n;
            }
        }
        return generalPath;
    }

    public void setShape(Shape shape) {
        if (this.painters != null) {
            int n = 0;
            while (n < this.count) {
                this.painters[n].setShape(shape);
                ++n;
            }
        }
        this.shape = shape;
    }

    public Shape getShape() {
        return this.shape;
    }
}

