/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Point;
import java.awt.image.Raster;
import java.util.HashMap;
import org.apache.batik.ext.awt.image.rendered.LRUCache;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileLRUMember;
import org.apache.batik.ext.awt.image.rendered.TileStore;

public class TileMap
implements TileStore {
    private static final boolean DEBUG = false;
    private static final boolean COUNT = false;
    private HashMap rasters = new HashMap();
    private TileGenerator source = null;
    private LRUCache cache = null;
    static int requests;
    static int misses;
    static /* synthetic */ Class class$org$apache$batik$ext$awt$image$rendered$TileMap;

    public TileMap(TileGenerator tileGenerator, LRUCache lRUCache) {
        this.cache = lRUCache;
        this.source = tileGenerator;
    }

    public void setTile(int n, int n2, Raster raster) {
        TileLRUMember tileLRUMember;
        Point point = new Point(n, n2);
        Object v = this.rasters.get(point);
        if (v == null) {
            tileLRUMember = new TileLRUMember(raster);
        } else {
            tileLRUMember = (TileLRUMember)v;
            tileLRUMember.setRaster(raster);
        }
        if (tileLRUMember.lruGet() != null) {
            this.cache.touch(tileLRUMember);
        } else {
            this.cache.add(tileLRUMember);
        }
    }

    public Raster getTileNoCompute(int n, int n2) {
        Point point = new Point(n, n2);
        Object v = this.rasters.get(point);
        if (v == null) {
            return null;
        }
        TileLRUMember tileLRUMember = (TileLRUMember)v;
        return tileLRUMember.retrieveRaster();
    }

    public Raster getTile(int n, int n2) {
        TileLRUMember tileLRUMember;
        Raster raster = null;
        Point point = new Point(n, n2);
        Object v = this.rasters.get(point);
        if (v == null) {
            tileLRUMember = new TileLRUMember();
            this.rasters.put(point, tileLRUMember);
        } else {
            tileLRUMember = (TileLRUMember)v;
            raster = tileLRUMember.retrieveRaster();
        }
        if (raster == null) {
            raster = this.source.genTile(n, n2);
            tileLRUMember.setRaster(raster);
        }
        this.cache.add(tileLRUMember);
        return raster;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

