/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

public class LRUCache {
    private LRUList free = null;
    private LRUList used = null;
    private int maxSize = 0;

    public LRUCache(int n) {
        if (n <= 0) {
            n = 1;
        }
        this.maxSize = n;
        this.free = new LRUList();
        this.used = new LRUList();
        while (n > 0) {
            this.free.add(new LRUNode());
            --n;
        }
    }

    public int getUsed() {
        return this.used.getSize();
    }

    public void setSize(int n) {
        if (this.maxSize < n) {
            int n2 = this.maxSize;
            while (n2 < n) {
                this.free.add(new LRUNode());
                ++n2;
            }
        } else if (this.maxSize > n) {
            int n3 = this.used.getSize();
            while (n3 > n) {
                LRUNode lRUNode = this.used.getTail();
                this.used.remove(lRUNode);
                lRUNode.setObj(null);
                --n3;
            }
        }
        this.maxSize = n;
    }

    public void flush() {
        while (this.used.getSize() > 0) {
            LRUNode lRUNode = this.used.pop();
            lRUNode.setObj(null);
            this.free.add(lRUNode);
        }
    }

    public void remove(LRUObj lRUObj) {
        LRUNode lRUNode = lRUObj.lruGet();
        if (lRUNode == null) {
            return;
        }
        this.used.remove(lRUNode);
        lRUNode.setObj(null);
        this.free.add(lRUNode);
    }

    public void touch(LRUObj lRUObj) {
        LRUNode lRUNode = lRUObj.lruGet();
        if (lRUNode == null) {
            return;
        }
        this.used.touch(lRUNode);
    }

    public void add(LRUObj lRUObj) {
        LRUNode lRUNode = lRUObj.lruGet();
        if (lRUNode != null) {
            this.used.touch(lRUNode);
            return;
        }
        if (this.free.getSize() > 0) {
            lRUNode = this.free.pop();
            lRUNode.setObj(lRUObj);
            this.used.add(lRUNode);
        } else {
            lRUNode = this.used.getTail();
            lRUNode.setObj(lRUObj);
            this.used.touch(lRUNode);
        }
    }

    protected void print() {
        System.out.println("In Use: " + this.used.getSize() + " Free: " + this.free.getSize());
        LRUNode lRUNode = this.used.getHead();
        do {
            System.out.println(lRUNode.getObj());
        } while ((lRUNode = lRUNode.getNext()) != this.used.getHead());
    }

    public class LRUList {
        private LRUNode head = null;
        private int size = 0;

        public synchronized int getSize() {
            return this.size;
        }

        public synchronized void empty() {
            while (this.size > 0) {
                this.pop();
            }
        }

        public LRUNode getHead() {
            return this.head;
        }

        public LRUNode getTail() {
            return this.head.getPrev();
        }

        public synchronized void touch(LRUNode lRUNode) {
            if (lRUNode == null) {
                return;
            }
            lRUNode.insertBefore(this.head);
            this.head = lRUNode;
        }

        public synchronized void add(LRUNode lRUNode) {
            this.touch(lRUNode);
            ++this.size;
        }

        public synchronized void remove(LRUNode lRUNode) {
            if (lRUNode == null) {
                return;
            }
            if (lRUNode == this.head) {
                this.head = lRUNode.getNext();
            }
            lRUNode.unlink();
            --this.size;
        }

        public synchronized LRUNode pop() {
            if (this.head == null) {
                return null;
            }
            LRUNode lRUNode = this.head;
            this.head = this.head.getNext() == this.head ? null : this.head.getNext();
            lRUNode.unlink();
            --this.size;
            return lRUNode;
        }
    }

    public class LRUNode {
        private LRUNode next = null;
        private LRUNode prev = null;
        private LRUObj obj = null;

        public LRUNode getNext() {
            return this.next;
        }

        public LRUNode getPrev() {
            return this.prev;
        }

        public LRUObj getObj() {
            return this.obj;
        }

        protected void setNext(LRUNode lRUNode) {
            this.next = lRUNode;
        }

        protected void setPrev(LRUNode lRUNode) {
            this.prev = lRUNode;
        }

        protected void setObj(LRUObj lRUObj) {
            if (this.obj != null) {
                this.obj.lruRemove();
            }
            this.obj = lRUObj;
            if (this.obj != null) {
                this.obj.lruSet(this);
            }
        }

        protected void unlink() {
            if (this.getNext() != null) {
                this.getNext().setPrev(this.getPrev());
            }
            if (this.getPrev() != null) {
                this.getPrev().setNext(this.getNext());
            }
            this.setNext(null);
            this.setPrev(null);
        }

        protected void insertBefore(LRUNode lRUNode) {
            if (this == lRUNode) {
                return;
            }
            this.unlink();
            if (lRUNode == null) {
                this.setNext(this);
                this.setPrev(this);
            } else {
                this.setNext(lRUNode);
                this.setPrev(lRUNode.getPrev());
                this.getNext().setPrev(this);
                this.getPrev().setNext(this);
            }
        }
    }

    public static interface LRUObj {
        public void lruSet(LRUNode var1);

        public LRUNode lruGet();

        public void lruRemove();
    }
}

