/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.FilterAsAlphaRable;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.FilterAlphaRed;
import org.apache.batik.ext.awt.image.rendered.RenderedImageCachableRed;

public class FilterAlphaRable
extends AbstractRable {
    public FilterAlphaRable(Filter filter) {
        super(filter, null);
    }

    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    public Rectangle2D getBounds2D() {
        return this.getSource().getBounds2D();
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Shape shape;
        AffineTransform affineTransform = renderContext.getTransform();
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        if ((shape = renderContext.getAreaOfInterest()) == null) {
            shape = this.getBounds2D();
        }
        renderingHints.put(FilterAsAlphaRable.KEY_COLORSPACE, FilterAsAlphaRable.VALUE_COLORSPACE_ALPHA);
        RenderedImage renderedImage = this.getSource().createRendering(new RenderContext(affineTransform, shape, renderingHints));
        if (renderedImage == null) {
            return null;
        }
        CachableRed cachableRed = RenderedImageCachableRed.wrap(renderedImage);
        Object object = cachableRed.getProperty("org.apache.batik.gvt.filter.Colorspace");
        if (object == FilterAsAlphaRable.VALUE_COLORSPACE_ALPHA) {
            return cachableRed;
        }
        return new FilterAlphaRed(cachableRed);
    }
}

