/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.image.GraphicsUtil;

abstract class MultipleGradientPaintContext
implements PaintContext {
    protected ColorModel dataModel;
    protected ColorModel model;
    private static ColorModel lrgbmodel_NA = new DirectColorModel(ColorSpace.getInstance(1004), 24, 0xFF0000, 65280, 255, 0, false, 3);
    private static ColorModel srgbmodel_NA = new DirectColorModel(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, false, 3);
    private static ColorModel lrgbmodel_A = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    private static ColorModel srgbmodel_A = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    protected static ColorModel cachedModel;
    protected static WeakReference cached;
    protected WritableRaster saved;
    protected MultipleGradientPaint.CycleMethodEnum cycleMethod;
    protected MultipleGradientPaint.ColorSpaceEnum colorSpace;
    protected float a00;
    protected float a01;
    protected float a10;
    protected float a11;
    protected float a02;
    protected float a12;
    protected boolean isSimpleLookup = true;
    protected int fastGradientArraySize;
    protected int[] gradient;
    protected int[][] gradients;
    protected int gradientsLength;
    protected float[] normalizedIntervals;
    protected float[] fractions;
    protected float[] intervals;
    private Color[] colors;
    private int transparencyTest;
    private static final int[] SRGBtoLinearRGB;
    private static final int[] LinearRGBtoSRGB;
    protected static final int GRADIENT_SIZE = 256;
    protected static final int GRADIENT_SIZE_INDEX = 255;
    private static final int MAX_GRADIENT_ARRAY_SIZE = 5000;

    public MultipleGradientPaintContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum) throws NoninvertibleTransformException {
        boolean bl = false;
        boolean bl2 = false;
        if (fArray[0] != 0.0f) {
            bl = true;
        }
        if (fArray[fArray.length - 1] != 1.0f) {
            bl2 = true;
        }
        if (bl && bl2) {
            this.fractions = new float[fArray.length + 2];
            System.arraycopy(fArray, 0, this.fractions, 1, fArray.length);
            this.fractions[0] = 0.0f;
            this.fractions[this.fractions.length - 1] = 1.0f;
            this.colors = new Color[colorArray.length + 2];
            System.arraycopy(colorArray, 0, this.colors, 1, colorArray.length);
            this.colors[0] = colorArray[0];
            this.colors[this.colors.length - 1] = colorArray[colorArray.length - 1];
        } else if (bl) {
            this.fractions = new float[fArray.length + 1];
            System.arraycopy(fArray, 0, this.fractions, 1, fArray.length);
            this.fractions[0] = 0.0f;
            this.colors = new Color[colorArray.length + 1];
            System.arraycopy(colorArray, 0, this.colors, 1, colorArray.length);
            this.colors[0] = colorArray[0];
        } else if (bl2) {
            this.fractions = new float[fArray.length + 1];
            System.arraycopy(fArray, 0, this.fractions, 0, fArray.length);
            this.fractions[this.fractions.length - 1] = 1.0f;
            this.colors = new Color[colorArray.length + 1];
            System.arraycopy(colorArray, 0, this.colors, 0, colorArray.length);
            this.colors[this.colors.length - 1] = colorArray[colorArray.length - 1];
        } else {
            this.fractions = new float[fArray.length];
            System.arraycopy(fArray, 0, this.fractions, 0, fArray.length);
            this.colors = new Color[colorArray.length];
            System.arraycopy(colorArray, 0, this.colors, 0, colorArray.length);
        }
        this.intervals = new float[this.fractions.length - 1];
        float f = this.fractions[0];
        float f2 = 0.0f;
        int n = 1;
        while (n < this.fractions.length) {
            if (f < 0.0f || f > 1.0f) {
                throw new IllegalArgumentException("Keyframe values should be in the range 0 to 1: " + f);
            }
            f = this.fractions[n];
            f2 = f;
            if (f < f2) {
                throw new IllegalArgumentException("Keyframe fractions must be increasing: " + f);
            }
            this.intervals[n - 1] = f - f2;
            ++n;
        }
        this.normalizedIntervals = new float[this.intervals.length];
        System.arraycopy(this.intervals, 0, this.normalizedIntervals, 0, this.intervals.length);
        float f3 = 0.0f;
        int n2 = 0;
        while (n2 < this.intervals.length) {
            f3 += this.intervals[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.normalizedIntervals.length) {
            int n4 = n3++;
            this.normalizedIntervals[n4] = this.normalizedIntervals[n4] / f3;
        }
        AffineTransform affineTransform2 = affineTransform.createInverse();
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        this.a00 = (float)dArray[0];
        this.a10 = (float)dArray[1];
        this.a01 = (float)dArray[2];
        this.a11 = (float)dArray[3];
        this.a02 = (float)dArray[4];
        this.a12 = (float)dArray[5];
        this.cycleMethod = cycleMethodEnum;
        this.colorSpace = colorSpaceEnum;
        if (colorModel.getColorSpace() == lrgbmodel_A.getColorSpace()) {
            this.dataModel = lrgbmodel_A;
        } else if (colorModel.getColorSpace() == srgbmodel_A.getColorSpace()) {
            this.dataModel = srgbmodel_A;
        } else {
            throw new IllegalArgumentException("Unsupported ColorSpace for interpolation");
        }
        this.model = GraphicsUtil.coerceColorModel(this.dataModel, colorModel.isAlphaPremultiplied());
    }

    protected final void calculateGradientFractions() {
        int n;
        if (this.colorSpace == MultipleGradientPaint.LINEAR_RGB) {
            n = 0;
            while (n < this.colors.length) {
                this.colors[n] = new Color(SRGBtoLinearRGB[this.colors[n].getRed()], SRGBtoLinearRGB[this.colors[n].getGreen()], SRGBtoLinearRGB[this.colors[n].getBlue()]);
                ++n;
            }
        }
        this.transparencyTest = -16777216;
        this.gradients = new int[this.fractions.length - 1][];
        this.gradientsLength = this.gradients.length;
        n = this.normalizedIntervals.length;
        float f = 1.0f;
        int n2 = 0;
        while (n2 < n) {
            f = f > this.normalizedIntervals[n2] ? this.normalizedIntervals[n2] : f;
            ++n2;
        }
        int n3 = 0;
        if (f == 0.0f) {
            n3 = Integer.MAX_VALUE;
        } else {
            int n4 = 0;
            while (n4 < this.normalizedIntervals.length) {
                n3 = (int)((float)n3 + this.normalizedIntervals[n4] / f * 256.0f);
                ++n4;
            }
        }
        if (n3 > 5000) {
            this.calculateMultipleArrayGradient();
        } else {
            this.calculateSingleArrayGradient(f);
        }
        if (this.transparencyTest >>> 24 == 255) {
            if (this.dataModel.getColorSpace() == lrgbmodel_NA.getColorSpace()) {
                this.dataModel = lrgbmodel_NA;
            } else if (this.dataModel.getColorSpace() == srgbmodel_NA.getColorSpace()) {
                this.dataModel = srgbmodel_NA;
            }
            this.model = this.dataModel;
        }
    }

    private void calculateSingleArrayGradient(float f) {
        int n;
        this.isSimpleLookup = true;
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.gradients.length) {
            n = (int)(this.normalizedIntervals[n3] / f * 255.0f);
            n2 += n;
            this.gradients[n3] = new int[n];
            int n4 = this.colors[n3].getRGB();
            int n5 = this.colors[n3 + 1].getRGB();
            this.interpolate(n4, n5, this.gradients[n3]);
            this.transparencyTest &= n4;
            this.transparencyTest &= n5;
            ++n3;
        }
        this.gradient = new int[n2];
        n = 0;
        int n6 = 0;
        while (n6 < this.gradients.length) {
            System.arraycopy(this.gradients[n6], 0, this.gradient, n, this.gradients[n6].length);
            n += this.gradients[n6].length;
            ++n6;
        }
        this.gradient[this.gradient.length - 1] = this.colors[this.colors.length - 1].getRGB();
        if (this.colorSpace == MultipleGradientPaint.LINEAR_RGB) {
            if (this.dataModel.getColorSpace() == ColorSpace.getInstance(1000)) {
                int n7 = 0;
                while (n7 < this.gradient.length) {
                    this.gradient[n7] = this.convertEntireColorLinearRGBtoSRGB(this.gradient[n7]);
                    ++n7;
                }
            }
        } else if (this.dataModel.getColorSpace() == ColorSpace.getInstance(1004)) {
            int n8 = 0;
            while (n8 < this.gradient.length) {
                this.gradient[n8] = this.convertEntireColorSRGBtoLinearRGB(this.gradient[n8]);
                ++n8;
            }
        }
        this.fastGradientArraySize = this.gradient.length - 1;
    }

    private void calculateMultipleArrayGradient() {
        block7: {
            block6: {
                this.isSimpleLookup = false;
                int n = 0;
                while (n < this.gradients.length) {
                    this.gradients[n] = new int[256];
                    int n2 = this.colors[n].getRGB();
                    int n3 = this.colors[n + 1].getRGB();
                    this.interpolate(n2, n3, this.gradients[n]);
                    this.transparencyTest &= n2;
                    this.transparencyTest &= n3;
                    ++n;
                }
                if (this.colorSpace != MultipleGradientPaint.LINEAR_RGB) break block6;
                if (this.dataModel.getColorSpace() != ColorSpace.getInstance(1000)) break block7;
                int n4 = 0;
                while (n4 < this.gradients.length) {
                    int n5 = 0;
                    while (n5 < this.gradients[n4].length) {
                        this.gradients[n4][n5] = this.convertEntireColorLinearRGBtoSRGB(this.gradients[n4][n5]);
                        ++n5;
                    }
                    ++n4;
                }
                break block7;
            }
            if (this.dataModel.getColorSpace() == ColorSpace.getInstance(1004)) {
                int n = 0;
                while (n < this.gradients.length) {
                    int n6 = 0;
                    while (n6 < this.gradients[n].length) {
                        this.gradients[n][n6] = this.convertEntireColorSRGBtoLinearRGB(this.gradients[n][n6]);
                        ++n6;
                    }
                    ++n;
                }
            }
        }
    }

    private void interpolate(int n, int n2, int[] nArray) {
        float f = 1.0f / (float)nArray.length;
        int n3 = n >> 24 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = (n2 >> 24 & 0xFF) - n3;
        int n8 = (n2 >> 16 & 0xFF) - n4;
        int n9 = (n2 >> 8 & 0xFF) - n5;
        int n10 = (n2 & 0xFF) - n6;
        int n11 = 0;
        while (n11 < nArray.length) {
            nArray[n11] = (int)((double)((float)n3 + (float)(n11 * n7) * f) + 0.5) << 24 | (int)((double)((float)n4 + (float)(n11 * n8) * f) + 0.5) << 16 | (int)((double)((float)n5 + (float)(n11 * n9) * f) + 0.5) << 8 | (int)((double)((float)n6 + (float)(n11 * n10) * f) + 0.5);
            ++n11;
        }
    }

    private int convertEntireColorLinearRGBtoSRGB(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        n3 = LinearRGBtoSRGB[n3];
        n4 = LinearRGBtoSRGB[n4];
        n5 = LinearRGBtoSRGB[n5];
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    private int convertEntireColorSRGBtoLinearRGB(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        n3 = SRGBtoLinearRGB[n3];
        n4 = SRGBtoLinearRGB[n4];
        n5 = SRGBtoLinearRGB[n5];
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    protected final int indexIntoGradientsArrays(float f) {
        int n;
        if (this.cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            if (f > 1.0f) {
                f = 1.0f;
            } else if (f < 0.0f) {
                f = 0.0f;
            }
        } else if (this.cycleMethod == MultipleGradientPaint.REPEAT) {
            if ((f -= (float)((int)f)) < 0.0f) {
                f += 1.0f;
            }
        } else {
            if (f < 0.0f) {
                f = -f;
            }
            n = (int)f;
            f -= (float)n;
            if ((n & 1) == 1) {
                f = 1.0f - f;
            }
        }
        if (this.isSimpleLookup) {
            return this.gradient[(int)(f * (float)this.fastGradientArraySize)];
        }
        n = 0;
        while (n < this.gradientsLength) {
            if (f < this.fractions[n + 1]) {
                float f2 = f - this.fractions[n];
                int n2 = (int)(f2 / this.normalizedIntervals[n] * 255.0f);
                return this.gradients[n][n2];
            }
            ++n;
        }
        return this.gradients[this.gradients.length - 1][255];
    }

    private static int convertSRGBtoLinearRGB(int n) {
        float f = (float)n / 255.0f;
        float f2 = f <= 0.04045f ? f / 12.92f : (float)Math.pow(((double)f + 0.055) / 1.055, 2.4);
        int n2 = Math.round(f2 * 255.0f);
        return n2;
    }

    private static int convertLinearRGBtoSRGB(int n) {
        float f = (float)n / 255.0f;
        float f2 = (double)f <= 0.0031308 ? f * 12.92f : 1.055f * (float)Math.pow(f, 0.4166666666666667) - 0.055f;
        int n2 = Math.round(f2 * 255.0f);
        return n2;
    }

    public final Raster getRaster(int n, int n2, int n3, int n4) {
        WritableRaster writableRaster = this.saved;
        if (writableRaster == null || writableRaster.getWidth() < n3 || writableRaster.getHeight() < n4) {
            this.saved = writableRaster = MultipleGradientPaintContext.getCachedRaster(this.dataModel, n3, n4);
        }
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n5 = dataBufferInt.getOffset();
        int n6 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int n7 = n6 - n3;
        this.fillRaster(nArray, n5, n7, n, n2, n3, n4);
        GraphicsUtil.coerceData(writableRaster, this.dataModel, this.model.isAlphaPremultiplied());
        return writableRaster;
    }

    protected abstract void fillRaster(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected static final synchronized WritableRaster getCachedRaster(ColorModel colorModel, int n, int n2) {
        WritableRaster writableRaster;
        if (colorModel == cachedModel && cached != null && (writableRaster = (WritableRaster)cached.get()) != null && writableRaster.getWidth() >= n && writableRaster.getHeight() >= n2) {
            cached = null;
            return writableRaster;
        }
        return colorModel.createCompatibleWritableRaster(n, n2);
    }

    protected static final synchronized void putCachedRaster(ColorModel colorModel, WritableRaster writableRaster) {
        WritableRaster writableRaster2;
        if (cached != null && (writableRaster2 = (WritableRaster)cached.get()) != null) {
            int n = writableRaster2.getWidth();
            int n2 = writableRaster2.getHeight();
            int n3 = writableRaster.getWidth();
            int n4 = writableRaster.getHeight();
            if (n >= n3 && n2 >= n4) {
                return;
            }
            if (n * n2 >= n3 * n4) {
                return;
            }
        }
        cachedModel = colorModel;
        cached = new WeakReference<WritableRaster>(writableRaster);
    }

    public final void dispose() {
        if (this.saved != null) {
            MultipleGradientPaintContext.putCachedRaster(this.model, this.saved);
            this.saved = null;
        }
    }

    public final ColorModel getColorModel() {
        return this.model;
    }

    static {
        SRGBtoLinearRGB = new int[256];
        LinearRGBtoSRGB = new int[256];
        int n = 0;
        while (n < 256) {
            MultipleGradientPaintContext.SRGBtoLinearRGB[n] = MultipleGradientPaintContext.convertSRGBtoLinearRGB(n);
            MultipleGradientPaintContext.LinearRGBtoSRGB[n] = MultipleGradientPaintContext.convertLinearRGBtoSRGB(n);
            ++n;
        }
    }
}

