/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css;

import org.apache.batik.css.CSSOMReadOnlyValue;
import org.apache.batik.css.event.CSSValueChangeListener;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.ValueFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public class CSSOMValue
implements CSSPrimitiveValue,
CSSValueList {
    protected ImmutableValue value;
    protected ValueFactory factory;
    protected CSSValueChangeListener listener;

    public CSSOMValue(ValueFactory valueFactory, ImmutableValue immutableValue) {
        this.factory = valueFactory;
        this.value = immutableValue;
    }

    public void setCSSValueChangeListener(CSSValueChangeListener cSSValueChangeListener) {
        this.listener = cSSValueChangeListener;
    }

    public ImmutableValue getImmutableValue() {
        return this.value;
    }

    public CSSOMReadOnlyValue createReadOnlyCopy() {
        return new CSSOMReadOnlyValue(this.value.createReadOnlyCopy());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CSSOMValue)) {
            return false;
        }
        CSSOMValue cSSOMValue = (CSSOMValue)object;
        return this.value.equals(cSSOMValue.value);
    }

    public String getCssText() {
        return this.value.getCssText();
    }

    public void setCssText(String string) throws DOMException {
        if (this.listener == null) {
            this.value = this.factory.createValue(string);
        } else {
            CSSOMReadOnlyValue cSSOMReadOnlyValue = new CSSOMReadOnlyValue(this.value);
            this.value = this.factory.createValue(string);
            this.listener.cssValueChange(this.factory.getPropertyName(), cSSOMReadOnlyValue, this);
        }
    }

    public short getCssValueType() {
        return this.value.getCssValueType();
    }

    public short getPrimitiveType() {
        return this.value.getPrimitiveType();
    }

    public void setFloatValue(short s, float f) throws DOMException {
        if (this.listener == null) {
            this.value = this.factory.createFloatValue(s, f);
        } else {
            CSSOMReadOnlyValue cSSOMReadOnlyValue = new CSSOMReadOnlyValue(this.value);
            this.value = this.factory.createFloatValue(s, f);
            this.listener.cssValueChange(this.factory.getPropertyName(), cSSOMReadOnlyValue, this);
        }
    }

    public float getFloatValue(short s) throws DOMException {
        return this.value.getFloatValue(s);
    }

    public void setStringValue(short s, String string) throws DOMException {
        if (this.listener == null) {
            this.value = this.factory.createStringValue(s, string);
        } else {
            CSSOMReadOnlyValue cSSOMReadOnlyValue = new CSSOMReadOnlyValue(this.value);
            this.value = this.factory.createStringValue(s, string);
            this.listener.cssValueChange(this.factory.getPropertyName(), cSSOMReadOnlyValue, this);
        }
    }

    public String getStringValue() throws DOMException {
        return this.value.getStringValue();
    }

    public Counter getCounterValue() throws DOMException {
        return this.value.getCounterValue();
    }

    public Rect getRectValue() throws DOMException {
        return this.value.getRectValue();
    }

    public RGBColor getRGBColorValue() throws DOMException {
        return this.value.getRGBColorValue();
    }

    public int getLength() {
        return this.value.getLength();
    }

    public CSSValue item(int n) {
        return this.value.item(n);
    }
}

