/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.Vector;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.FilterPrimitiveBridge;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.MissingAttributeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.CompositeRable8Bit;
import org.apache.batik.ext.awt.image.renderable.CompositeRule;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadMode;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;

public class SVGFeCompositeElementBridge
implements FilterPrimitiveBridge,
SVGConstants {
    public Filter create(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element, Element element2, Filter filter, Rectangle2D rectangle2D, Map map) {
        GraphicsNodeRenderContext graphicsNodeRenderContext = bridgeContext.getGraphicsNodeRenderContext();
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        CompositeRule compositeRule = SVGFeCompositeElementBridge.getRule(element);
        String string = element.getAttributeNS(null, "in");
        Filter filter2 = CSSUtilities.getFilterSource(graphicsNode, string, bridgeContext, element2, filter, map);
        String string2 = element.getAttributeNS(null, "in2");
        if (string2.length() == 0) {
            throw new MissingAttributeException(Messages.formatMessage("feComposite.in2.required", null));
        }
        Filter filter3 = CSSUtilities.getFilterSource(graphicsNode, string2, bridgeContext, element2, filter, map);
        if (filter2 == null || filter3 == null) {
            return null;
        }
        Filter filter4 = (Filter)map.get("SourceGraphic");
        Rectangle2D rectangle2D2 = filter2.getBounds2D();
        rectangle2D2.add(filter3.getBounds2D());
        if (filter2 == filter4) {
            rectangle2D2 = rectangle2D;
        }
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, rectangle2D2, rectangle2D, graphicsNode, graphicsNodeRenderContext, defaultUnitProcessorContext, documentLoader);
        AbstractRable abstractRable = null;
        Vector<Filter> vector = new Vector<Filter>(2);
        vector.add(filter3);
        vector.add(filter2);
        abstractRable = new CompositeRable8Bit(vector, compositeRule, true);
        abstractRable = new PadRable8Bit(abstractRable, rectangle2D3, PadMode.ZERO_PAD);
        String string3 = element.getAttributeNS(null, "result");
        if (string3 != null && string3.trim().length() > 0) {
            map.put(string3, abstractRable);
        }
        return abstractRable;
    }

    private static CompositeRule getRule(Element element) {
        CompositeRule compositeRule;
        String string = element.getAttributeNS(null, "operator");
        if (string.length() == 0) {
            compositeRule = CompositeRule.OVER;
        } else if ("atop".equals(string)) {
            compositeRule = CompositeRule.ATOP;
        } else if ("arithmetic".equals(string)) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            String string2 = element.getAttributeNS(null, "k1");
            if (string2.length() != 0) {
                f = SVGUtilities.convertSVGNumber("k1", string2);
            }
            if ((string2 = element.getAttributeNS(null, "k2")).length() != 0) {
                f2 = SVGUtilities.convertSVGNumber("k2", string2);
            }
            if ((string2 = element.getAttributeNS(null, "k3")).length() != 0) {
                f3 = SVGUtilities.convertSVGNumber("k3", string2);
            }
            if ((string2 = element.getAttributeNS(null, "k4")).length() != 0) {
                f4 = SVGUtilities.convertSVGNumber("k4", string2);
            }
            compositeRule = CompositeRule.ARITHMETIC(f, f2, f3, f4);
        } else if ("in".equals(string)) {
            compositeRule = CompositeRule.IN;
        } else if ("over".equals(string)) {
            compositeRule = CompositeRule.OVER;
        } else if ("out".equals(string)) {
            compositeRule = CompositeRule.OUT;
        } else if ("xor".equals(string)) {
            compositeRule = CompositeRule.XOR;
        } else {
            throw new IllegalAttributeValueException(Messages.formatMessage("feComposite.operator.invalid", new Object[]{string}));
        }
        return compositeRule;
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }
}

