/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.xalan.transformer.DecimalToRoman;
import org.apache.xalan.transformer.TransformerImpl;
import org.w3c.dom.Element;

class NumeratorFormatter {
    protected Element m_xslNumberElement;
    NumberFormatStringTokenizer m_formatTokenizer;
    Locale m_locale;
    NumberFormat m_formatter;
    TransformerImpl m_processor;
    private static final DecimalToRoman[] m_romanConvertTable = new DecimalToRoman[]{new DecimalToRoman(1000L, "M", 900L, "CM"), new DecimalToRoman(500L, "D", 400L, "CD"), new DecimalToRoman(100L, "C", 90L, "XC"), new DecimalToRoman(50L, "L", 40L, "XL"), new DecimalToRoman(10L, "X", 9L, "IX"), new DecimalToRoman(5L, "V", 4L, "IV"), new DecimalToRoman(1L, "I", 1L, "I")};
    private static final char[] m_alphaCountTable = new char[]{'Z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y'};

    NumeratorFormatter(Element element, TransformerImpl transformerImpl) {
        this.m_xslNumberElement = element;
        this.m_processor = transformerImpl;
    }

    protected String int2alphaCount(int n, char[] cArray) {
        int n2 = cArray.length;
        char[] cArray2 = new char[100];
        int n3 = cArray2.length - 1;
        int n4 = 1;
        int n5 = 0;
        while ((n4 = (n + (n5 = n4 == 0 || n5 != 0 && n4 == n2 - 1 ? n2 - 1 : 0)) % n2) != 0 || (n /= n2) != 0) {
            cArray2[n3--] = cArray[n4];
            if (n > 0) continue;
        }
        return new String(cArray2, n3 + 1, cArray2.length - n3 - 1);
    }

    String long2roman(long l, boolean bl) {
        if (l <= 0L) {
            return "#E(" + l + ")";
        }
        String string = "";
        int n = 0;
        if (l <= 3999L) {
            while (true) {
                if (l >= NumeratorFormatter.m_romanConvertTable[n].m_postValue) {
                    string = String.valueOf(string) + NumeratorFormatter.m_romanConvertTable[n].m_postLetter;
                    l -= NumeratorFormatter.m_romanConvertTable[n].m_postValue;
                    continue;
                }
                if (bl && l >= NumeratorFormatter.m_romanConvertTable[n].m_preValue) {
                    string = String.valueOf(string) + NumeratorFormatter.m_romanConvertTable[n].m_preLetter;
                    l -= NumeratorFormatter.m_romanConvertTable[n].m_preValue;
                }
                ++n;
                if (l <= 0L) break;
            }
        } else {
            string = "#error";
        }
        return string;
    }

    class NumberFormatStringTokenizer {
        private int currentPosition;
        private int maxPosition;
        private String str;

        NumberFormatStringTokenizer(String string) {
            this.str = string;
            this.maxPosition = string.length();
        }

        int countTokens() {
            int n = 0;
            int n2 = this.currentPosition;
            while (n2 < this.maxPosition) {
                int n3 = n2;
                while (n2 < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(n2))) {
                    ++n2;
                }
                if (n3 == n2 && !Character.isLetterOrDigit(this.str.charAt(n2))) {
                    ++n2;
                }
                ++n;
            }
            return n;
        }

        boolean hasMoreTokens() {
            return this.currentPosition < this.maxPosition;
        }

        String nextToken() {
            if (this.currentPosition >= this.maxPosition) {
                throw new NoSuchElementException();
            }
            int n = this.currentPosition;
            while (this.currentPosition < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            if (n == this.currentPosition && !Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            return this.str.substring(n, this.currentPosition);
        }

        void reset() {
            this.currentPosition = 0;
        }
    }
}

