/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.store;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.cocoon.framework.Configurable;
import org.apache.cocoon.framework.Configurations;
import org.apache.cocoon.framework.InitializationException;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.store.Store;

public class MemoryStore
implements Store,
Status,
Configurable,
Runnable {
    private int freememory;
    private int heapsize;
    private long interval;
    private boolean useThread;
    private int priority;
    private Runtime jvm;
    private Hashtable hashtable;
    private static final long factor = 2L;

    public synchronized boolean containsKey(Object key) {
        return this.hashtable.containsKey(key);
    }

    private long evaluate(Container c, long time) {
        return 2L * (long)c.count + 0x3FFFFFFFFFFFFFFFL - (time - c.time);
    }

    public synchronized void free() {
        Object worst = this.getWorst();
        if (worst != null) {
            this.hashtable.remove(worst);
        }
        this.jvm.runFinalization();
        this.jvm.gc();
    }

    public synchronized Object get(Object key) {
        Object o = this.hashtable.get(key);
        if (o != null) {
            Container c = (Container)o;
            c.time = System.currentTimeMillis();
            ++c.count;
            return c.object;
        }
        return null;
    }

    public synchronized String getStatus() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Memory Object Storage System:<br>");
        buffer.append("Using daemon thread: " + this.useThread + "<br>");
        if (this.useThread) {
            buffer.append("Daemon thread priority: " + this.priority + "<br>");
            buffer.append("Daemon thread check interval: " + this.interval + "<br>");
        }
        buffer.append("Minimum required free memory: " + this.freememory + "<br>");
        buffer.append("Minimum heap size: " + this.heapsize + "<br>");
        buffer.append("Current free memory: " + this.jvm.freeMemory() + "<br>");
        buffer.append("Current heap size: " + this.jvm.totalMemory() + "<br><ul>");
        Enumeration e = this.list();
        while (e.hasMoreElements()) {
            buffer.append("<li>");
            buffer.append(e.nextElement());
            buffer.append("</li>");
        }
        buffer.append("</ul>");
        return buffer.toString();
    }

    private Object getWorst() {
        long time = System.currentTimeMillis();
        long minimum = Long.MAX_VALUE;
        Object minimumKey = null;
        Enumeration keys = this.hashtable.keys();
        Enumeration values = this.hashtable.elements();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Container value = (Container)values.nextElement();
            long importance = this.evaluate(value, time);
            if (importance >= minimum) continue;
            minimum = importance;
            minimumKey = key;
        }
        return minimumKey;
    }

    public synchronized void hold(Object key, Object object) {
        if (this.jvm.totalMemory() > (long)this.heapsize && this.jvm.freeMemory() < (long)this.freememory) {
            this.free();
        }
        this.hashtable.put(key, new Container(object));
    }

    public void init(Configurations conf) throws InitializationException {
        this.jvm = Runtime.getRuntime();
        this.hashtable = new Hashtable(101, 0.75f);
        this.priority = 10;
        try {
            this.freememory = Integer.parseInt((String)conf.get("freememory", "1000000"));
            this.heapsize = Integer.parseInt((String)conf.get("heapsize", "60000000"));
            this.interval = Integer.parseInt((String)conf.get("interval", "10"));
            String pri = (String)conf.get("threadpriority");
            if (pri != null) {
                this.priority = Integer.parseInt(pri);
                if (this.priority < 1 || this.priority > 10) {
                    throw new InitializationException("Thread priority must be between 1 and 10");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InitializationException("freememory, heapsize, interval and threadpriority must be valid whole numbers");
        }
        this.useThread = conf.get("usethread", "true").equals("true");
        if (this.useThread) {
            Thread checker = new Thread(this);
            checker.setPriority(this.priority);
            checker.setDaemon(true);
            checker.start();
        }
    }

    public synchronized Enumeration list() {
        return this.hashtable.keys();
    }

    public synchronized void remove(Object key) {
        this.hashtable.remove(key);
    }

    public void run() {
        while (true) {
            if (this.jvm.totalMemory() > (long)this.heapsize) {
                this.jvm.runFinalization();
                this.jvm.gc();
                MemoryStore memoryStore = this;
                synchronized (memoryStore) {
                    while (this.hashtable.size() > 0 && this.jvm.freeMemory() < (long)this.freememory) {
                        this.free();
                    }
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.interval * 1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void store(Object key, Object value) {
        throw new RuntimeException("Method MemoryStore.store() not implemented!");
    }

    class Container {
        public Object object;
        public long time = 0L;
        public int count = 0;

        public Container(Object object) {
            this.object = object;
        }
    }
}

