/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.sql;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.cocoon.processor.sql.Column;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ColumnFormatter {
    protected Properties formats_by_name = new Properties();
    protected Properties formats_by_type = new Properties();

    protected ColumnFormatter(Element query_element) {
        NodeList children = query_element.getElementsByTagName("column");
        Element[] ary = new Element[children.getLength()];
        int i = 0;
        while (i < ary.length) {
            ary[i] = (Element)children.item(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < ary.length) {
            Element element = ary[i2];
            String name = element.getAttribute("name");
            String type = element.getAttribute("type");
            String format = element.getAttribute("format");
            this.putFormat(name, type, format);
            ++i2;
        }
    }

    protected void addColumnNode(Document document, Element parent, Column column, Object value, int i) throws SQLException {
        String format = this.getFormat(column);
        if (format != null) {
            if (column.type.equals("timestamp") || column.type.equals("time") || column.type.equals("date") || column.type.equals("datetime")) {
                if (value instanceof Date) {
                    SimpleDateFormat date_format = new SimpleDateFormat(format);
                    parent.appendChild(document.createTextNode(date_format.format((Date)value)));
                } else {
                    parent.appendChild(document.createTextNode(value.toString()));
                }
                return;
            }
            if (column.type.equals("varchar") || column.type.equals("text")) {
                String strvalue = ColumnFormatter.getStringValue(value);
                if (format.equals("br")) {
                    StringBuffer sb = new StringBuffer();
                    StringCharacterIterator iter = new StringCharacterIterator(strvalue);
                    char c = iter.first();
                    while (c != '\uffff') {
                        if (c == '\n') {
                            if (sb.length() > 0) {
                                parent.appendChild(document.createTextNode(sb.toString()));
                                sb.setLength(0);
                            }
                            parent.appendChild(document.createElement("br"));
                        } else {
                            sb.append(c);
                        }
                        c = iter.next();
                    }
                    if (sb.length() > 0) {
                        parent.appendChild(document.createTextNode(sb.toString()));
                    }
                    return;
                }
            }
        }
        parent.appendChild(document.createTextNode(ColumnFormatter.getStringValue(value)));
    }

    protected String getFormat(Column column) {
        String format = this.formats_by_name.getProperty(column.name);
        if (format == null) {
            format = this.formats_by_type.getProperty(column.type);
        }
        return format;
    }

    protected static String getStringValue(Object value) {
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        if (value instanceof char[]) {
            return new String((char[])value);
        }
        return value.toString();
    }

    protected void putFormat(String name, String type, String format) {
        if (format == null || format.equals("")) {
            return;
        }
        if (name == null || name.equals("") && type != null && !type.equals("")) {
            ((Hashtable)this.formats_by_type).put(type, format);
        } else {
            ((Hashtable)this.formats_by_name).put(name, format);
        }
    }
}

