/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GZip
extends Task {
    private File zipFile;
    private File source;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        this.log("Building gzip: " + this.zipFile.getAbsolutePath());
        GZIPOutputStream zOut = null;
        try {
            try {
                zOut = new GZIPOutputStream(new FileOutputStream(this.zipFile));
                if (this.source.isDirectory()) {
                    this.log("Cannot Gzip a directory!", 0);
                } else {
                    this.zipFile(this.source, zOut);
                }
            }
            catch (IOException ioe) {
                String msg = "Problem creating gzip " + ioe.getMessage();
                throw new BuildException(msg, ioe, this.location);
            }
            Object var3_4 = null;
            if (zOut == null) return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (zOut == null) throw throwable;
            try {
                zOut.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zOut.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void setSrc(String src) {
        this.source = this.project.resolveFile(src);
    }

    public void setZipfile(String zipFilename) {
        this.zipFile = this.project.resolveFile(zipFilename);
    }

    private void zipFile(File file, GZIPOutputStream zOut) throws IOException {
        FileInputStream fIn = new FileInputStream(file);
        try {
            this.zipFile(fIn, zOut);
        }
        finally {
            Object var5_4 = null;
            fIn.close();
        }
    }

    private void zipFile(InputStream in, GZIPOutputStream zOut) throws IOException {
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            zOut.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
    }
}

