package org.biojava.utils.bytecode;

import java.lang.reflect.*;

/**
 * Wrap up details about a method in a Java class file
 *
 * @author Thomas Down
 */

class IntrospectedCodeMethod implements CodeMethod {
    private final Method _method;

    public IntrospectedCodeMethod(Method m) {
	_method = m;
    }

    public String getName() {
	return _method.getName();
    }

    public String getFullName() {
	return _method.getDeclaringClass().getName() + "." + getName();
    }

    public CodeClass getContainingClass() {
	return IntrospectedCodeClass.forClass(_method.getDeclaringClass());
    }

    public String getDescriptor() {
	StringBuffer sb = new StringBuffer();
	sb.append('(');
	for (int i = 0; i < numParameters(); ++i) {
	    CodeClass cc = getParameterType(i);
	    sb.append(cc.getDescriptor());
	}
	sb.append(')');
	sb.append(getReturnType().getDescriptor());
	return sb.toString();
    }

    public int getModifiers() {
	return _method.getModifiers();
    }

    public CodeClass getReturnType() {
	return IntrospectedCodeClass.forClass(_method.getReturnType());
    }

    public int numParameters() {
	return _method.getParameterTypes().length;
    }

    public CodeClass getParameterType(int pos) {
	return IntrospectedCodeClass.forClass(_method.getParameterTypes()[pos]);
    }
  
  public String toString() {
    return super.toString() + " " + getDescriptor();
  }
}
