/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.ClassPathException;
import bsh.ConsoleInterface;
import bsh.Interpreter;
import bsh.classpath.BshClassLoader;
import bsh.classpath.BshClassPath;
import bsh.classpath.DiscreteFilesClassLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class BshClassManager {
    BshClassPath baseClassPath;
    BshClassPath fullClassPath;
    Vector listeners = new Vector();
    BshClassLoader baseLoader;
    Map loaderMap;
    static transient Hashtable absoluteClassCache = new Hashtable();
    static transient Hashtable absoluteNonClasses = new Hashtable();
    private static BshClassManager manager = new BshClassManager();
    static /* synthetic */ Class class$bsh$NameSpace;

    public static BshClassManager getClassManager() {
        return manager;
    }

    private BshClassManager() {
        this.reset();
    }

    public Class getClassForName(String string) {
        Class<?> clazz = (Class<?>)absoluteClassCache.get(string);
        if (clazz != null) {
            return clazz;
        }
        if (absoluteNonClasses.get(string) != null) {
            return null;
        }
        ClassLoader classLoader = this.getLoaderForClass(string);
        if (classLoader != null) {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (Exception exception) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (clazz == null) {
            if (this.baseLoader != null && !string.startsWith("bsh.")) {
                try {
                    clazz = this.baseLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                try {
                    clazz = this.loadSystemClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (clazz != null) {
            absoluteClassCache.put(string, clazz);
        } else {
            absoluteNonClasses.put(string, "unused");
        }
        return clazz;
    }

    public static boolean classExists(String string) {
        return BshClassManager.classForName(string) != null;
    }

    public ClassLoader getBaseLoader() {
        return this.baseLoader;
    }

    public Class loadSystemClass(String string) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ClassNotFoundException(noClassDefFoundError.toString());
        }
    }

    public ClassLoader getLoaderForClass(String string) {
        return (ClassLoader)this.loaderMap.get(string);
    }

    public void addClassPath(URL uRL, ConsoleInterface consoleInterface) throws IOException {
        if (this.baseLoader == null) {
            this.setClassPath(new URL[]{uRL});
        } else {
            this.baseLoader.addURL(uRL);
            this.baseClassPath.add(uRL, consoleInterface);
            this.classLoaderChanged();
        }
    }

    public void reset() {
        this.baseClassPath = new BshClassPath("baseClassPath");
        this.baseLoader = null;
        this.loaderMap = new HashMap();
        this.classLoaderChanged();
    }

    public void setClassPath(URL[] uRLArray) {
        this.baseClassPath.setPath(uRLArray);
        this.initBaseLoader();
        this.loaderMap = new HashMap();
        this.classLoaderChanged();
    }

    public void reloadAllClasses() throws ClassPathException {
        BshClassPath bshClassPath = new BshClassPath("temp");
        bshClassPath.addComponent(this.baseClassPath);
        bshClassPath.addComponent(BshClassPath.getUserClassPath());
        this.setClassPath(bshClassPath.getPathComponents());
    }

    private void initBaseLoader() {
        this.baseLoader = new BshClassLoader(this.baseClassPath);
    }

    public void reloadClasses(String[] stringArray, ConsoleInterface consoleInterface) throws ClassPathException {
        Object object;
        Object object2;
        if (this.baseLoader == null) {
            this.initBaseLoader();
        }
        DiscreteFilesClassLoader.ClassSourceMap classSourceMap = new DiscreteFilesClassLoader.ClassSourceMap();
        int n = 0;
        while (n < stringArray.length) {
            object2 = stringArray[n];
            if (consoleInterface != null) {
                this.baseClassPath.insureInitialized(consoleInterface);
            }
            if ((object = this.baseClassPath.getClassSource((String)object2)) == null) {
                if (consoleInterface != null) {
                    BshClassPath.getUserClassPath().insureInitialized(consoleInterface);
                }
                object = BshClassPath.getUserClassPath().getClassSource((String)object2);
            }
            if (object == null) {
                throw new ClassPathException("Nothing known about class: " + (String)object2);
            }
            if (!(object instanceof BshClassPath.DirClassSource)) {
                throw new ClassPathException("Cannot reload class: " + (String)object2 + " from source: " + object);
            }
            classSourceMap.put((String)object2, ((BshClassPath.DirClassSource)object).getDir());
            ++n;
        }
        object2 = new DiscreteFilesClassLoader(classSourceMap);
        object = classSourceMap.keySet().iterator();
        while (object.hasNext()) {
            this.loaderMap.put((String)object.next(), object2);
        }
        this.classLoaderChanged();
    }

    public void reloadPackage(String string, ConsoleInterface consoleInterface) throws ClassPathException {
        Set set = this.baseClassPath.getClassesForPackage(string);
        if (set == null) {
            set = BshClassPath.getUserClassPath().getClassesForPackage(string);
        }
        if (set == null) {
            throw new ClassPathException("No classes found for package: " + string);
        }
        this.reloadClasses(set.toArray(new String[0]), consoleInterface);
    }

    public BshClassPath getClassPath() throws ClassPathException {
        if (this.fullClassPath != null) {
            return this.fullClassPath;
        }
        this.fullClassPath = new BshClassPath("BeanShell Full Class Path");
        this.fullClassPath.addComponent(BshClassPath.getUserClassPath());
        try {
            this.fullClassPath.addComponent(BshClassPath.getBootClassPath());
        }
        catch (ClassPathException classPathException) {
            System.err.println("Warning: can't get boot class path");
        }
        this.fullClassPath.addComponent(this.baseClassPath);
        return this.fullClassPath;
    }

    void doSuperImport(ConsoleInterface consoleInterface) {
        try {
            this.getClassPath().insureInitialized(consoleInterface);
            this.getClassNameByUnqName("");
            this.getClassPath().setNameCompletionIncludeUnqNames(true);
        }
        catch (ClassPathException classPathException) {
            consoleInterface.error(classPathException.getMessage());
        }
    }

    String getClassNameByUnqName(String string) throws ClassPathException {
        return this.getClassPath().getClassNameByUnqName(string);
    }

    public static Class classForName(String string) {
        return BshClassManager.getClassManager().getClassForName(string);
    }

    public void addListener(Listener listener) {
        this.listeners.addElement(new WeakReference<Listener>(listener));
    }

    public void removeListener(Listener listener) {
        this.listeners.removeElement(listener);
    }

    void classLoaderChanged() {
        absoluteNonClasses = new Hashtable();
        absoluteClassCache = new Hashtable();
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            WeakReference weakReference = (WeakReference)enumeration.nextElement();
            Listener listener = (Listener)weakReference.get();
            if (listener == null) {
                this.listeners.removeElement(weakReference);
                continue;
            }
            listener.classLoaderChanged();
        }
    }

    public void dump(ConsoleInterface consoleInterface) {
        consoleInterface.println("Bsh Class Manager Dump: ");
        consoleInterface.println("----------------------- ");
        consoleInterface.println("baseLoader = " + this.baseLoader);
        consoleInterface.println("loaderMap= " + this.loaderMap);
        consoleInterface.println("----------------------- ");
        consoleInterface.println("baseClassPath = " + this.baseClassPath);
    }

    public static void loadJavaPackagesOptimization() throws IOException {
        String string;
        if (absoluteNonClasses != null) {
            return;
        }
        InputStream inputStream = (class$bsh$NameSpace == null ? (class$bsh$NameSpace = BshClassManager.class$("bsh.NameSpace")) : class$bsh$NameSpace).getResourceAsStream(string = "lib/javaPackages");
        if (inputStream == null) {
            throw new IOException("couldn't load resource: " + string);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                absoluteNonClasses.put(string2, "unused");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Interpreter.debug("failed to load java package names...");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static interface Listener {
        public void classLoaderChanged();
    }
}

