/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.utils;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.views.table.ITableStructureModificationListener;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.utils.VerticalAligner;

public class TableColumnEditorWindow {
    private Display display;
    private Shell shell;
    private Color blue;
    private Table table;
    private TableColumnCore[] tableColumns;
    private ITableStructureModificationListener listener;
    private boolean mousePressed;
    private TableItem selectedItem;
    Point oldPoint;
    Image oldImage;

    public Shell getShell() {
        return this.shell;
    }

    public TableColumnEditorWindow(Display _display, TableColumnCore[] _tableColumns, ITableStructureModificationListener _listener) {
        this.display = _display;
        this.tableColumns = _tableColumns;
        this.listener = _listener;
        this.blue = new Color((Device)this.display, 0, 0, 128);
        this.shell = new Shell(this.display, 67696);
        this.shell.setImage(ImageRepository.getImage("azureus"));
        this.shell.setText(MessageText.getString("columnChooser.title"));
        GridLayout layout = new GridLayout();
        this.shell.setLayout((Layout)layout);
        Label label = new Label((Composite)this.shell, 0);
        label.setText(MessageText.getString("columnChooser.move"));
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.table = new Table((Composite)this.shell, 67620);
        gridData = new GridData(1808);
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        Font f = this.table.getFont();
        FontData fd = f.getFontData()[0];
        fd.setHeight(9);
        final Font fontNew = new Font((Device)this.display, fd);
        this.table.setFont(fontNew);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent de) {
                if (fontNew != null && !fontNew.isDisposed()) {
                    fontNew.dispose();
                }
            }
        });
        Composite cButtonArea = new Composite((Composite)this.shell, 0);
        gridData = new GridData(128);
        cButtonArea.setLayoutData((Object)gridData);
        RowLayout rLayout = new RowLayout(256);
        rLayout.marginLeft = 0;
        rLayout.marginTop = 0;
        rLayout.marginRight = 0;
        rLayout.marginBottom = 0;
        rLayout.spacing = 5;
        cButtonArea.setLayout((Layout)rLayout);
        Button bOk = new Button(cButtonArea, 8);
        bOk.setText(MessageText.getString("Button.ok"));
        RowData rd = new RowData();
        rd.width = 70;
        bOk.setLayoutData((Object)rd);
        bOk.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumnEditorWindow.this.saveAndApply();
                TableColumnEditorWindow.this.close();
            }
        });
        Button bCancel = new Button(cButtonArea, 8);
        bCancel.setText(MessageText.getString("Button.cancel"));
        rd = new RowData();
        rd.width = 70;
        bCancel.setLayoutData((Object)rd);
        bCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumnEditorWindow.this.close();
            }
        });
        Button bApply = new Button(cButtonArea, 8);
        bApply.setText(MessageText.getString("columnChooser.apply"));
        rd = new RowData();
        rd.width = 70;
        bApply.setLayoutData((Object)rd);
        bApply.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumnEditorWindow.this.saveAndApply();
            }
        });
        String[] columnsHeader = new String[]{"columnname", "columndescription"};
        int i = 0;
        while (i < columnsHeader.length) {
            TableColumn column = new TableColumn(this.table, 0);
            if (columnsHeader[i] != "") {
                column.setText(MessageText.getString("columnChooser." + columnsHeader[i]));
            }
            ++i;
        }
        Arrays.sort(this.tableColumns, new Comparator(){

            public final int compare(Object a, Object b) {
                int iPositionB;
                int iPositionA = ((TableColumnCore)a).getPosition();
                if (iPositionA == -1) {
                    iPositionA = 65535;
                }
                if ((iPositionB = ((TableColumnCore)b).getPosition()) == -1) {
                    iPositionB = 65535;
                }
                return iPositionA - iPositionB;
            }
        });
        i = 0;
        while (i < this.tableColumns.length) {
            this.createTableRow(-1, this.tableColumns[i], this.tableColumns[i].getPosition() >= 0);
            ++i;
        }
        i = 0;
        while (i < columnsHeader.length) {
            this.table.getColumn(i).pack();
            ++i;
        }
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent arg0) {
                TableColumnEditorWindow.this.mousePressed = true;
                TableColumnEditorWindow.this.selectedItem = TableColumnEditorWindow.this.table.getItem(new Point(arg0.x, arg0.y));
            }

            public void mouseUp(MouseEvent e) {
                TableColumnEditorWindow.this.mousePressed = false;
                if (TableColumnEditorWindow.this.oldPoint != null && TableColumnEditorWindow.this.oldImage != null) {
                    GC gc = new GC((Drawable)TableColumnEditorWindow.this.table);
                    gc.drawImage(TableColumnEditorWindow.this.oldImage, TableColumnEditorWindow.this.oldPoint.x, TableColumnEditorWindow.this.oldPoint.y);
                    TableColumnEditorWindow.this.oldImage.dispose();
                    TableColumnEditorWindow.this.oldImage = null;
                    TableColumnEditorWindow.this.oldPoint = null;
                }
                Point p = new Point(e.x, e.y);
                TableItem item = TableColumnEditorWindow.this.table.getItem(p);
                if (item != null && TableColumnEditorWindow.this.selectedItem != null) {
                    int oldIndex;
                    int index = TableColumnEditorWindow.this.table.indexOf(item);
                    if (index == (oldIndex = TableColumnEditorWindow.this.table.indexOf(TableColumnEditorWindow.this.selectedItem))) {
                        return;
                    }
                    if (index > oldIndex) {
                        ++index;
                    }
                    TableColumnCore tableColumn = (TableColumnCore)TableColumnEditorWindow.this.selectedItem.getData("TableColumn");
                    TableColumnEditorWindow.this.createTableRow(index, tableColumn, TableColumnEditorWindow.this.selectedItem.getChecked());
                    TableColumnEditorWindow.this.selectedItem.dispose();
                }
            }
        });
        this.table.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (!TableColumnEditorWindow.this.mousePressed || TableColumnEditorWindow.this.selectedItem == null) {
                    return;
                }
                Point p = new Point(e.x, e.y);
                TableItem item = TableColumnEditorWindow.this.table.getItem(p);
                if (item == null) {
                    return;
                }
                GC gc = new GC((Drawable)TableColumnEditorWindow.this.table);
                Rectangle bounds = item.getBounds(0);
                int selectedPosition = TableColumnEditorWindow.this.table.indexOf(TableColumnEditorWindow.this.selectedItem);
                int newPosition = TableColumnEditorWindow.this.table.indexOf(item);
                if (TableColumnEditorWindow.this.oldPoint != null && TableColumnEditorWindow.this.oldImage != null) {
                    gc.drawImage(TableColumnEditorWindow.this.oldImage, TableColumnEditorWindow.this.oldPoint.x, TableColumnEditorWindow.this.oldPoint.y);
                    TableColumnEditorWindow.this.oldImage.dispose();
                    TableColumnEditorWindow.this.oldImage = null;
                    TableColumnEditorWindow.this.oldPoint = null;
                }
                bounds.y += VerticalAligner.getTableAdjustVerticalBy(TableColumnEditorWindow.this.table);
                TableColumnEditorWindow.this.oldPoint = newPosition <= selectedPosition ? new Point(bounds.x, bounds.y) : new Point(bounds.x, bounds.y + bounds.height);
                TableColumnEditorWindow.this.oldImage = new Image((Device)TableColumnEditorWindow.this.display, bounds.width, 2);
                gc.copyArea(TableColumnEditorWindow.this.oldImage, TableColumnEditorWindow.this.oldPoint.x, TableColumnEditorWindow.this.oldPoint.y);
                gc.setBackground(TableColumnEditorWindow.this.blue);
                gc.fillRectangle(TableColumnEditorWindow.this.oldPoint.x, TableColumnEditorWindow.this.oldPoint.y, bounds.width, 2);
            }
        });
        this.table.redraw();
        this.shell.pack();
        Point p = this.shell.getSize();
        if (p.x > 550) {
            p.x = 550;
            this.shell.setSize(p);
        }
        this.shell.open();
    }

    private void close() {
        if (this.blue != null && !this.blue.isDisposed()) {
            this.blue.dispose();
        }
        this.shell.dispose();
    }

    private void saveAndApply() {
        TableItem[] items = this.table.getItems();
        int position = 0;
        int i = 0;
        while (i < items.length) {
            TableColumnCore tableColumn = (TableColumnCore)items[i].getData("TableColumn");
            tableColumn.setPositionNoShift(items[i].getChecked() ? position++ : -1);
            tableColumn.saveSettings();
            ++i;
        }
        this.listener.tableStructureChanged();
    }

    private void createTableRow(int index, TableColumnCore tableColumn, boolean selected) {
        String name = tableColumn.getName();
        TableItem item = index == -1 ? new TableItem(this.table, 0) : new TableItem(this.table, 0, index);
        String sTitleLanguageKey = tableColumn.getTitleLanguageKey();
        item.setText(0, MessageText.getString(sTitleLanguageKey));
        item.setText(1, MessageText.getString(String.valueOf(sTitleLanguageKey) + ".info", ""));
        item.setData("TableColumn", (Object)tableColumn);
        item.setChecked(selected);
    }
}

