/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.updater2;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.swt.SWT;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class SWTVersionGetter {
    public static String[] swtURLProviders = new String[]{"http://azureus.aelitis.com/swt_version.php"};
    public static final int VERSION_TIMEOUT_MILLIS = 30000;
    private String platform = SWT.getPlatform();
    private int index = 0;
    private int currentVersion = SWT.getVersion();
    private int latestVersion = 0;
    private UpdateChecker checker;
    private String[] mirrors;

    public SWTVersionGetter(UpdateChecker _checker) {
        this.checker = _checker;
    }

    public boolean needsUpdate() {
        try {
            this.downloadLatestVersion();
            String msg = "SWT: current version =  " + this.currentVersion + ", latest version = " + this.latestVersion;
            this.checker.reportProgress(msg);
            LGLogger.log(msg);
            return this.latestVersion > this.currentVersion;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void downloadLatestVersion() {
        String url = swtURLProviders[this.index];
        String downloadURL = String.valueOf(url) + "?platform=" + this.platform + "&version=" + "2.2.0.2";
        LGLogger.log("Requesting latest SWT version/mirrors by opening URL : " + downloadURL);
        try {
            ResourceDownloaderFactory rdf = ResourceDownloaderFactoryImpl.getSingleton();
            ResourceDownloader downloader = rdf.create(new URL(downloadURL));
            downloader = rdf.getTimeoutDownloader(downloader, 30000);
            this.processData(downloader.download());
        }
        catch (Exception e) {
            this.nextTry();
        }
    }

    private void nextTry() {
        ++this.index;
        if (this.index >= swtURLProviders.length) {
            return;
        }
        this.downloadLatestVersion();
    }

    public void processData(InputStream is) throws Exception {
        if (is == null) {
            this.nextTry();
            return;
        }
        try {
            int version;
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String versionStr = br.readLine();
            this.latestVersion = version = Integer.parseInt(versionStr);
            String mirror = null;
            ArrayList<String> tempList = new ArrayList<String>();
            while ((mirror = br.readLine()) != null) {
                tempList.add(mirror);
            }
            this.mirrors = tempList.toArray(new String[tempList.size()]);
        }
        catch (Exception e) {
            this.nextTry();
        }
    }

    public int getLatestVersion() {
        return this.latestVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String[] getMirrors() {
        return this.mirrors;
    }
}

