/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.graphics;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.components.graphics.Scale;
import org.gudy.azureus2.ui.swt.components.graphics.ScaledGraphic;
import org.gudy.azureus2.ui.swt.components.graphics.ValueFormater;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class SpeedGraphic
extends ScaledGraphic
implements ParameterListener {
    private int internalLoop;
    private int graphicsUpdate;
    private Point oldSize;
    protected Image bufferImage;
    private int average = 0;
    private int nbValues = 0;
    private int[] values = new int[2000];
    private int[] targetValues = new int[2000];
    private int currentPosition = 0;

    private SpeedGraphic(Scale scale, ValueFormater formater) {
        super(scale, formater);
        COConfigurationManager.addParameterListener("Graphics Update", this);
        this.parameterChanged("Graphics Update");
    }

    public static SpeedGraphic getInstance() {
        return new SpeedGraphic(new Scale(), new ValueFormater(){

            public String format(int value) {
                return DisplayFormatters.formatByteCountToBase10KBEtcPerSec(value);
            }
        });
    }

    public void addIntsValue(int value, int targetValue) {
        try {
            this.this_mon.enter();
            this.average += value - this.values[this.currentPosition];
            this.targetValues[this.currentPosition] = targetValue;
            this.values[this.currentPosition++] = value;
            if (this.nbValues < 2000) {
                ++this.nbValues;
            }
            if (this.currentPosition >= this.values.length) {
                this.currentPosition = 0;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addIntValue(int value) {
        try {
            this.this_mon.enter();
            this.average += value - this.values[this.currentPosition];
            this.values[this.currentPosition++] = value;
            if (this.nbValues < 2000) {
                ++this.nbValues;
            }
            if (this.currentPosition >= this.values.length) {
                this.currentPosition = 0;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void refresh() {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed()) {
            return;
        }
        Rectangle bounds = this.drawCanvas.getClientArea();
        if (bounds.height < 30 || bounds.width < 100 || bounds.width > 2000 || bounds.height > 2000) {
            return;
        }
        boolean sizeChanged = this.oldSize == null || this.oldSize.x != bounds.width && this.oldSize.y != bounds.height;
        this.oldSize = new Point(bounds.width, bounds.height);
        ++this.internalLoop;
        if (this.internalLoop > this.graphicsUpdate) {
            this.internalLoop = 0;
        }
        if (this.internalLoop == 0 || sizeChanged) {
            this.drawChart(sizeChanged);
        }
        GC gc = new GC((Drawable)this.drawCanvas);
        gc.drawImage(this.bufferImage, bounds.x, bounds.y);
        gc.dispose();
    }

    protected void drawChart(boolean sizeChanged) {
        try {
            this.this_mon.enter();
            this.drawScale(sizeChanged);
            Rectangle bounds = this.drawCanvas.getClientArea();
            if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
                this.bufferImage.dispose();
            }
            this.bufferImage = new Image((Device)this.drawCanvas.getDisplay(), bounds);
            GC gcImage = new GC((Drawable)this.bufferImage);
            gcImage.drawImage(this.bufferScale, 0, 0);
            int oldAverage = 0;
            int oldTargetValue = 0;
            Color background = Colors.blues[9];
            Color foreground = Colors.blues[2];
            int max = 0;
            int x = 0;
            while (x < bounds.width - 71) {
                int value;
                int position = this.currentPosition - x - 1;
                if (position < 0) {
                    position += 2000;
                }
                if ((value = this.values[position]) > max) {
                    max = value;
                }
                if ((value = this.targetValues[position]) > max) {
                    max = value;
                }
                ++x;
            }
            this.scale.setMax(max);
            int maxHeight = this.scale.getScaledValue(max);
            int x2 = 0;
            while (x2 < bounds.width - 71) {
                int position = this.currentPosition - x2 - 1;
                if (position < 0) {
                    position += 2000;
                }
                int value = this.values[position];
                int xDraw = bounds.width - 71 - x2;
                int height = this.scale.getScaledValue(value);
                gcImage.setForeground(background);
                gcImage.setBackground(foreground);
                gcImage.setClipping(xDraw, bounds.height - 1 - height, 1, height);
                gcImage.fillGradientRectangle(xDraw, bounds.height - 1 - maxHeight, 1, maxHeight, true);
                gcImage.setClipping(0, 0, bounds.width, bounds.height);
                int targetValue = this.targetValues[position];
                if (x2 > 1 && targetValue > 0) {
                    int h1 = bounds.height - this.scale.getScaledValue(targetValue) - 2;
                    int h2 = bounds.height - this.scale.getScaledValue(oldTargetValue) - 2;
                    gcImage.setForeground(Colors.blue);
                    gcImage.drawLine(xDraw, h1, xDraw + 1, h2);
                }
                oldTargetValue = targetValue;
                int average = this.computeAverage(position);
                if (x2 > 6) {
                    int h1 = bounds.height - this.scale.getScaledValue(average) - 2;
                    int h2 = bounds.height - this.scale.getScaledValue(oldAverage) - 2;
                    gcImage.setForeground(Colors.red);
                    gcImage.drawLine(xDraw, h1, xDraw + 1, h2);
                }
                oldAverage = average;
                ++x2;
            }
            if (this.nbValues > 0) {
                int height = bounds.height - this.scale.getScaledValue(this.computeAverage(this.currentPosition - 6)) - 2;
                gcImage.setForeground(Colors.red);
                gcImage.drawText(this.formater.format(this.computeAverage(this.currentPosition - 6)), bounds.width - 65, height - 12, true);
            }
            gcImage.dispose();
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected int computeAverage(int position) {
        int sum = 0;
        int i = -5;
        while (i < 6) {
            int pos = position + i;
            if (pos < 0) {
                pos += 2000;
            }
            if (pos >= 2000) {
                pos -= 2000;
            }
            sum += this.values[pos];
            ++i;
        }
        return sum / 11;
    }

    public void parameterChanged(String parameter) {
        this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
    }

    public void dispose() {
        super.dispose();
        if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
            this.bufferImage.dispose();
        }
        COConfigurationManager.removeParameterListener("Graphics Update", this);
    }
}

