/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class URLTransfer
extends ByteArrayTransfer {
    private static URLTransfer _instance = new URLTransfer();
    private static final String[] supportedTypes = new String[]{"UniformResourceLocator", "UniformResourceLocator", "CF_UNICODETEXT", "CF_TEXT"};
    private static final int[] supportedTypeIds = new int[]{49367, 49362, 13, 1};

    public static URLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof URLType[])) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            URLType[] myTypes = (URLType[])object;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream writeOut = new DataOutputStream(out);
                int i = 0;
                int length = myTypes.length;
                while (i < length) {
                    writeOut.writeBytes(myTypes[i].linkURL);
                    writeOut.writeBytes("\n");
                    writeOut.writeBytes(myTypes[i].linkText);
                    ++i;
                }
                byte[] buffer = out.toByteArray();
                writeOut.close();
                super.javaToNative((Object)buffer, transferData);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            URLType myData = null;
            try {
                URLType datum = new URLType();
                byte[] text = new byte[buffer.length];
                int j = 0;
                int i = 0;
                while (i < buffer.length) {
                    if (buffer[i] != 0) {
                        text[j++] = buffer[i];
                    }
                    ++i;
                }
                String data = new String(text, 0, j);
                int end = data.indexOf("\n");
                if (end >= 0) {
                    datum.linkURL = data.substring(0, end++);
                    datum.linkText = end == data.length() ? "" : data.substring(end);
                } else {
                    datum.linkURL = data;
                    datum.linkText = "";
                }
                myData = datum;
            }
            catch (Exception ex) {
                return null;
            }
            return myData;
        }
        return null;
    }

    protected String[] getTypeNames() {
        return supportedTypes;
    }

    protected int[] getTypeIds() {
        return supportedTypeIds;
    }

    public boolean isSupportedType(TransferData transferData) {
        if (transferData != null) {
            int i = 0;
            while (i < supportedTypeIds.length) {
                if (transferData.type == supportedTypeIds[i]) {
                    return true;
                }
                ++i;
            }
        }
        return super.isSupportedType(transferData);
    }

    public class URLType {
        public String linkURL;
        public String linkText;

        public String toString() {
            return String.valueOf(this.linkURL) + "\n" + this.linkText;
        }
    }
}

