/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.utils;

import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.utils.ShortCuts;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestDispatcher;
import org.gudy.azureus2.pluginsimpl.remote.download.RPDownload;
import org.gudy.azureus2.pluginsimpl.remote.download.RPDownloadStats;

public class RPShortCuts
extends RPObject
implements ShortCuts {
    protected transient ShortCuts delegate;

    public static RPShortCuts create(ShortCuts _delegate) {
        RPShortCuts res = (RPShortCuts)RPObject._lookupLocal(_delegate);
        if (res == null) {
            res = new RPShortCuts(_delegate);
        }
        return res;
    }

    protected RPShortCuts(ShortCuts _delegate) {
        super(_delegate);
    }

    protected void _setDelegate(Object _delegate) {
        this.delegate = (ShortCuts)_delegate;
    }

    public Object _setLocal() throws RPException {
        Object res = this._fixupLocal();
        return res;
    }

    public void _setRemote(RPRequestDispatcher _dispatcher) {
        super._setRemote(_dispatcher);
    }

    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        Object[] params = request2.getParams();
        if (method.equals("getDownload[byte[]]")) {
            try {
                return new RPReply(RPDownload.create(this.delegate.getDownload((byte[])params[0])));
            }
            catch (DownloadException e) {
                return new RPReply(e);
            }
        }
        if (method.equals("getDownloadStats[byte[]]")) {
            try {
                return new RPReply(RPDownloadStats.create(this.delegate.getDownloadStats((byte[])params[0])));
            }
            catch (DownloadException e) {
                return new RPReply(e);
            }
        }
        if (method.equals("restartDownload[byte[]]")) {
            try {
                this.delegate.restartDownload((byte[])params[0]);
            }
            catch (DownloadException e) {
                return new RPReply(e);
            }
            return null;
        }
        if (method.equals("stopDownload[byte[]]")) {
            try {
                this.delegate.stopDownload((byte[])params[0]);
            }
            catch (DownloadException e) {
                return new RPReply(e);
            }
            return null;
        }
        if (method.equals("removeDownload[byte[]]")) {
            try {
                this.delegate.removeDownload((byte[])params[0]);
            }
            catch (Throwable e) {
                return new RPReply(e);
            }
            return null;
        }
        throw new RPException("Unknown method: " + method);
    }

    public Download getDownload(byte[] hash) throws DownloadException {
        try {
            RPDownload res = (RPDownload)this._dispatcher.dispatch(new RPRequest(this, "getDownload[byte[]]", new Object[]{hash})).getResponse();
            res._setRemote(this._dispatcher);
            return res;
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    public DownloadStats getDownloadStats(byte[] hash) throws DownloadException {
        try {
            RPDownloadStats res = (RPDownloadStats)this._dispatcher.dispatch(new RPRequest(this, "getDownloadStats[byte[]]", new Object[]{hash})).getResponse();
            res._setRemote(this._dispatcher);
            return res;
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    public void restartDownload(byte[] hash) throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "restartDownload[byte[]]", new Object[]{hash})).getResponse();
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    public void stopDownload(byte[] hash) throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "stopDownload[byte[]]", new Object[]{hash})).getResponse();
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    public void removeDownload(byte[] hash) throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "removeDownload[byte[]]", new Object[]{hash})).getResponse();
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }
}

