/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderURLImpl
extends ResourceDownloaderBaseImpl
implements SEPasswordListener {
    private static final int BUFFER_SIZE = 32768;
    protected URL original_url;
    protected boolean auth_supplied;
    protected String user_name;
    protected String password;
    protected InputStream input_stream;
    protected boolean cancel_download = false;
    protected boolean download_initiated;
    protected long size = -2L;

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url) {
        this(_parent, _url, false, null, null);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, String _user_name, String _password) {
        this(_parent, _url, true, _user_name, _password);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, boolean _auth_supplied, String _user_name, String _password) {
        super(_parent);
        this.original_url = _url;
        this.auth_supplied = _auth_supplied;
        this.user_name = _user_name;
        this.password = _password;
    }

    protected URL getURL() {
        return this.original_url;
    }

    public String getName() {
        return this.original_url.toString();
    }

    public long getSize() throws ResourceDownloaderException {
        if (this.size == -2L) {
            try {
                ResourceDownloaderURLImpl c = (ResourceDownloaderURLImpl)this.getClone(this);
                this.addReportListener(c);
                this.size = c.getSizeSupport();
            }
            finally {
                if (this.size == -2L) {
                    this.size = -1L;
                }
            }
        }
        return this.size;
    }

    protected void setSize(long l) {
        this.size = l;
    }

    protected long getSizeSupport() throws ResourceDownloaderException {
        try {
            this.reportActivity(this, "getting size of " + this.original_url);
            try {
                URL url = new URL(this.original_url.toString().replaceAll(" ", "%20"));
                try {
                    HttpURLConnection con;
                    if (this.auth_supplied) {
                        SESecurityManager.addPasswordHandler(url, this);
                    }
                    if (url.getProtocol().equalsIgnoreCase("https")) {
                        HttpsURLConnection ssl_con = (HttpsURLConnection)url.openConnection();
                        ssl_con.setHostnameVerifier(new HostnameVerifier(){

                            public boolean verify(String host, SSLSession session) {
                                return true;
                            }
                        });
                        con = ssl_con;
                    } else {
                        con = (HttpURLConnection)url.openConnection();
                    }
                    con.setRequestMethod("HEAD");
                    con.setRequestProperty("User-Agent", "Azureus 2.2.0.2");
                    con.connect();
                    int response = con.getResponseCode();
                    if (response != 202 && response != 200) {
                        throw new ResourceDownloaderException("Error on connect for '" + url.toString() + "': " + Integer.toString(response) + " " + con.getResponseMessage());
                    }
                    long l = con.getContentLength();
                    if (this.auth_supplied) {
                        SESecurityManager.removePasswordHandler(url, this);
                    }
                    return l;
                }
                catch (Throwable throwable) {
                    if (this.auth_supplied) {
                        SESecurityManager.removePasswordHandler(url, this);
                    }
                    throw throwable;
                }
            }
            catch (MalformedURLException e) {
                throw new ResourceDownloaderException("Exception while parsing URL '" + this.original_url + "':" + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new ResourceDownloaderException("Exception while initializing download of '" + this.original_url + "': Unknown Host '" + e.getMessage() + "'", e);
            }
            catch (IOException e) {
                throw new ResourceDownloaderException("I/O Exception while downloading '" + this.original_url + "':" + e.toString(), e);
            }
        }
        catch (Throwable e) {
            ResourceDownloaderException rde = e instanceof ResourceDownloaderException ? (ResourceDownloaderException)e : new ResourceDownloaderException("Unexpected error", e);
            throw rde;
        }
    }

    public ResourceDownloader getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloaderURLImpl c = new ResourceDownloaderURLImpl(parent, this.original_url, this.auth_supplied, this.user_name, this.password);
        c.setSize(this.size);
        return c;
    }

    public void asyncDownload() {
        AEThread t = new AEThread("ResourceDownloader:asyncDownload"){

            public void runSupport() {
                try {
                    ResourceDownloaderURLImpl.this.download();
                }
                catch (ResourceDownloaderException resourceDownloaderException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public InputStream download() throws ResourceDownloaderException {
        try {
            this.reportActivity(this, String.valueOf(this.getLogIndent()) + "Downloading: " + this.original_url);
            try {
                this.this_mon.enter();
                if (this.download_initiated) {
                    throw new ResourceDownloaderException("Download already initiated");
                }
                this.download_initiated = true;
            }
            finally {
                this.this_mon.exit();
            }
            try {
                block33: {
                    URL url = new URL(this.original_url.toString().replaceAll(" ", "%20"));
                    if (url.getPort() == -1) {
                        int target_port = url.getProtocol().toLowerCase().equals("http") ? 80 : 443;
                        try {
                            String str = this.original_url.toString().replaceAll(" ", "%20");
                            int pos = str.indexOf("://");
                            pos = str.indexOf("/", pos + 4);
                            url = new URL(String.valueOf(str.substring(0, pos)) + ":" + target_port + str.substring(pos));
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    try {
                        ByteArrayOutputStream baos;
                        HttpURLConnection con;
                        if (this.auth_supplied) {
                            SESecurityManager.addPasswordHandler(url, this);
                        }
                        if (url.getProtocol().equalsIgnoreCase("https")) {
                            HttpsURLConnection ssl_con = (HttpsURLConnection)url.openConnection();
                            ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                public boolean verify(String host, SSLSession session) {
                                    return true;
                                }
                            });
                            con = ssl_con;
                        } else {
                            con = (HttpURLConnection)url.openConnection();
                        }
                        con.setRequestProperty("User-Agent", "Azureus 2.2.0.2");
                        con.connect();
                        int response = con.getResponseCode();
                        if (response != 202 && response != 200) {
                            throw new ResourceDownloaderException("Error on connect for '" + url.toString() + "': " + Integer.toString(response) + " " + con.getResponseMessage());
                        }
                        try {
                            this.this_mon.enter();
                            this.input_stream = con.getInputStream();
                        }
                        finally {
                            this.this_mon.exit();
                        }
                        try {
                            byte[] buf = new byte[32768];
                            int total_read = 0;
                            int size = con.getContentLength();
                            baos = size > 0 ? new ByteArrayOutputStream(size) : new ByteArrayOutputStream();
                            while (!this.cancel_download) {
                                int read = this.input_stream.read(buf);
                                if (read <= 0) break;
                                baos.write(buf, 0, read);
                                total_read += read;
                                if (size <= 0) continue;
                                this.informPercentDone(100 * total_read / size);
                            }
                            if (size > 0 && total_read != size) {
                                throw new IOException("Premature end of stream");
                            }
                        }
                        finally {
                            this.input_stream.close();
                        }
                        ByteArrayInputStream res = new ByteArrayInputStream(baos.toByteArray());
                        if (!this.informComplete(res)) break block33;
                        ByteArrayInputStream byteArrayInputStream = res;
                        if (this.auth_supplied) {
                            SESecurityManager.removePasswordHandler(url, this);
                        }
                        return byteArrayInputStream;
                    }
                    catch (Throwable throwable) {
                        if (this.auth_supplied) {
                            SESecurityManager.removePasswordHandler(url, this);
                        }
                        throw throwable;
                    }
                }
                throw new ResourceDownloaderException("Contents downloaded but rejected: '" + this.original_url + "'");
            }
            catch (MalformedURLException e) {
                throw new ResourceDownloaderException("Exception while parsing URL '" + this.original_url + "':" + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new ResourceDownloaderException("Exception while initializing download of '" + this.original_url + "': Unknown Host '" + e.getMessage() + "'", e);
            }
            catch (IOException e) {
                throw new ResourceDownloaderException("I/O Exception while downloading '" + this.original_url + "':" + e.toString(), e);
            }
        }
        catch (Throwable e) {
            ResourceDownloaderException rde = e instanceof ResourceDownloaderException ? (ResourceDownloaderException)e : new ResourceDownloaderException("Unexpected error", e);
            this.informFailed(rde);
            throw rde;
        }
    }

    public void cancel() {
        this.setCancelled();
        this.cancel_download = true;
        try {
            this.this_mon.enter();
            if (this.input_stream != null) {
                try {
                    this.input_stream.close();
                }
                catch (Throwable e) {}
            }
        }
        finally {
            this.this_mon.exit();
        }
        this.informFailed(new ResourceDownloaderException("Download cancelled"));
    }

    public PasswordAuthentication getAuthentication(String realm, URL tracker) {
        if (this.user_name == null || this.password == null) {
            String user_info = tracker.getUserInfo();
            if (user_info == null) {
                return null;
            }
            String user_bit = user_info;
            String pw_bit = "";
            int pos = user_info.indexOf(58);
            if (pos != -1) {
                user_bit = user_info.substring(0, pos);
                pw_bit = user_info.substring(pos + 1);
            }
            return new PasswordAuthentication(user_bit, pw_bit.toCharArray());
        }
        return new PasswordAuthentication(this.user_name, this.password.toCharArray());
    }

    public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
    }
}

