/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.security.SEKeyDetails;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.jar.AEJarSigner2;

public class AEJarBuilder {
    public static long buildFromPackages(OutputStream os, ClassLoader class_loader, String[] package_names, Map package_map, String sign_alias) throws IOException {
        ArrayList<String> resource_names = new ArrayList<String>();
        int i = 0;
        while (i < package_names.length) {
            List entries = (List)package_map.get(package_names[i]);
            if (entries == null) {
                Debug.out("package '" + package_names[i] + "' missing");
            } else {
                int j = 0;
                while (j < entries.size()) {
                    resource_names.add(String.valueOf(package_names[i]) + "/" + entries.get(j));
                    ++j;
                }
            }
            ++i;
        }
        String[] res = new String[resource_names.size()];
        resource_names.toArray(res);
        return AEJarBuilder.buildFromResources2(os, class_loader, null, res, sign_alias);
    }

    public static void buildFromResources(OutputStream os, ClassLoader class_loader, String resource_prefix, String[] resource_names, String sign_alias) throws IOException {
        AEJarBuilder.buildFromResources2(os, class_loader, resource_prefix, resource_names, sign_alias);
    }

    private static long buildFromResources2(OutputStream os, ClassLoader class_loader, String resource_prefix, String[] resource_names, String sign_alias) throws IOException {
        if (sign_alias != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);
            long tim = AEJarBuilder.buildFromResourcesSupport(new JarOutputStream(baos), class_loader, resource_prefix, resource_names);
            try {
                SEKeyDetails kd = SESecurityManager.getKeyDetails(sign_alias);
                if (kd == null) {
                    LGLogger.logUnrepeatableAlert(3, "Certificate alias '" + sign_alias + "' not found, jar signing fails");
                    throw new Exception("Certificate alias '" + sign_alias + "' not found ");
                }
                AEJarSigner2 signer = new AEJarSigner2(sign_alias, SESecurityManager.getKeystoreName(), SESecurityManager.getKeystorePassword());
                signer.signJarStream(new ByteArrayInputStream(baos.toByteArray()), os);
                return tim;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                throw new IOException(e.getMessage());
            }
        }
        JarOutputStream jos = os instanceof JarOutputStream ? (JarOutputStream)os : new JarOutputStream(os);
        return AEJarBuilder.buildFromResourcesSupport(jos, class_loader, resource_prefix, resource_names);
    }

    public static long buildFromResourcesSupport(JarOutputStream jos, ClassLoader class_loader, String resource_prefix, String[] resource_names) throws IOException {
        long latest_time = 0L;
        long now = SystemTime.getCurrentTime();
        int i = 0;
        while (i < resource_names.length) {
            block16: {
                String resource_name = resource_names[i];
                if (resource_prefix != null) {
                    resource_name = String.valueOf(resource_prefix) + "/" + resource_name;
                }
                InputStream is = null;
                try {
                    is = class_loader.getResourceAsStream(resource_name);
                    if (is == null) {
                        Debug.out("WUJarBuilder: failed to find resource '" + resource_name + "'");
                        break block16;
                    }
                    URL url = class_loader.getResource(resource_name);
                    try {
                        File file = null;
                        if (url != null) {
                            String url_str = url.toString();
                            if (url_str.startsWith("jar:file:")) {
                                file = FileUtil.getJarFileFromURL(url_str);
                            } else if (url_str.startsWith("file:")) {
                                file = new File(URI.create(url_str));
                            }
                        }
                        if (file == null) {
                            latest_time = now;
                        } else {
                            long time = file.lastModified();
                            if (time > latest_time) {
                                latest_time = time;
                            }
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    JarEntry entry2 = new JarEntry(resource_name);
                    AEJarBuilder.writeEntry(jos, entry2, is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            ++i;
        }
        JarEntry entry3 = new JarEntry("META-INF/MANIFEST.MF");
        ByteArrayInputStream bais = new ByteArrayInputStream("Manifest-Version: 1.0\r\n\r\n".getBytes());
        AEJarBuilder.writeEntry(jos, entry3, bais);
        jos.flush();
        jos.finish();
        return latest_time;
    }

    private static void writeEntry(JarOutputStream jos, JarEntry entry2, InputStream data) throws IOException {
        jos.putNextEntry(entry2);
        byte[] newBytes = new byte[4096];
        int size = data.read(newBytes);
        while (size != -1) {
            jos.write(newBytes, 0, size);
            size = data.read(newBytes);
        }
    }
}

