/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentImpl;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;

public class TOTorrentXMLSerialiser
extends XUXmlWriter {
    protected TOTorrentImpl torrent;

    protected TOTorrentXMLSerialiser(TOTorrentImpl _torrent) {
        this.torrent = _torrent;
    }

    protected void serialiseToFile(File file) throws TOTorrentException {
        this.resetIndent();
        try {
            try {
                this.setOutputStream(new FileOutputStream(file));
                this.writeRoot();
            }
            catch (IOException e) {
                throw new TOTorrentException("TOTorrentXMLSerialiser: file write fails: " + e.toString(), 5);
            }
        }
        finally {
            try {
                this.closeOutputStream();
            }
            catch (Throwable e) {
                throw new TOTorrentException("TOTorrentXMLSerialiser: file close fails: " + e.toString(), 5);
            }
        }
    }

    protected void writeRoot() throws TOTorrentException {
        this.writeLineRaw("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writeLineRaw("<tor:TORRENT");
        this.writeLineRaw("\txmlns:tor=\"http://azureus.sourceforge.net/files\"");
        this.writeLineRaw("\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        this.writeLineRaw("\txsi:schemaLocation=\"http://azureus.sourceforge.net/files http://azureus.sourceforge.net/files/torrent.xsd\">");
        try {
            byte[] created_by;
            long creation_date;
            byte[] comment;
            this.indent();
            this.writeTag("ANNOUNCE_URL", this.torrent.getAnnounceURL().toString());
            TOTorrentAnnounceURLSet[] sets = this.torrent.getAnnounceURLGroup().getAnnounceURLSets();
            if (sets.length > 0) {
                this.writeLineRaw("<ANNOUNCE_LIST>");
                try {
                    this.indent();
                    int i = 0;
                    while (i < sets.length) {
                        TOTorrentAnnounceURLSet set = sets[i];
                        URL[] urls = set.getAnnounceURLs();
                        this.writeLineRaw("<ANNOUNCE_ENTRY>");
                        try {
                            this.indent();
                            int j = 0;
                            while (j < urls.length) {
                                this.writeTag("ANNOUNCE_URL", urls[j].toString());
                                ++j;
                            }
                        }
                        finally {
                            this.exdent();
                        }
                        this.writeLineRaw("</ANNOUNCE_ENTRY>");
                        ++i;
                    }
                }
                finally {
                    this.exdent();
                }
                this.writeLineRaw("</ANNOUNCE_LIST>");
            }
            if ((comment = this.torrent.getComment()) != null) {
                this.writeLocalisableTag("COMMENT", comment);
            }
            if ((creation_date = this.torrent.getCreationDate()) != 0L) {
                this.writeTag("CREATION_DATE", creation_date);
            }
            if ((created_by = this.torrent.getCreatedBy()) != null) {
                this.writeLocalisableTag("CREATED_BY", created_by);
            }
            this.writeTag("TORRENT_HASH", this.torrent.getHash());
            this.writeInfo();
            Map additional_properties = this.torrent.getAdditionalProperties();
            Iterator it = additional_properties.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.writeGenericMapEntry(key, additional_properties.get(key));
            }
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</tor:TORRENT>");
    }

    protected void writeInfo() throws TOTorrentException {
        this.writeLineRaw("<INFO>");
        try {
            this.indent();
            this.writeLocalisableTag("NAME", this.torrent.getName());
            this.writeTag("PIECE_LENGTH", this.torrent.getPieceLength());
            TOTorrentFileImpl[] files = (TOTorrentFileImpl[])this.torrent.getFiles();
            if (this.torrent.isSimpleTorrent()) {
                TOTorrentFileImpl file = files[0];
                this.writeTag("LENGTH", files[0].getLength());
            } else {
                this.writeLineRaw("<FILES>");
                try {
                    this.indent();
                    int i = 0;
                    while (i < files.length) {
                        this.writeLineRaw("<FILE>");
                        try {
                            this.indent();
                            TOTorrentFileImpl file = files[i];
                            this.writeTag("LENGTH", file.getLength());
                            this.writeLineRaw("<PATH>");
                            try {
                                this.indent();
                                byte[][] path_comps = file.getPathComponents();
                                int j = 0;
                                while (j < path_comps.length) {
                                    this.writeLocalisableTag("COMPONENT", path_comps[j]);
                                    ++j;
                                }
                            }
                            finally {
                                this.exdent();
                            }
                            this.writeLineRaw("</PATH>");
                            Map additional_properties = file.getAdditionalProperties();
                            Iterator prop_it = additional_properties.keySet().iterator();
                            while (prop_it.hasNext()) {
                                String key = (String)prop_it.next();
                                this.writeGenericMapEntry(key, additional_properties.get(key));
                            }
                        }
                        finally {
                            this.exdent();
                        }
                        this.writeLineRaw("</FILE>");
                        ++i;
                    }
                }
                finally {
                    this.exdent();
                }
                this.writeLineRaw("</FILES>");
            }
            this.writeLineRaw("<PIECES>");
            try {
                this.indent();
                byte[][] pieces = this.torrent.getPieces();
                int i = 0;
                while (i < pieces.length) {
                    this.writeGeneric(pieces[i]);
                    ++i;
                }
            }
            finally {
                this.exdent();
            }
            this.writeLineRaw("</PIECES>");
            Map additional_properties = this.torrent.getAdditionalInfoProperties();
            Iterator it = additional_properties.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.writeGenericMapEntry(key, additional_properties.get(key));
            }
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</INFO>");
    }

    protected void writeGenericMapEntry(String name, Object value) throws TOTorrentException {
        this.writeLineRaw("<KEY name=\"" + this.escapeXML(name) + "\">");
        try {
            this.indent();
            this.writeGeneric(value);
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</KEY>");
    }

    protected void writeGeneric(Object obj) throws TOTorrentException {
        if (obj instanceof Map) {
            this.writeGeneric((Map)obj);
        } else if (obj instanceof List) {
            this.writeGeneric((List)obj);
        } else if (obj instanceof byte[]) {
            this.writeGeneric((byte[])obj);
        } else {
            this.writeGeneric((Long)obj);
        }
    }

    protected void writeGeneric(Map map) throws TOTorrentException {
        this.writeLineRaw("<MAP>");
        try {
            this.indent();
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.writeGenericMapEntry(key, map.get(key));
            }
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</MAP>");
    }

    protected void writeGeneric(List list) throws TOTorrentException {
        this.writeLineRaw("<LIST>");
        try {
            this.indent();
            int i = 0;
            while (i < list.size()) {
                this.writeGeneric(list.get(i));
                ++i;
            }
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</LIST>");
    }

    protected void writeGeneric(byte[] bytes) throws TOTorrentException {
        this.writeTag("BYTES", this.encodeBytes(bytes));
    }

    protected void writeGeneric(Long l) {
        this.writeTag("LONG", "" + l);
    }

    protected void writeTag(String tag, byte[] content) throws TOTorrentException {
        this.writeLineRaw("<" + tag + ">" + this.encodeBytes(content) + "</" + tag + ">");
    }

    protected void writeLocalisableTag(String tag, byte[] content) throws TOTorrentException {
        boolean use_bytes = true;
        String utf_string = null;
        try {
            utf_string = new String(content, "UTF8");
            if (Arrays.equals(content, utf_string.getBytes("UTF8"))) {
                use_bytes = false;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.writeLineRaw("<" + tag + " encoding=\"" + (use_bytes ? "bytes" : "utf8") + "\">" + (use_bytes ? this.encodeBytes(content) : this.escapeXML(utf_string)) + "</" + tag + ">");
    }

    protected String encodeBytes(byte[] bytes) throws TOTorrentException {
        String data = ByteFormatter.nicePrint(bytes, true);
        return data;
    }

    protected String getUTF(byte[] bytes) {
        try {
            return new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
            return "";
        }
    }
}

